--TEST--
Tests maxdb_query()
--SKIPIF--
<?php require 'skipif.inc'; ?>
--FILE--
<?php
$tc = "maxdb_query_001";
$link = maxdb_connect("localhost");
maxdb_report (MAXDB_REPORT_OFF);
maxdb_query($link,"DROP TABLE maxdb_query_001");
maxdb_report (MAXDB_REPORT_ERROR);

$cmds = array (
         "create table ".$tc." ("
        ."  C_CHARASCII    Char (1) ASCII NOT NULL,"
        ."  C_CHARBYTE     Char (1) BYTE,"
        ."  C_VARCHARASCII  Varchar (1) ASCII,"
        ."  C_VARCHARBYTE   Varchar (1) BYTE,"
        ."  C_INT          Integer,"
        ."  C_SMALINT      Smallint,"
        ."  C_FLOAT        Float (5),"
        ."  C_FIXED        Fixed (5),"
        ."  C_FIXED1       Fixed (5,5),"
        ."  C_BOOLEAN      Boolean,"
        ."  C_DATE         Date,"
        ."  C_TIME         Time,"
        ."  C_TIMESTAMP    Timestamp,"
        ."  C_LONGASCII    Long ASCII,"
        ."  C_LONGBYTE     Long BYTE"
        .")",
        
         "insert into ".$tc." values ( "
        ." 'A',"
        ."  x'41',"
        ."  'B',"
        ."  x'42',"
        ."  42,"
        ."  42,"
        ."  42.42,"
        ."  42,"
        ."  0.12345,"
        ."  TRUE,"
        ."  '1973-06-07',"
        ."  '14:30:08',"
        ."  '1999-01-23 14:30:08.456234',"
        ."  'ABCDEFGHIJKLMNOPQRSTUVWXYZ',"
        ."  null"
        .")"
       );   

foreach($cmds as $cmd){   
  maxdb_query($link, $cmd);
}
maxdb_commit($link);
$cmd = "Select * from ".$tc;
if ($result = maxdb_query($link, $cmd)) {
    while ($row = maxdb_fetch_assoc($result)) {

        $lengths = maxdb_fetch_lengths($result);
        for ($i=0; $i < count($lengths); $i++) {
           printf("Field %2d has Length %2d\n", $i+1, $lengths[$i]);
        }


        printf ("%s\n", $row["C_CHARASCII"]);
        printf ("%s\n", $row["C_CHARBYTE"]);
        printf ("%s\n", $row["C_VARCHARASCII"]);
        printf ("%s\n", $row["C_VARCHARBYTE"]);
        printf ("%s\n", $row["C_INT"]);
        printf ("%s\n", $row["C_SMALINT"]);
        printf ("%s\n", $row["C_FLOAT"]);
        printf ("%s\n", $row["C_FIXED"]);
        printf ("%s\n", $row["C_FIXED1"]);
        printf ("%s\n", $row["C_BOOLEAN"]);
        printf ("%s\n", $row["C_DATE"]);
        printf ("%s\n", $row["C_TIME"]);
        printf ("%s\n", $row["C_TIMESTAMP"]);
        printf ("%s\n", $row["C_LONGASCII"]);
        printf ("%s\n", $row["C_LONGBYTE"]);
    }

    /* free result set */ 
    maxdb_free_result($result);
}

maxdb_close($link);

?>
--EXPECT--
Field  1 has Length  1
Field  2 has Length  1
Field  3 has Length  1
Field  4 has Length  1
Field  5 has Length  4
Field  6 has Length  4
Field  7 has Length  8
Field  8 has Length  2
Field  9 has Length  8
Field 10 has Length  1
Field 11 has Length 10
Field 12 has Length  8
Field 13 has Length 26
Field 14 has Length 26
Field 15 has Length -1
A
A
B
B
42
42
42.42
42
0.12345
1
1973-06-07
14:30:08
1999-01-23 14:30:08.456234
ABCDEFGHIJKLMNOPQRSTUVWXYZ

