--TEST--
maxdb db proc
--SKIPIF--
<?php require 'skipif.inc'; ?>
--FILE--
<?php
include "connect.inc";

$link = maxdb_connect("localhost", $user, $passwd);
   
/* check connection */
if (maxdb_connect_errno()) {
   printf("Connect failed: %s\n", maxdb_connect_error());
   exit();
}

maxdb_report (MAXDB_REPORT_OFF);
maxdb_query($link,"DROP DBPROC avg_price");
maxdb_report (MAXDB_REPORT_ERROR);

$query = "CREATE DBPROC avg_price (IN zip CHAR(5), OUT avg_price FIXED(6,2)) AS ";
$query .= "VAR sum FIXED(10,2); price FIXED(6,2); hotels INTEGER; ";
$query .= "TRY ";
$query .= "SET sum = 0; SET hotels = 0;";
$query .= "DECLARE dbproccursor CURSOR FOR ";
$query .= "SELECT price FROM hotel.room,hotel.hotel WHERE zip = :zip AND ";
$query .= "room.hno = hotel.hno AND type = 'single';";
$query .= "WHILE \$rc = 0 DO BEGIN ";
$query .= "FETCH dbproccursor INTO :price;";
$query .= "SET sum = sum + price;";
$query .= "SET hotels = hotels + 1;";
$query .= "END;";
$query .= "CATCH ";
$query .= "IF \$rc <> 100 THEN STOP (\$rc, 'unexpected error');";
$query .= "CLOSE dbproccursor;";
$query .= "IF hotels > 0 THEN SET avg_price = sum / hotels ";
$query .= "ELSE STOP (100, 'no hotel found');";

maxdb_query($link, $query);

/* Performing SQL query */
$stmt = maxdb_prepare ($link, "CALL avg_price (?, ?)");
if (!$stmt) {
  printf ("Prepare failed: %s\n", maxdb_error($link));
}

$zip = "20005";
maxdb_stmt_bind_param($stmt, 'sd', $zip, $price);
maxdb_stmt_execute($stmt);

printf ("%f\n", $price);

maxdb_stmt_close ($stmt);
?>
--EXPECT--
135.000000

