--TEST--
maxdb_bind_param (UPDATE)
--FILE--
<?php
	include "connect.inc";
	
	/*** test maxdb_connect 127.0.0.1 ***/
	$link = maxdb_connect("localhost", $user, $passwd);

	maxdb_select_db($link, $db);

        maxdb_report (MAXDB_REPORT_OFF);
  	maxdb_query($link,"DROP TABLE test_update");
        maxdb_report (MAXDB_REPORT_ERROR);
  	maxdb_query($link,"CREATE TABLE test_update(a varchar(10),
                                                     b int)");

	maxdb_query($link, "INSERT INTO test_update VALUES ('foo', 2)");

	$stmt = maxdb_prepare($link, "UPDATE test_update SET a=?,b=? WHERE b=?");
	maxdb_bind_param($stmt, "sii", $c1, $c2, $c3);

	$c1 = "Rasmus";
	$c2 = 1;
	$c3 = 2;

	maxdb_execute($stmt);
	maxdb_stmt_close($stmt);

	$result = maxdb_query($link, "SELECT a & ' is No. ' & b FROM test_update");
	$test = maxdb_fetch_row($result);
	maxdb_free_result($result);

	var_dump($test);

	maxdb_close($link);
?>
--EXPECT--
array(1) {
  [0]=>
  string(15) "Rasmus is No. 1"
}
