#include <errno.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>

#include "npsummary.h"

gint remove_button_callback( GtkWidget *widget, GdkEvent *event )
{
   gtk_menu_popup( GTK_MENU( widget ), NULL, NULL, NULL, NULL,
                   (( GdkEventButton *)event )->button,
                   (( GdkEventButton *)event )->time );

   return TRUE;
}

void remove_all_callback( GtkWidget *widget, gpointer data )
{
   NP_Summary *summary = ( NP_Summary *)data;

   if ( !summary->total )
   {
      summary->show_message( "No message in the list is selected." );
      return;
   }
   
   char *home, deleted_path[ 1024 ];
   snprintf( deleted_path, sizeof deleted_path, "%s/.peruser_spool/DELETED",
             home = getenv( "HOME" ));

   char spool_path[ 1024 ];
   snprintf( spool_path, sizeof spool_path, "%s/.peruser_spool/%s-%s",
             home, summary->server, summary->group );

   char read_path[ 1024 ];
   snprintf( read_path, sizeof read_path, "%s:read", spool_path );

   NP_File del, spool;

   if ( del.opena( deleted_path ))
   {
      del.print_error();
      return;
   }

   if ( spool.openr( spool_path ))
   {
      spool.print_error();
      return;
   }

   for( np_thread_node_t *pointer = summary->spool_beginning;
        pointer != NULL;
        pointer = pointer->spool_next )
   {        
      char *line, buffer[ 1024 ];
      snprintf( buffer, sizeof buffer, "%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n",
                summary->server, summary->group,
                pointer->subject, pointer->from, pointer->date );

      if ( del.put_string( buffer ))
         del.print_error();

      do
      {
         line = spool.get_string();
         if ( line == NULL )
            break;

         if ( del.put_string( line ))
         {
            del.print_error();
            return;
         }
      }
      while( strncmp( line, ".\r\n", 3 ));
   }      

   del.close();
   spool.close();

   truncate( spool_path, 0 );
   truncate( read_path, 0 );

   if ( !summary->is_stdout_a_tty )
      kill( getppid(), SIGUSR1 );

   return;
}

void remove_current_callback( GtkWidget *widget, gpointer data )
{
   NP_Summary *summary = ( NP_Summary *)data;

   if ( !summary->total || summary->selected_item == NULL ||
        summary->current_node == NULL ||
        summary->current_node->is_article == -1 )
   {
      summary->show_message( "No message in the list is selected." );
      return;
   }

   summary->write_read_file();

   char *home, deleted_path[ 1024 ];
   snprintf( deleted_path, sizeof deleted_path, "%s/.peruser_spool/DELETED",
             home = getenv( "HOME" ));

   char spool_path[ 1024 ];
   snprintf( spool_path, sizeof spool_path, "%s/.peruser_spool/%s-%s",
             home, summary->server, summary->group );


   char read_path[ 1024 ];
   snprintf( read_path, sizeof read_path, "%s:read", spool_path );

   char temp_read_path[ 1024 ];
   snprintf( temp_read_path, sizeof temp_read_path, "%s:tmp", read_path );

   char temp_spool_path[ 1024 ];
   snprintf( temp_spool_path, sizeof temp_spool_path, "%s:tmp", spool_path );

   NP_File del, spool, read, temp_spool, temp_read;

   if ( del.opena( deleted_path ))
   {
      del.print_error();
      return;
   }

   if ( spool.openr( spool_path ))
   {
      spool.print_error();
      return;
   }

   int has_read = 1;
   if ( read.openr( read_path ))
   {
      if ( errno != ENOENT )
      {
         read.print_error();
         return;
      }
      else 
         has_read = 0;
   }

   if ( temp_spool.openw( temp_spool_path ))
   {
      temp_spool.print_error();
      return;
   }

   if ( temp_read.openw( temp_read_path ))
   {
      temp_read.print_error();
      return;
   }

   int idx = summary->current_node->ordinal;
   char *line;

   while( idx-- )
   {
      do
         {
            line = spool.get_string();
            if ( line == NULL )
               break;

            if ( temp_spool.put_string( line ))
            {
               temp_spool.print_error();
               return;
            }
         }
      while( strncmp( line, ".\r\n", 3 ));

      line = NULL;
      if ( has_read )
         line = read.get_string();
     
      if ( line == NULL )
         line = "r\n";

      if ( temp_read.put_string( line ))
      {
         temp_read.print_error();
         return;
      }
   }

   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n",
             summary->server, summary->group,
             summary->current_node->subject,
             summary->current_node->from,
             summary->current_node->date );

   if ( del.put_string( buffer ))
      del.print_error();
      
   do
   {
      line = spool.get_string();
      if ( line == NULL )
         break;

      if ( del.put_string( line ))
      {
         del.print_error();
         return;
      }
   }
   while( strncmp( line, ".\r\n", 3 ));

   if ( has_read )
      read.get_string();

   while(( line = spool.get_string()) != NULL )
      if ( temp_spool.put_string( line ))
      {
         temp_spool.print_error();
         return;
      }

   if ( has_read )
   {
      while(( line = read.get_string()) != NULL )
         if ( temp_read.put_string( line ))
         {
            temp_read.print_error();
            return;
         }
   }
   else
      temp_read.put_string( "r\n" );

   temp_spool.close();
   temp_read.close();
   spool.close();

   rename( temp_spool_path, spool_path );
   rename( temp_read_path, read_path );

   if ( !summary->is_stdout_a_tty )
   {
      printf( "%s\n%s\nd\n", summary->server, summary->group );

      if ( !summary->current_node->is_article == 1 )
         printf( "%s\n%s\nh\n", summary->server, summary->group );

      if ( summary->current_node->is_unseen == 1 )
         printf( "%s\n%s\ns\n", summary->server, summary->group );

      printf( "." );
      fflush( stdout );
   }

   summary->selected_item = NULL;
   summary->current_node = NULL;
   
   summary->update_tree();

   if ( summary->text_pid )
      kill( summary->text_pid, SIGUSR1 );

   return;
}
