#include <stdlib.h>
#include <stdio.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npfolders.h"

int NP_Folders::get_items( int i, char **primary, char **secondary )
{
   if ( primary == NULL )
   {
      strcpy( error_message, "NP_Folders: NULL primary pointer passed"
              "as argument." );
      return 1;
   }

   if ( secondary == NULL )
   {
      strcpy( error_message, "NP_Folders: NULL secondary pointer passed"
              "as argument." );
      return 1;
   }

   int total = name_list.get_total();
   if ( total < 0 )
   {
      snprintf( error_message, sizeof error_message, "NP_Folders: "
                "get_items(): %s", name_list.get_error() );
      return 1;
   }

   if ( !total  )
   {
      strcpy( error_message,
              "NP_Folders: get_items(): no virtual newsgroups"
              "have been added to this object." );
      return 1;
   }
   
   if ( i < 0 || i >= total )
   {
      snprintf( error_message, sizeof error_message, "NP_Folders: "
                "get_items(): index %d out of range.", i );
      return 1;
   }

   *primary = ( char *)name_list[ i ];
   if ( *primary == NULL )
   {
      snprintf( error_message, sizeof error_message, "NP_Folders: "
                "%s", name_list.get_error() );
      return 1;
   }

   return 0;
}
