
#include "npconfig.h"

void edit_button_callback( GtkWidget *widget, gpointer data )
{
   NP_Config *config = ( NP_Config *)data;

   if ( config->current_server == -1 )
      return;
   
   // window
   
   config->lists_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
   gtk_container_border_width( GTK_CONTAINER( config->lists_window ), 10 );
   char buffer[ 256 ];
   const char *server = config->subscription[ config->current_server ];
   if ( server == NULL )
   {
      config->subscription.print_error();
      return;
   }
   snprintf( buffer, sizeof buffer, "Edit Subscribed Newsgroups: %s",
             server );
   gtk_window_set_title( GTK_WINDOW( config->lists_window ), buffer );
                         
   // table

   GtkWidget *table = gtk_table_new( 10, 10, FALSE );
   gtk_widget_show( table );
   gtk_table_set_col_spacings( GTK_TABLE( table ), 10 );
   gtk_table_set_row_spacings( GTK_TABLE( table ), 10 );
   gtk_container_add( GTK_CONTAINER( config->lists_window ), table );
   
   // labels

   GtkWidget *label = gtk_label_new( "Double-click a line below to remove a\n"
                                     "newsgroup from the subscribed list" );
   gtk_widget_show( label );
   gtk_table_attach_defaults( GTK_TABLE( table ), label, 0, 5, 0, 1 );

   label = gtk_label_new( "Double-click a line below to add a newsgroup from\n"
                          "the active list to the subscribed list." );
   gtk_widget_show( label );
   gtk_table_attach_defaults( GTK_TABLE( table ), label, 5, 10, 0, 1 );
   
   // pane

   GtkWidget *pane = gtk_hpaned_new();
   gtk_object_set_data( GTK_OBJECT( pane ), "config", config );
   gtk_widget_show( pane );
   gtk_paned_gutter_size( GTK_PANED( pane ), 10 );
   gtk_table_attach_defaults( GTK_TABLE( table ), pane, 0, 10, 1, 8 );

   // group clist

   GtkWidget *group_scroll = gtk_scrolled_window_new( NULL, NULL );
   gtk_widget_show( group_scroll );
   gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( group_scroll ),
                                   GTK_POLICY_AUTOMATIC, 
                                   GTK_POLICY_AUTOMATIC );
   gtk_widget_set_usize( group_scroll, 300, 300 );

   static char *g_titles[] = { "Locally Subscribed Groups",
                               "Last Article Number Seen" };
   
   config->edit_group_clist = gtk_clist_new_with_titles( 2, g_titles );
   gtk_widget_show( config->edit_group_clist );
   gtk_object_set_data( GTK_OBJECT( config->edit_group_clist ), "config",
                        config );
   gtk_clist_set_column_width( GTK_CLIST( config->edit_group_clist ), 0, 200 );
   config->group_clist_id = 
      gtk_signal_connect( GTK_OBJECT( config->edit_group_clist ), "select_row",
                          GTK_SIGNAL_FUNC( clist_remove_callback ), NULL );

   gtk_container_add( GTK_CONTAINER( group_scroll ),
                      config->edit_group_clist );
   gtk_paned_add1( GTK_PANED( pane ), group_scroll );

   // list clist

   GtkWidget *list_scroll = gtk_scrolled_window_new( NULL, NULL );
   gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( list_scroll ),
                                   GTK_POLICY_AUTOMATIC, 
                                   GTK_POLICY_AUTOMATIC );
   gtk_widget_show( list_scroll );
   gtk_widget_set_usize( list_scroll, 300, 300 );

   static char *l_titles[] = { "Active Groups On Server",
                               "Last Article Number On Server" };
   
   config->list_clist = gtk_clist_new_with_titles( 2, l_titles );
   gtk_widget_show( config->list_clist );

   gtk_object_set_data( GTK_OBJECT( config->list_clist ), "config", config );
   gtk_clist_set_column_width( GTK_CLIST( config->list_clist ), 0, 200 );
   config->list_clist_id = 
      gtk_signal_connect( GTK_OBJECT( config->list_clist ), "select_row",
                          GTK_SIGNAL_FUNC( clist_add_callback ),
                          config->edit_group_clist );

   gtk_container_add( GTK_CONTAINER( list_scroll ), config->list_clist );
   gtk_paned_add2( GTK_PANED( pane ), list_scroll );

   // tooltips

   GtkTooltips *tooltips = gtk_tooltips_new();

   // search entry

   config->search_entry = gtk_entry_new_with_max_length( 100 );
   gtk_widget_show( config->search_entry );
   gtk_signal_connect( GTK_OBJECT( config->search_entry ), "changed",
                       GTK_SIGNAL_FUNC( search_entry_callback ), data );
   gtk_signal_connect( GTK_OBJECT( config->search_entry ), "activate",
                       GTK_SIGNAL_FUNC( search_button_callback ), data );
   gtk_table_attach_defaults( GTK_TABLE( table ), config->search_entry,
                              5, 9, 9, 10 );

   // search button

   config->search_button = gtk_button_new();
   gtk_widget_show( config->search_button );
   config->search_label = gtk_label_new( " Search " );
   gtk_widget_show( config->search_label );
   gtk_container_add( GTK_CONTAINER( config->search_button ),
                      config->search_label );
   GTK_WIDGET_SET_FLAGS( config->search_button, GTK_CAN_DEFAULT );
   config->search_id =
      gtk_signal_connect( GTK_OBJECT( config->search_button ), "clicked",
                          GTK_SIGNAL_FUNC( search_button_callback ), data );
   config->stop_id =
      gtk_signal_connect( GTK_OBJECT( config->search_button ), "clicked",
                          GTK_SIGNAL_FUNC( stop_button_callback ), data );
   gtk_signal_handler_block( GTK_OBJECT( config->search_button ),
                             config->stop_id );
   gtk_table_attach_defaults( GTK_TABLE( table ), config->search_button,
                              9, 10, 9, 10 );
   gtk_tooltips_set_tip( tooltips, config->search_button,
                         "Enter a regular expression in the entry and press"
                         " this button to search the server's list of active"
                         " groups.", NULL );

   // buttons

   config->sort_subscribed_button =
      gtk_button_new_with_label( "Sort Subscribed" );
   gtk_widget_show( config->sort_subscribed_button );
   gtk_object_set_data( GTK_OBJECT( config->sort_subscribed_button ), "list",
                        ( gpointer )1 );
   GTK_WIDGET_SET_FLAGS( config->sort_subscribed_button, GTK_CAN_DEFAULT );
   gtk_table_attach_defaults( GTK_TABLE( table ),
                              config->sort_subscribed_button, 0, 1, 8, 9 );
   gtk_signal_connect( GTK_OBJECT( config->sort_subscribed_button ), "clicked",
                       GTK_SIGNAL_FUNC( sort_button_callback ), config );
   gtk_tooltips_set_tip( tooltips, config->sort_subscribed_button,
                         "Sort the list of subscribed groups for this server.",
                         NULL );
   
   GtkWidget *bbox = gtk_hbutton_box_new();
   gtk_widget_show( bbox );
   gtk_object_set_data( GTK_OBJECT( bbox ), "subscribed",
                        config->edit_group_clist );
   gtk_object_set_data( GTK_OBJECT( bbox ), "window", config->lists_window );
   gtk_object_set_data( GTK_OBJECT( bbox ), "clist",
                        config->edit_group_clist );
   gtk_object_set_data( GTK_OBJECT( bbox ), "config", config );
   gtk_table_attach_defaults( GTK_TABLE( table ), bbox, 0, 2, 9, 10 );

   config->ok_button = gtk_button_new_with_label( "OK" );
   gtk_widget_show( config->ok_button );
   GTK_WIDGET_SET_FLAGS( config->ok_button, GTK_CAN_DEFAULT );
   gtk_box_pack_start( GTK_BOX( bbox ), config->ok_button, TRUE, TRUE, 0 );
   gtk_widget_grab_default( config->ok_button );
   gtk_signal_connect( GTK_OBJECT( config->ok_button ), "clicked",
                       GTK_SIGNAL_FUNC( lists_ok_callback ), data );
   gtk_tooltips_set_tip( tooltips, config->ok_button,
                         "Close this window, saving any changes made to the"
                         " server's list of subscribed groups.", NULL );
   
   config->cancel_button = gtk_button_new_with_label( "Cancel" );
   gtk_widget_show( config->cancel_button );
   GTK_WIDGET_SET_FLAGS( config->cancel_button, GTK_CAN_DEFAULT );
   gtk_box_pack_start( GTK_BOX( bbox ), config->cancel_button, TRUE, TRUE, 0 );
   gtk_signal_connect( GTK_OBJECT( config->cancel_button ), "clicked",
                       GTK_SIGNAL_FUNC( lists_cancel_callback ), data );
   gtk_tooltips_set_tip( tooltips, config->cancel_button,
                         "Close this window, discarding any changes made to"
                         " the server's list of subscribed groups.", NULL );
   
   config->update_button = gtk_button_new_with_label( "Update Active" );
   gtk_widget_show( config->update_button );
   GTK_WIDGET_SET_FLAGS( config->update_button, GTK_CAN_DEFAULT );
   gtk_table_attach_defaults( GTK_TABLE( table ), config->update_button,
                              7, 8, 8, 9 );
   gtk_signal_connect( GTK_OBJECT( config->update_button ), "clicked",
                       GTK_SIGNAL_FUNC( lists_update_callback ), data );
   gtk_tooltips_set_tip( tooltips, config->update_button,
                         "Connect to the server and query it to update the"
                         " list of active groups with any new groups added"
                         " since the last time the list was updated.", NULL );
   
   config->refresh_button = gtk_button_new_with_label( "Refresh Active" );
   gtk_widget_show( config->refresh_button );
   GTK_WIDGET_SET_FLAGS( config->refresh_button, GTK_CAN_DEFAULT );
   gtk_table_attach_defaults( GTK_TABLE( table ), config->refresh_button,
                              8, 9, 8, 9 );
   gtk_signal_connect( GTK_OBJECT( config->refresh_button ), "clicked",
                       GTK_SIGNAL_FUNC( refresh_active_callback ), data );
   gtk_tooltips_set_tip( tooltips, config->refresh_button,
                         "Discard the current list of active groups and"
                         " retrieve an entirely fresh list from the server.", 
                         NULL );

   config->sort_active_button = gtk_button_new_with_label( "Sort Active" );
   gtk_widget_show( config->sort_active_button );
   GTK_WIDGET_SET_FLAGS( config->sort_active_button, GTK_CAN_DEFAULT );
   gtk_table_attach_defaults( GTK_TABLE( table ), config->sort_active_button,
                              9, 10, 8, 9 );
   gtk_signal_connect( GTK_OBJECT( config->sort_active_button ), "clicked",
                       GTK_SIGNAL_FUNC( sort_button_callback ), data );
   gtk_tooltips_set_tip( tooltips, config->sort_active_button,
                         "Sort the list of active groups for this server.",
                         NULL );
   
   gtk_object_set_data( GTK_OBJECT( table ), "active", config->list_clist );
   gtk_object_set_data( GTK_OBJECT( table ), "clist",
                        config->edit_group_clist );

   address_buttons_callback( config->ok_button, ( char *)server );

   gtk_widget_show( config->lists_window );
   gtk_grab_add( config->lists_window );

   config->load_clist( config->list_clist );   

   return;
}
