#include "npcompose.h"

void NP_Compose::show_message( char *message )
{
   if ( message == NULL )
      return;

   GtkWidget *message_label = gtk_label_new( message );
   gtk_widget_show( message_label );
   if ( strlen( message ) > 80 )
      gtk_label_set_justify( GTK_LABEL( message_label ), GTK_JUSTIFY_LEFT );

   // window

   message_window = gtk_window_new( GTK_WINDOW_DIALOG );
   gtk_window_position( GTK_WINDOW( message_window ), GTK_WIN_POS_MOUSE );
   gtk_container_border_width( GTK_CONTAINER( message_window ), 10 );
   gtk_window_set_title( GTK_WINDOW( message_window ), "Message" );

   // vbox

   GtkWidget *vbox = gtk_vbox_new( FALSE, 10 );
   gtk_widget_show( vbox );
   gtk_container_add( GTK_CONTAINER( message_window ), vbox );
   gtk_box_pack_start( GTK_BOX( vbox ), message_label, TRUE, TRUE, 0 );

   // separator

   GtkWidget *separator = gtk_hseparator_new();
   gtk_widget_show( separator );
   gtk_box_pack_start( GTK_BOX( vbox ), separator, TRUE, TRUE, 10 );

   // bbox 

   GtkWidget *bbox = gtk_vbutton_box_new();
   gtk_widget_show( bbox );
   gtk_box_pack_start( GTK_BOX( vbox ), bbox, FALSE, FALSE, 0 );

   GtkWidget *message_button = gtk_button_new_with_label( " Close Dialog " );
   gtk_signal_connect( GTK_OBJECT( message_button ), "clicked",
                       GTK_SIGNAL_FUNC( message_callback ), this );
   
   GTK_WIDGET_SET_FLAGS( message_button, GTK_CAN_DEFAULT );
   gtk_box_pack_start( GTK_BOX( bbox ), message_button, TRUE, TRUE, 0 );
   gtk_widget_grab_default( message_button );

   gtk_widget_show( message_button );

   gtk_widget_show( message_window );
   gtk_grab_add( message_window );

   return;
}
