#include <string.h>

#include "npcompose.h"

void editor_button_callback( GtkWidget *widget, gpointer data )
{
   NP_Compose *compose = ( NP_Compose *)data;

   NP_File file;
   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser4-config", compose->home );
   if ( file.openr( buffer ))
   {
      compose->show_message( file.get_error() );
      return;
   }

   char *line = NULL;
   for( int i = 0; i < 2; ++i )
   {
      if (( line = file.get_string()) == NULL )
      {
         compose->show_message( "You have not configured News Peruser.\n(Press"
                                " the configure button on the main window.)" );
         return;
      }
   }

   strcpy( buffer, line );
   strtok( buffer, "\r\n" );

   file.close();

   char filename[ 1024 ];
   snprintf( filename, sizeof filename, "%s/.peruser4-edit", compose->home );
   if ( file.openw( filename ))
   {
      compose->show_message( file.get_error() );
      return;
   }

   compose->write_message( file, 0 );
   file.close();

   strcat( buffer, " " );
   strcat( buffer, filename );

   system( buffer );

   compose->load( 1 );
   
   return;
}
