#include <stdlib.h>
#include <stdio.h>

#include <gtk/gtk.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

void NP_Collections::show_message( char *message, int button )
{
   if ( message == NULL || message_window != NULL )
      return;

   message_label = gtk_label_new( message );
   gtk_widget_show( message_label );
   if ( strlen( message ) > 80 )
      gtk_label_set_justify( GTK_LABEL( message_label ), GTK_JUSTIFY_LEFT );

   // window

   message_window = gtk_window_new( GTK_WINDOW_DIALOG );
   gtk_window_position( GTK_WINDOW( message_window ), GTK_WIN_POS_MOUSE );
   gtk_container_border_width( GTK_CONTAINER( message_window ), 10 );
   gtk_window_set_title( GTK_WINDOW( message_window ), "Message" );

   // vbox

   GtkWidget *vbox = gtk_vbox_new( FALSE, 10 );
   gtk_widget_show( vbox );
   gtk_container_add( GTK_CONTAINER( message_window ), vbox );
   gtk_box_pack_start( GTK_BOX( vbox ), message_label, TRUE, TRUE, 0 );

   if ( button == 1 )
   {
      GtkWidget *label =
         gtk_label_new( "\nAuthor:\nJames Bailie <jazzturk@home.com>\n"
                        "http://members.home.com/jazzturk\n" );
      gtk_widget_show( label );
      gtk_box_pack_start( GTK_BOX( vbox ), label, TRUE, TRUE, 0 );
   }

   if( button == 2 )
   {
      message_progress_bar = gtk_progress_bar_new();
      gtk_widget_show( message_progress_bar );
      gtk_box_pack_start( GTK_BOX( vbox ), message_progress_bar,
                          TRUE, TRUE, 0 );
   }

   // separator

   GtkWidget *separator = gtk_hseparator_new();
   gtk_widget_show( separator );
   gtk_box_pack_start( GTK_BOX( vbox ), separator, TRUE, TRUE, 10 );

   // bbox 

   GtkWidget *bbox = gtk_vbutton_box_new();
   gtk_widget_show( bbox );
   gtk_box_pack_start( GTK_BOX( vbox ), bbox, FALSE, FALSE, 0 );

   GtkWidget *new_button;
   
   gtk_widget_show( message_window );
   
   switch( button )
   {
   case 0:
      message_button = gtk_button_new_with_label( " Close Dialog " );
      gtk_signal_connect( GTK_OBJECT( message_button ), "clicked",
                          GTK_SIGNAL_FUNC( message_callback ), this );
      break;

   case 1:
      new_button = gtk_button_new_with_label(" Send email to Jimmy " );
      gtk_widget_show( new_button );
      GTK_WIDGET_SET_FLAGS( new_button, GTK_CAN_DEFAULT );
      gtk_object_set_data( GTK_OBJECT( new_button ), "collections", this );
      gtk_signal_connect( GTK_OBJECT( new_button ), "clicked",
                          GTK_SIGNAL_FUNC( author_email_website_callback ),
                          0 );
      gtk_box_pack_start( GTK_BOX( bbox ), new_button, TRUE, TRUE, 0 );

      new_button =
         gtk_button_new_with_label( " Visit the News Peruser website " );
      gtk_widget_show( new_button );
      gtk_signal_connect( GTK_OBJECT( new_button ), "clicked",
                          GTK_SIGNAL_FUNC( author_email_website_callback ),
                          ( gpointer )1 );
      GTK_WIDGET_SET_FLAGS( new_button, GTK_CAN_DEFAULT );
      gtk_object_set_data( GTK_OBJECT( new_button ), "collections", this );
      gtk_box_pack_start( GTK_BOX( bbox ), new_button, TRUE, TRUE, 0 );


      message_button = gtk_button_new_with_label( " Close Dialog " );
      gtk_signal_connect( GTK_OBJECT( message_button ), "clicked",
                          GTK_SIGNAL_FUNC( message_callback ), this );
      break;

   case 2:
   case 3:
      message_button = gtk_button_new_with_label( " Stop " );
      gtk_signal_connect( GTK_OBJECT( message_button ), "clicked",
                          GTK_SIGNAL_FUNC( stop_button_callback ), this );
      break;
   }

   gtk_widget_show( message_button );
   GTK_WIDGET_SET_FLAGS( message_button, GTK_CAN_DEFAULT );
   gtk_box_pack_start( GTK_BOX( bbox ), message_button, TRUE, TRUE, 0 );
   gtk_widget_grab_default( message_button );

   gtk_grab_add( message_window );

   return;
}
