#include <stdlib.h>
#include <stdio.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"

int NP_Tree::clear()
{
   if ( total_nodes )
      if ( nodes != NULL )
      {
         NP_Node **pointer = nodes;
         
         for( int i = 0; i < total_nodes; ++i )
            delete *pointer++;

         free( nodes );
         nodes = NULL;
      }

   if ( array.clear() )
   {
      snprintf( error_message, sizeof error_message, "NP_Tree: clear(): "
                "%s", array.get_error() );
      return 1;
   }
   
   total_nodes = total_messages = total_unseen = total_requested =
      total_headers = total_groups = 0;

   return 0;
}
