#include <stdio.h>

#include "npstringarray.h"

int NP_Stringarray::reassign_item( int i, const char *assignee )
{
   if ( i < 0 || i >= total )
   {
      snprintf( error_message, sizeof error_message,
               "NP_Stringarray: reassign_item(): index out of range: %d.", i );
      return 1;
   }
   
   if ( assignee == NULL )
   {
      strcpy( error_message, "NP_Stringarray: reassign_item(): NULL "
              "assignee item passed as argument." );
      return 1;
   }

   item_list[ i ] = ( char *)assignee;

   return 0;
}

