#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include "npfile.h"

int NP_File::status()
{
   if ( feof( stream ))
   {
      snprintf( error_message, sizeof error_message, "NP_File: status():"
                " End of file reached on %s", filename );
      return EOF;
   }
      
   if ( ferror( stream ))
   {
      snprintf( error_message, sizeof error_message,
                "NP_File: status(): Error on file %s: %s",
                strerror( errno ));
      return errno;
   }
   
   return 0;
}

