/***********************************************************************
 *
 * Copyright (C) 2010-2011 Innocent De Marchi <tangram.peces@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 ***********************************************************************/
#ifndef FITXA_H
#define FITXA_H

#include <QGraphicsEllipseItem>

class Tauler;

class Fitxa : public QGraphicsEllipseItem
{
public:
    Fitxa( Tauler*  taulerJoc, QGraphicsItem* parent=0);

    int estat() const{
        return m_estat;
            }

   QPoint coordenades() const;

   int tipusMoviment() const{
        return p_tipusMoviment;}

   int preferenciaMoure() const{
       return p_preferenciaMoure; }

   int nivellAillament() const{
       return p_nivellAillament;}

   //Conserva l'index (del QHash del tauler) de les fitxes botada i final dels
   //possibles moviments d'aquesta fitxa
   QList <QPoint> movimentsPossibles;;


   void calculaMovimentsPosiblesFitxa();

    public slots:

    //Propietats

    /*
      Controla l'estat de la fitxa:
      0: Buit
      1: Estat normal
      2: Fitxa seleccionada
      3: Destí d'un moviment
      4: Joc resolt
      5: El joc s'ha acabat ja que no hi ha més moviments
      */
    void setEstat (int nouValor);

    void setCoordenades (QPoint coordenades);
 /*
           Controla el tipus de moviment
           1: moviment directa (l'habitual del joc)
           2: moviment invers
           3: moviment en direcció perpendicular i obliqua
           4: proposta de problema
           */
    void setTipusMoviment (int nouTipus);

    void ferMoviment();

    bool esPotMoure();

    void setPreferenciaMoure(int preferencia);

    void setEsMou(bool valor);

    void setFixaAillada(bool valor);

    void setNivellAillament( int valor);
    void incrementaNivellAillament();


protected:
    void paint(QPainter *painter,
               const QStyleOptionGraphicsItem *option, QWidget *widget);

    virtual void mousePressEvent(QGraphicsSceneMouseEvent* event);

private:
   //Estat de la fitza per pintar-la
   int m_estat;

   //Coordenades de la fitxa en el joc
   QPoint m_coordenades;


   int p_tipusMoviment;

   //Indica la preferència de la fitxa
   int p_preferenciaMoure;

   //Indica el nivell d'aillament actual de la fitxa
   int p_nivellAillament;


  bool p_aillada;

   //controla si la fitxa s'ha mogut en algun moment
   bool p_esMou;

   //Conserva les coordenades de les fitxes destí de la fitxa actual
   QList<QPoint> movimentsFitxa;

   //Tauler de joc al qual pertany la fitxa
   Tauler* m_taulerJoc;

   void calculaMovimentsFitxa();

};

#endif // FITXA_H
