//========================================================================
//
// BuiltinFontTables.cc
//
// Copyright 2001-2003 Glyph & Cog, LLC
//
//========================================================================

#include <xpdf-aconf.h>
#include <stdlib.h>
#include "xpdf/FontEncodingTables.h"
#include "xpdf/BuiltinFontTables.h"

static BuiltinFontWidth courierWidthsTab[] = {
  { "Ntilde",                            600, NULL },
  { "rcaron",                            600, NULL },
  { "kcommaaccent",                      600, NULL },
  { "Ncommaaccent",                      600, NULL },
  { "Zacute",                            600, NULL },
  { "comma",                             600, NULL },
  { "cedilla",                           600, NULL },
  { "plusminus",                         600, NULL },
  { "circumflex",                        600, NULL },
  { "dotaccent",                         600, NULL },
  { "edotaccent",                        600, NULL },
  { "asciitilde",                        600, NULL },
  { "colon",                             600, NULL },
  { "onehalf",                           600, NULL },
  { "dollar",                            600, NULL },
  { "Lcaron",                            600, NULL },
  { "ntilde",                            600, NULL },
  { "Aogonek",                           600, NULL },
  { "ncommaaccent",                      600, NULL },
  { "minus",                             600, NULL },
  { "Iogonek",                           600, NULL },
  { "zacute",                            600, NULL },
  { "yen",                               600, NULL },
  { "space",                             600, NULL },
  { "Omacron",                           600, NULL },
  { "questiondown",                      600, NULL },
  { "emdash",                            600, NULL },
  { "Agrave",                            600, NULL },
  { "three",                             600, NULL },
  { "numbersign",                        600, NULL },
  { "lcaron",                            600, NULL },
  { "A",                                 600, NULL },
  { "B",                                 600, NULL },
  { "C",                                 600, NULL },
  { "aogonek",                           600, NULL },
  { "D",                                 600, NULL },
  { "E",                                 600, NULL },
  { "onequarter",                        600, NULL },
  { "F",                                 600, NULL },
  { "G",                                 600, NULL },
  { "H",                                 600, NULL },
  { "I",                                 600, NULL },
  { "J",                                 600, NULL },
  { "K",                                 600, NULL },
  { "iogonek",                           600, NULL },
  { "L",                                 600, NULL },
  { "backslash",                         600, NULL },
  { "periodcentered",                    600, NULL },
  { "M",                                 600, NULL },
  { "N",                                 600, NULL },
  { "omacron",                           600, NULL },
  { "Tcommaaccent",                      600, NULL },
  { "O",                                 600, NULL },
  { "P",                                 600, NULL },
  { "Q",                                 600, NULL },
  { "Uhungarumlaut",                     600, NULL },
  { "R",                                 600, NULL },
  { "Aacute",                            600, NULL },
  { "caron",                             600, NULL },
  { "S",                                 600, NULL },
  { "T",                                 600, NULL },
  { "U",                                 600, NULL },
  { "agrave",                            600, NULL },
  { "V",                                 600, NULL },
  { "W",                                 600, NULL },
  { "equal",                             600, NULL },
  { "question",                          600, NULL },
  { "X",                                 600, NULL },
  { "Y",                                 600, NULL },
  { "Z",                                 600, NULL },
  { "four",                              600, NULL },
  { "a",                                 600, NULL },
  { "Gcommaaccent",                      600, NULL },
  { "b",                                 600, NULL },
  { "c",                                 600, NULL },
  { "d",                                 600, NULL },
  { "e",                                 600, NULL },
  { "f",                                 600, NULL },
  { "g",                                 600, NULL },
  { "bullet",                            600, NULL },
  { "h",                                 600, NULL },
  { "i",                                 600, NULL },
  { "Oslash",                            600, NULL },
  { "dagger",                            600, NULL },
  { "j",                                 600, NULL },
  { "k",                                 600, NULL },
  { "l",                                 600, NULL },
  { "m",                                 600, NULL },
  { "n",                                 600, NULL },
  { "tcommaaccent",                      600, NULL },
  { "o",                                 600, NULL },
  { "ordfeminine",                       600, NULL },
  { "ring",                              600, NULL },
  { "p",                                 600, NULL },
  { "q",                                 600, NULL },
  { "uhungarumlaut",                     600, NULL },
  { "r",                                 600, NULL },
  { "twosuperior",                       600, NULL },
  { "aacute",                            600, NULL },
  { "s",                                 600, NULL },
  { "OE",                                600, NULL },
  { "t",                                 600, NULL },
  { "divide",                            600, NULL },
  { "u",                                 600, NULL },
  { "Ccaron",                            600, NULL },
  { "v",                                 600, NULL },
  { "w",                                 600, NULL },
  { "x",                                 600, NULL },
  { "y",                                 600, NULL },
  { "z",                                 600, NULL },
  { "Gbreve",                            600, NULL },
  { "commaaccent",                       600, NULL },
  { "hungarumlaut",                      600, NULL },
  { "Idotaccent",                        600, NULL },
  { "Nacute",                            600, NULL },
  { "quotedbl",                          600, NULL },
  { "gcommaaccent",                      600, NULL },
  { "mu",                                600, NULL },
  { "greaterequal",                      600, NULL },
  { "Scaron",                            600, NULL },
  { "Lslash",                            600, NULL },
  { "semicolon",                         600, NULL },
  { "oslash",                            600, NULL },
  { "lessequal",                         600, NULL },
  { "lozenge",                           600, NULL },
  { "parenright",                        600, NULL },
  { "ccaron",                            600, NULL },
  { "Ecircumflex",                       600, NULL },
  { "gbreve",                            600, NULL },
  { "trademark",                         600, NULL },
  { "daggerdbl",                         600, NULL },
  { "nacute",                            600, NULL },
  { "macron",                            600, NULL },
  { "Otilde",                            600, NULL },
  { "Emacron",                           600, NULL },
  { "ellipsis",                          600, NULL },
  { "scaron",                            600, NULL },
  { "AE",                                600, NULL },
  { "Ucircumflex",                       600, NULL },
  { "lslash",                            600, NULL },
  { "quotedblleft",                      600, NULL },
  { "hyphen",                            600, NULL },
  { "guilsinglright",                    600, NULL },
  { "quotesingle",                       600, NULL },
  { "eight",                             600, NULL },
  { "exclamdown",                        600, NULL },
  { "endash",                            600, NULL },
  { "oe",                                600, NULL },
  { "Abreve",                            600, NULL },
  { "Umacron",                           600, NULL },
  { "ecircumflex",                       600, NULL },
  { "Adieresis",                         600, NULL },
  { "copyright",                         600, NULL },
  { "Egrave",                            600, NULL },
  { "slash",                             600, NULL },
  { "Edieresis",                         600, NULL },
  { "otilde",                            600, NULL },
  { "Idieresis",                         600, NULL },
  { "parenleft",                         600, NULL },
  { "one",                               600, NULL },
  { "emacron",                           600, NULL },
  { "Odieresis",                         600, NULL },
  { "ucircumflex",                       600, NULL },
  { "bracketleft",                       600, NULL },
  { "Ugrave",                            600, NULL },
  { "quoteright",                        600, NULL },
  { "Udieresis",                         600, NULL },
  { "perthousand",                       600, NULL },
  { "Ydieresis",                         600, NULL },
  { "umacron",                           600, NULL },
  { "abreve",                            600, NULL },
  { "Eacute",                            600, NULL },
  { "adieresis",                         600, NULL },
  { "egrave",                            600, NULL },
  { "edieresis",                         600, NULL },
  { "idieresis",                         600, NULL },
  { "Eth",                               600, NULL },
  { "ae",                                600, NULL },
  { "asterisk",                          600, NULL },
  { "odieresis",                         600, NULL },
  { "Uacute",                            600, NULL },
  { "ugrave",                            600, NULL },
  { "five",                              600, NULL },
  { "nine",                              600, NULL },
  { "udieresis",                         600, NULL },
  { "Zcaron",                            600, NULL },
  { "Scommaaccent",                      600, NULL },
  { "threequarters",                     600, NULL },
  { "guillemotright",                    600, NULL },
  { "Ccedilla",                          600, NULL },
  { "ydieresis",                         600, NULL },
  { "tilde",                             600, NULL },
  { "at",                                600, NULL },
  { "eacute",                            600, NULL },
  { "underscore",                        600, NULL },
  { "Euro",                              600, NULL },
  { "Dcroat",                            600, NULL },
  { "zero",                              600, NULL },
  { "multiply",                          600, NULL },
  { "eth",                               600, NULL },
  { "Scedilla",                          600, NULL },
  { "Racute",                            600, NULL },
  { "Ograve",                            600, NULL },
  { "partialdiff",                       600, NULL },
  { "uacute",                            600, NULL },
  { "braceleft",                         600, NULL },
  { "Thorn",                             600, NULL },
  { "zcaron",                            600, NULL },
  { "scommaaccent",                      600, NULL },
  { "ccedilla",                          600, NULL },
  { "Dcaron",                            600, NULL },
  { "dcroat",                            600, NULL },
  { "scedilla",                          600, NULL },
  { "Oacute",                            600, NULL },
  { "Ocircumflex",                       600, NULL },
  { "ogonek",                            600, NULL },
  { "ograve",                            600, NULL },
  { "racute",                            600, NULL },
  { "Tcaron",                            600, NULL },
  { "Eogonek",                           600, NULL },
  { "thorn",                             600, NULL },
  { "degree",                            600, NULL },
  { "registered",                        600, NULL },
  { "radical",                           600, NULL },
  { "Aring",                             600, NULL },
  { "percent",                           600, NULL },
  { "six",                               600, NULL },
  { "paragraph",                         600, NULL },
  { "dcaron",                            600, NULL },
  { "Uogonek",                           600, NULL },
  { "two",                               600, NULL },
  { "summation",                         600, NULL },
  { "Igrave",                            600, NULL },
  { "Lacute",                            600, NULL },
  { "ocircumflex",                       600, NULL },
  { "oacute",                            600, NULL },
  { "Uring",                             600, NULL },
  { "Lcommaaccent",                      600, NULL },
  { "tcaron",                            600, NULL },
  { "eogonek",                           600, NULL },
  { "Delta",                             600, NULL },
  { "Ohungarumlaut",                     600, NULL },
  { "asciicircum",                       600, NULL },
  { "aring",                             600, NULL },
  { "grave",                             600, NULL },
  { "uogonek",                           600, NULL },
  { "bracketright",                      600, NULL },
  { "ampersand",                         600, NULL },
  { "Iacute",                            600, NULL },
  { "lacute",                            600, NULL },
  { "igrave",                            600, NULL },
  { "Ncaron",                            600, NULL },
  { "plus",                              600, NULL },
  { "uring",                             600, NULL },
  { "quotesinglbase",                    600, NULL },
  { "lcommaaccent",                      600, NULL },
  { "Yacute",                            600, NULL },
  { "ohungarumlaut",                     600, NULL },
  { "threesuperior",                     600, NULL },
  { "acute",                             600, NULL },
  { "section",                           600, NULL },
  { "dieresis",                          600, NULL },
  { "quotedblbase",                      600, NULL },
  { "iacute",                            600, NULL },
  { "ncaron",                            600, NULL },
  { "florin",                            600, NULL },
  { "yacute",                            600, NULL },
  { "Rcommaaccent",                      600, NULL },
  { "fi",                                600, NULL },
  { "fl",                                600, NULL },
  { "Acircumflex",                       600, NULL },
  { "Cacute",                            600, NULL },
  { "Icircumflex",                       600, NULL },
  { "guillemotleft",                     600, NULL },
  { "germandbls",                        600, NULL },
  { "seven",                             600, NULL },
  { "Amacron",                           600, NULL },
  { "Sacute",                            600, NULL },
  { "ordmasculine",                      600, NULL },
  { "dotlessi",                          600, NULL },
  { "sterling",                          600, NULL },
  { "notequal",                          600, NULL },
  { "Imacron",                           600, NULL },
  { "rcommaaccent",                      600, NULL },
  { "Zdotaccent",                        600, NULL },
  { "acircumflex",                       600, NULL },
  { "cacute",                            600, NULL },
  { "Ecaron",                            600, NULL },
  { "braceright",                        600, NULL },
  { "icircumflex",                       600, NULL },
  { "quotedblright",                     600, NULL },
  { "amacron",                           600, NULL },
  { "sacute",                            600, NULL },
  { "imacron",                           600, NULL },
  { "cent",                              600, NULL },
  { "currency",                          600, NULL },
  { "logicalnot",                        600, NULL },
  { "zdotaccent",                        600, NULL },
  { "Atilde",                            600, NULL },
  { "breve",                             600, NULL },
  { "bar",                               600, NULL },
  { "fraction",                          600, NULL },
  { "less",                              600, NULL },
  { "ecaron",                            600, NULL },
  { "guilsinglleft",                     600, NULL },
  { "exclam",                            600, NULL },
  { "period",                            600, NULL },
  { "Rcaron",                            600, NULL },
  { "Kcommaaccent",                      600, NULL },
  { "greater",                           600, NULL },
  { "atilde",                            600, NULL },
  { "brokenbar",                         600, NULL },
  { "quoteleft",                         600, NULL },
  { "Edotaccent",                        600, NULL },
  { "onesuperior",                       600, NULL }
};

static BuiltinFontWidth courierBoldWidthsTab[] = {
  { "Ntilde",                            600, NULL },
  { "rcaron",                            600, NULL },
  { "kcommaaccent",                      600, NULL },
  { "Ncommaaccent",                      600, NULL },
  { "Zacute",                            600, NULL },
  { "comma",                             600, NULL },
  { "cedilla",                           600, NULL },
  { "plusminus",                         600, NULL },
  { "circumflex",                        600, NULL },
  { "dotaccent",                         600, NULL },
  { "edotaccent",                        600, NULL },
  { "asciitilde",                        600, NULL },
  { "colon",                             600, NULL },
  { "onehalf",                           600, NULL },
  { "dollar",                            600, NULL },
  { "Lcaron",                            600, NULL },
  { "ntilde",                            600, NULL },
  { "Aogonek",                           600, NULL },
  { "ncommaaccent",                      600, NULL },
  { "minus",                             600, NULL },
  { "Iogonek",                           600, NULL },
  { "zacute",                            600, NULL },
  { "yen",                               600, NULL },
  { "space",                             600, NULL },
  { "Omacron",                           600, NULL },
  { "questiondown",                      600, NULL },
  { "emdash",                            600, NULL },
  { "Agrave",                            600, NULL },
  { "three",                             600, NULL },
  { "numbersign",                        600, NULL },
  { "lcaron",                            600, NULL },
  { "A",                                 600, NULL },
  { "B",                                 600, NULL },
  { "C",                                 600, NULL },
  { "aogonek",                           600, NULL },
  { "D",                                 600, NULL },
  { "E",                                 600, NULL },
  { "onequarter",                        600, NULL },
  { "F",                                 600, NULL },
  { "G",                                 600, NULL },
  { "H",                                 600, NULL },
  { "I",                                 600, NULL },
  { "J",                                 600, NULL },
  { "K",                                 600, NULL },
  { "iogonek",                           600, NULL },
  { "backslash",                         600, NULL },
  { "L",                                 600, NULL },
  { "periodcentered",                    600, NULL },
  { "M",                                 600, NULL },
  { "N",                                 600, NULL },
  { "omacron",                           600, NULL },
  { "Tcommaaccent",                      600, NULL },
  { "O",                                 600, NULL },
  { "P",                                 600, NULL },
  { "Q",                                 600, NULL },
  { "Uhungarumlaut",                     600, NULL },
  { "R",                                 600, NULL },
  { "Aacute",                            600, NULL },
  { "caron",                             600, NULL },
  { "S",                                 600, NULL },
  { "T",                                 600, NULL },
  { "U",                                 600, NULL },
  { "agrave",                            600, NULL },
  { "V",                                 600, NULL },
  { "W",                                 600, NULL },
  { "X",                                 600, NULL },
  { "question",                          600, NULL },
  { "equal",                             600, NULL },
  { "Y",                                 600, NULL },
  { "Z",                                 600, NULL },
  { "four",                              600, NULL },
  { "a",                                 600, NULL },
  { "Gcommaaccent",                      600, NULL },
  { "b",                                 600, NULL },
  { "c",                                 600, NULL },
  { "d",                                 600, NULL },
  { "e",                                 600, NULL },
  { "f",                                 600, NULL },
  { "g",                                 600, NULL },
  { "bullet",                            600, NULL },
  { "h",                                 600, NULL },
  { "i",                                 600, NULL },
  { "Oslash",                            600, NULL },
  { "dagger",                            600, NULL },
  { "j",                                 600, NULL },
  { "k",                                 600, NULL },
  { "l",                                 600, NULL },
  { "m",                                 600, NULL },
  { "n",                                 600, NULL },
  { "tcommaaccent",                      600, NULL },
  { "o",                                 600, NULL },
  { "ordfeminine",                       600, NULL },
  { "ring",                              600, NULL },
  { "p",                                 600, NULL },
  { "q",                                 600, NULL },
  { "uhungarumlaut",                     600, NULL },
  { "r",                                 600, NULL },
  { "twosuperior",                       600, NULL },
  { "aacute",                            600, NULL },
  { "s",                                 600, NULL },
  { "OE",                                600, NULL },
  { "t",                                 600, NULL },
  { "divide",                            600, NULL },
  { "u",                                 600, NULL },
  { "Ccaron",                            600, NULL },
  { "v",                                 600, NULL },
  { "w",                                 600, NULL },
  { "x",                                 600, NULL },
  { "y",                                 600, NULL },
  { "z",                                 600, NULL },
  { "Gbreve",                            600, NULL },
  { "commaaccent",                       600, NULL },
  { "hungarumlaut",                      600, NULL },
  { "Idotaccent",                        600, NULL },
  { "Nacute",                            600, NULL },
  { "quotedbl",                          600, NULL },
  { "gcommaaccent",                      600, NULL },
  { "mu",                                600, NULL },
  { "greaterequal",                      600, NULL },
  { "Scaron",                            600, NULL },
  { "Lslash",                            600, NULL },
  { "semicolon",                         600, NULL },
  { "oslash",                            600, NULL },
  { "lessequal",                         600, NULL },
  { "lozenge",                           600, NULL },
  { "parenright",                        600, NULL },
  { "ccaron",                            600, NULL },
  { "Ecircumflex",                       600, NULL },
  { "gbreve",                            600, NULL },
  { "trademark",                         600, NULL },
  { "daggerdbl",                         600, NULL },
  { "nacute",                            600, NULL },
  { "macron",                            600, NULL },
  { "Otilde",                            600, NULL },
  { "Emacron",                           600, NULL },
  { "ellipsis",                          600, NULL },
  { "scaron",                            600, NULL },
  { "AE",                                600, NULL },
  { "Ucircumflex",                       600, NULL },
  { "lslash",                            600, NULL },
  { "quotedblleft",                      600, NULL },
  { "guilsinglright",                    600, NULL },
  { "hyphen",                            600, NULL },
  { "quotesingle",                       600, NULL },
  { "eight",                             600, NULL },
  { "exclamdown",                        600, NULL },
  { "endash",                            600, NULL },
  { "oe",                                600, NULL },
  { "Abreve",                            600, NULL },
  { "Umacron",                           600, NULL },
  { "ecircumflex",                       600, NULL },
  { "Adieresis",                         600, NULL },
  { "copyright",                         600, NULL },
  { "Egrave",                            600, NULL },
  { "slash",                             600, NULL },
  { "Edieresis",                         600, NULL },
  { "otilde",                            600, NULL },
  { "Idieresis",                         600, NULL },
  { "parenleft",                         600, NULL },
  { "one",                               600, NULL },
  { "emacron",                           600, NULL },
  { "Odieresis",                         600, NULL },
  { "ucircumflex",                       600, NULL },
  { "bracketleft",                       600, NULL },
  { "Ugrave",                            600, NULL },
  { "quoteright",                        600, NULL },
  { "Udieresis",                         600, NULL },
  { "perthousand",                       600, NULL },
  { "Ydieresis",                         600, NULL },
  { "umacron",                           600, NULL },
  { "abreve",                            600, NULL },
  { "Eacute",                            600, NULL },
  { "adieresis",                         600, NULL },
  { "egrave",                            600, NULL },
  { "edieresis",                         600, NULL },
  { "idieresis",                         600, NULL },
  { "Eth",                               600, NULL },
  { "ae",                                600, NULL },
  { "asterisk",                          600, NULL },
  { "odieresis",                         600, NULL },
  { "Uacute",                            600, NULL },
  { "ugrave",                            600, NULL },
  { "nine",                              600, NULL },
  { "five",                              600, NULL },
  { "udieresis",                         600, NULL },
  { "Zcaron",                            600, NULL },
  { "Scommaaccent",                      600, NULL },
  { "threequarters",                     600, NULL },
  { "guillemotright",                    600, NULL },
  { "Ccedilla",                          600, NULL },
  { "ydieresis",                         600, NULL },
  { "tilde",                             600, NULL },
  { "at",                                600, NULL },
  { "eacute",                            600, NULL },
  { "underscore",                        600, NULL },
  { "Euro",                              600, NULL },
  { "Dcroat",                            600, NULL },
  { "multiply",                          600, NULL },
  { "zero",                              600, NULL },
  { "eth",                               600, NULL },
  { "Scedilla",                          600, NULL },
  { "Ograve",                            600, NULL },
  { "Racute",                            600, NULL },
  { "partialdiff",                       600, NULL },
  { "uacute",                            600, NULL },
  { "braceleft",                         600, NULL },
  { "Thorn",                             600, NULL },
  { "zcaron",                            600, NULL },
  { "scommaaccent",                      600, NULL },
  { "ccedilla",                          600, NULL },
  { "Dcaron",                            600, NULL },
  { "dcroat",                            600, NULL },
  { "Ocircumflex",                       600, NULL },
  { "Oacute",                            600, NULL },
  { "scedilla",                          600, NULL },
  { "ogonek",                            600, NULL },
  { "ograve",                            600, NULL },
  { "racute",                            600, NULL },
  { "Tcaron",                            600, NULL },
  { "Eogonek",                           600, NULL },
  { "thorn",                             600, NULL },
  { "degree",                            600, NULL },
  { "registered",                        600, NULL },
  { "radical",                           600, NULL },
  { "Aring",                             600, NULL },
  { "percent",                           600, NULL },
  { "six",                               600, NULL },
  { "paragraph",                         600, NULL },
  { "dcaron",                            600, NULL },
  { "Uogonek",                           600, NULL },
  { "two",                               600, NULL },
  { "summation",                         600, NULL },
  { "Igrave",                            600, NULL },
  { "Lacute",                            600, NULL },
  { "ocircumflex",                       600, NULL },
  { "oacute",                            600, NULL },
  { "Uring",                             600, NULL },
  { "Lcommaaccent",                      600, NULL },
  { "tcaron",                            600, NULL },
  { "eogonek",                           600, NULL },
  { "Delta",                             600, NULL },
  { "Ohungarumlaut",                     600, NULL },
  { "asciicircum",                       600, NULL },
  { "aring",                             600, NULL },
  { "grave",                             600, NULL },
  { "uogonek",                           600, NULL },
  { "bracketright",                      600, NULL },
  { "Iacute",                            600, NULL },
  { "ampersand",                         600, NULL },
  { "igrave",                            600, NULL },
  { "lacute",                            600, NULL },
  { "Ncaron",                            600, NULL },
  { "plus",                              600, NULL },
  { "uring",                             600, NULL },
  { "quotesinglbase",                    600, NULL },
  { "lcommaaccent",                      600, NULL },
  { "Yacute",                            600, NULL },
  { "ohungarumlaut",                     600, NULL },
  { "threesuperior",                     600, NULL },
  { "acute",                             600, NULL },
  { "section",                           600, NULL },
  { "dieresis",                          600, NULL },
  { "iacute",                            600, NULL },
  { "quotedblbase",                      600, NULL },
  { "ncaron",                            600, NULL },
  { "florin",                            600, NULL },
  { "yacute",                            600, NULL },
  { "Rcommaaccent",                      600, NULL },
  { "fi",                                600, NULL },
  { "fl",                                600, NULL },
  { "Acircumflex",                       600, NULL },
  { "Cacute",                            600, NULL },
  { "Icircumflex",                       600, NULL },
  { "guillemotleft",                     600, NULL },
  { "germandbls",                        600, NULL },
  { "Amacron",                           600, NULL },
  { "seven",                             600, NULL },
  { "Sacute",                            600, NULL },
  { "ordmasculine",                      600, NULL },
  { "dotlessi",                          600, NULL },
  { "sterling",                          600, NULL },
  { "notequal",                          600, NULL },
  { "Imacron",                           600, NULL },
  { "rcommaaccent",                      600, NULL },
  { "Zdotaccent",                        600, NULL },
  { "acircumflex",                       600, NULL },
  { "cacute",                            600, NULL },
  { "Ecaron",                            600, NULL },
  { "icircumflex",                       600, NULL },
  { "braceright",                        600, NULL },
  { "quotedblright",                     600, NULL },
  { "amacron",                           600, NULL },
  { "sacute",                            600, NULL },
  { "imacron",                           600, NULL },
  { "cent",                              600, NULL },
  { "currency",                          600, NULL },
  { "logicalnot",                        600, NULL },
  { "zdotaccent",                        600, NULL },
  { "Atilde",                            600, NULL },
  { "breve",                             600, NULL },
  { "bar",                               600, NULL },
  { "fraction",                          600, NULL },
  { "less",                              600, NULL },
  { "ecaron",                            600, NULL },
  { "guilsinglleft",                     600, NULL },
  { "exclam",                            600, NULL },
  { "period",                            600, NULL },
  { "Rcaron",                            600, NULL },
  { "Kcommaaccent",                      600, NULL },
  { "greater",                           600, NULL },
  { "atilde",                            600, NULL },
  { "brokenbar",                         600, NULL },
  { "quoteleft",                         600, NULL },
  { "Edotaccent",                        600, NULL },
  { "onesuperior",                       600, NULL }
};

static BuiltinFontWidth courierBoldObliqueWidthsTab[] = {
  { "Ntilde",                            600, NULL },
  { "rcaron",                            600, NULL },
  { "kcommaaccent",                      600, NULL },
  { "Ncommaaccent",                      600, NULL },
  { "Zacute",                            600, NULL },
  { "comma",                             600, NULL },
  { "cedilla",                           600, NULL },
  { "plusminus",                         600, NULL },
  { "circumflex",                        600, NULL },
  { "dotaccent",                         600, NULL },
  { "edotaccent",                        600, NULL },
  { "asciitilde",                        600, NULL },
  { "colon",                             600, NULL },
  { "onehalf",                           600, NULL },
  { "dollar",                            600, NULL },
  { "Lcaron",                            600, NULL },
  { "ntilde",                            600, NULL },
  { "Aogonek",                           600, NULL },
  { "ncommaaccent",                      600, NULL },
  { "minus",                             600, NULL },
  { "Iogonek",                           600, NULL },
  { "zacute",                            600, NULL },
  { "yen",                               600, NULL },
  { "space",                             600, NULL },
  { "Omacron",                           600, NULL },
  { "questiondown",                      600, NULL },
  { "emdash",                            600, NULL },
  { "Agrave",                            600, NULL },
  { "three",                             600, NULL },
  { "numbersign",                        600, NULL },
  { "lcaron",                            600, NULL },
  { "A",                                 600, NULL },
  { "B",                                 600, NULL },
  { "C",                                 600, NULL },
  { "aogonek",                           600, NULL },
  { "D",                                 600, NULL },
  { "E",                                 600, NULL },
  { "onequarter",                        600, NULL },
  { "F",                                 600, NULL },
  { "G",                                 600, NULL },
  { "H",                                 600, NULL },
  { "I",                                 600, NULL },
  { "J",                                 600, NULL },
  { "K",                                 600, NULL },
  { "iogonek",                           600, NULL },
  { "backslash",                         600, NULL },
  { "L",                                 600, NULL },
  { "periodcentered",                    600, NULL },
  { "M",                                 600, NULL },
  { "N",                                 600, NULL },
  { "omacron",                           600, NULL },
  { "Tcommaaccent",                      600, NULL },
  { "O",                                 600, NULL },
  { "P",                                 600, NULL },
  { "Q",                                 600, NULL },
  { "Uhungarumlaut",                     600, NULL },
  { "R",                                 600, NULL },
  { "Aacute",                            600, NULL },
  { "caron",                             600, NULL },
  { "S",                                 600, NULL },
  { "T",                                 600, NULL },
  { "U",                                 600, NULL },
  { "agrave",                            600, NULL },
  { "V",                                 600, NULL },
  { "W",                                 600, NULL },
  { "X",                                 600, NULL },
  { "question",                          600, NULL },
  { "equal",                             600, NULL },
  { "Y",                                 600, NULL },
  { "Z",                                 600, NULL },
  { "four",                              600, NULL },
  { "a",                                 600, NULL },
  { "Gcommaaccent",                      600, NULL },
  { "b",                                 600, NULL },
  { "c",                                 600, NULL },
  { "d",                                 600, NULL },
  { "e",                                 600, NULL },
  { "f",                                 600, NULL },
  { "g",                                 600, NULL },
  { "bullet",                            600, NULL },
  { "h",                                 600, NULL },
  { "i",                                 600, NULL },
  { "Oslash",                            600, NULL },
  { "dagger",                            600, NULL },
  { "j",                                 600, NULL },
  { "k",                                 600, NULL },
  { "l",                                 600, NULL },
  { "m",                                 600, NULL },
  { "n",                                 600, NULL },
  { "tcommaaccent",                      600, NULL },
  { "o",                                 600, NULL },
  { "ordfeminine",                       600, NULL },
  { "ring",                              600, NULL },
  { "p",                                 600, NULL },
  { "q",                                 600, NULL },
  { "uhungarumlaut",                     600, NULL },
  { "r",                                 600, NULL },
  { "twosuperior",                       600, NULL },
  { "aacute",                            600, NULL },
  { "s",                                 600, NULL },
  { "OE",                                600, NULL },
  { "t",                                 600, NULL },
  { "divide",                            600, NULL },
  { "u",                                 600, NULL },
  { "Ccaron",                            600, NULL },
  { "v",                                 600, NULL },
  { "w",                                 600, NULL },
  { "x",                                 600, NULL },
  { "y",                                 600, NULL },
  { "z",                                 600, NULL },
  { "Gbreve",                            600, NULL },
  { "commaaccent",                       600, NULL },
  { "hungarumlaut",                      600, NULL },
  { "Idotaccent",                        600, NULL },
  { "Nacute",                            600, NULL },
  { "quotedbl",                          600, NULL },
  { "gcommaaccent",                      600, NULL },
  { "mu",                                600, NULL },
  { "greaterequal",                      600, NULL },
  { "Scaron",                            600, NULL },
  { "Lslash",                            600, NULL },
  { "semicolon",                         600, NULL },
  { "oslash",                            600, NULL },
  { "lessequal",                         600, NULL },
  { "lozenge",                           600, NULL },
  { "parenright",                        600, NULL },
  { "ccaron",                            600, NULL },
  { "Ecircumflex",                       600, NULL },
  { "gbreve",                            600, NULL },
  { "trademark",                         600, NULL },
  { "daggerdbl",                         600, NULL },
  { "nacute",                            600, NULL },
  { "macron",                            600, NULL },
  { "Otilde",                            600, NULL },
  { "Emacron",                           600, NULL },
  { "ellipsis",                          600, NULL },
  { "scaron",                            600, NULL },
  { "AE",                                600, NULL },
  { "Ucircumflex",                       600, NULL },
  { "lslash",                            600, NULL },
  { "quotedblleft",                      600, NULL },
  { "guilsinglright",                    600, NULL },
  { "hyphen",                            600, NULL },
  { "quotesingle",                       600, NULL },
  { "eight",                             600, NULL },
  { "exclamdown",                        600, NULL },
  { "endash",                            600, NULL },
  { "oe",                                600, NULL },
  { "Abreve",                            600, NULL },
  { "Umacron",                           600, NULL },
  { "ecircumflex",                       600, NULL },
  { "Adieresis",                         600, NULL },
  { "copyright",                         600, NULL },
  { "Egrave",                            600, NULL },
  { "slash",                             600, NULL },
  { "Edieresis",                         600, NULL },
  { "otilde",                            600, NULL },
  { "Idieresis",                         600, NULL },
  { "parenleft",                         600, NULL },
  { "one",                               600, NULL },
  { "emacron",                           600, NULL },
  { "Odieresis",                         600, NULL },
  { "ucircumflex",                       600, NULL },
  { "bracketleft",                       600, NULL },
  { "Ugrave",                            600, NULL },
  { "quoteright",                        600, NULL },
  { "Udieresis",                         600, NULL },
  { "perthousand",                       600, NULL },
  { "Ydieresis",                         600, NULL },
  { "umacron",                           600, NULL },
  { "abreve",                            600, NULL },
  { "Eacute",                            600, NULL },
  { "adieresis",                         600, NULL },
  { "egrave",                            600, NULL },
  { "edieresis",                         600, NULL },
  { "idieresis",                         600, NULL },
  { "Eth",                               600, NULL },
  { "ae",                                600, NULL },
  { "asterisk",                          600, NULL },
  { "odieresis",                         600, NULL },
  { "Uacute",                            600, NULL },
  { "ugrave",                            600, NULL },
  { "nine",                              600, NULL },
  { "five",                              600, NULL },
  { "udieresis",                         600, NULL },
  { "Zcaron",                            600, NULL },
  { "Scommaaccent",                      600, NULL },
  { "threequarters",                     600, NULL },
  { "guillemotright",                    600, NULL },
  { "Ccedilla",                          600, NULL },
  { "ydieresis",                         600, NULL },
  { "tilde",                             600, NULL },
  { "at",                                600, NULL },
  { "eacute",                            600, NULL },
  { "underscore",                        600, NULL },
  { "Euro",                              600, NULL },
  { "Dcroat",                            600, NULL },
  { "multiply",                          600, NULL },
  { "zero",                              600, NULL },
  { "eth",                               600, NULL },
  { "Scedilla",                          600, NULL },
  { "Ograve",                            600, NULL },
  { "Racute",                            600, NULL },
  { "partialdiff",                       600, NULL },
  { "uacute",                            600, NULL },
  { "braceleft",                         600, NULL },
  { "Thorn",                             600, NULL },
  { "zcaron",                            600, NULL },
  { "scommaaccent",                      600, NULL },
  { "ccedilla",                          600, NULL },
  { "Dcaron",                            600, NULL },
  { "dcroat",                            600, NULL },
  { "Ocircumflex",                       600, NULL },
  { "Oacute",                            600, NULL },
  { "scedilla",                          600, NULL },
  { "ogonek",                            600, NULL },
  { "ograve",                            600, NULL },
  { "racute",                            600, NULL },
  { "Tcaron",                            600, NULL },
  { "Eogonek",                           600, NULL },
  { "thorn",                             600, NULL },
  { "degree",                            600, NULL },
  { "registered",                        600, NULL },
  { "radical",                           600, NULL },
  { "Aring",                             600, NULL },
  { "percent",                           600, NULL },
  { "six",                               600, NULL },
  { "paragraph",                         600, NULL },
  { "dcaron",                            600, NULL },
  { "Uogonek",                           600, NULL },
  { "two",                               600, NULL },
  { "summation",                         600, NULL },
  { "Igrave",                            600, NULL },
  { "Lacute",                            600, NULL },
  { "ocircumflex",                       600, NULL },
  { "oacute",                            600, NULL },
  { "Uring",                             600, NULL },
  { "Lcommaaccent",                      600, NULL },
  { "tcaron",                            600, NULL },
  { "eogonek",                           600, NULL },
  { "Delta",                             600, NULL },
  { "Ohungarumlaut",                     600, NULL },
  { "asciicircum",                       600, NULL },
  { "aring",                             600, NULL },
  { "grave",                             600, NULL },
  { "uogonek",                           600, NULL },
  { "bracketright",                      600, NULL },
  { "Iacute",                            600, NULL },
  { "ampersand",                         600, NULL },
  { "igrave",                            600, NULL },
  { "lacute",                            600, NULL },
  { "Ncaron",                            600, NULL },
  { "plus",                              600, NULL },
  { "uring",                             600, NULL },
  { "quotesinglbase",                    600, NULL },
  { "lcommaaccent",                      600, NULL },
  { "Yacute",                            600, NULL },
  { "ohungarumlaut",                     600, NULL },
  { "threesuperior",                     600, NULL },
  { "acute",                             600, NULL },
  { "section",                           600, NULL },
  { "dieresis",                          600, NULL },
  { "iacute",                            600, NULL },
  { "quotedblbase",                      600, NULL },
  { "ncaron",                            600, NULL },
  { "florin",                            600, NULL },
  { "yacute",                            600, NULL },
  { "Rcommaaccent",                      600, NULL },
  { "fi",                                600, NULL },
  { "fl",                                600, NULL },
  { "Acircumflex",                       600, NULL },
  { "Cacute",                            600, NULL },
  { "Icircumflex",                       600, NULL },
  { "guillemotleft",                     600, NULL },
  { "germandbls",                        600, NULL },
  { "Amacron",                           600, NULL },
  { "seven",                             600, NULL },
  { "Sacute",                            600, NULL },
  { "ordmasculine",                      600, NULL },
  { "dotlessi",                          600, NULL },
  { "sterling",                          600, NULL },
  { "notequal",                          600, NULL },
  { "Imacron",                           600, NULL },
  { "rcommaaccent",                      600, NULL },
  { "Zdotaccent",                        600, NULL },
  { "acircumflex",                       600, NULL },
  { "cacute",                            600, NULL },
  { "Ecaron",                            600, NULL },
  { "icircumflex",                       600, NULL },
  { "braceright",                        600, NULL },
  { "quotedblright",                     600, NULL },
  { "amacron",                           600, NULL },
  { "sacute",                            600, NULL },
  { "imacron",                           600, NULL },
  { "cent",                              600, NULL },
  { "currency",                          600, NULL },
  { "logicalnot",                        600, NULL },
  { "zdotaccent",                        600, NULL },
  { "Atilde",                            600, NULL },
  { "breve",                             600, NULL },
  { "bar",                               600, NULL },
  { "fraction",                          600, NULL },
  { "less",                              600, NULL },
  { "ecaron",                            600, NULL },
  { "guilsinglleft",                     600, NULL },
  { "exclam",                            600, NULL },
  { "period",                            600, NULL },
  { "Rcaron",                            600, NULL },
  { "Kcommaaccent",                      600, NULL },
  { "greater",                           600, NULL },
  { "atilde",                            600, NULL },
  { "brokenbar",                         600, NULL },
  { "quoteleft",                         600, NULL },
  { "Edotaccent",                        600, NULL },
  { "onesuperior",                       600, NULL }
};

static BuiltinFontWidth courierObliqueWidthsTab[] = {
  { "Ntilde",                            600, NULL },
  { "rcaron",                            600, NULL },
  { "kcommaaccent",                      600, NULL },
  { "Ncommaaccent",                      600, NULL },
  { "Zacute",                            600, NULL },
  { "comma",                             600, NULL },
  { "cedilla",                           600, NULL },
  { "plusminus",                         600, NULL },
  { "circumflex",                        600, NULL },
  { "dotaccent",                         600, NULL },
  { "edotaccent",                        600, NULL },
  { "asciitilde",                        600, NULL },
  { "colon",                             600, NULL },
  { "onehalf",                           600, NULL },
  { "dollar",                            600, NULL },
  { "Lcaron",                            600, NULL },
  { "ntilde",                            600, NULL },
  { "Aogonek",                           600, NULL },
  { "ncommaaccent",                      600, NULL },
  { "minus",                             600, NULL },
  { "Iogonek",                           600, NULL },
  { "zacute",                            600, NULL },
  { "yen",                               600, NULL },
  { "space",                             600, NULL },
  { "Omacron",                           600, NULL },
  { "questiondown",                      600, NULL },
  { "emdash",                            600, NULL },
  { "Agrave",                            600, NULL },
  { "three",                             600, NULL },
  { "numbersign",                        600, NULL },
  { "lcaron",                            600, NULL },
  { "A",                                 600, NULL },
  { "B",                                 600, NULL },
  { "C",                                 600, NULL },
  { "aogonek",                           600, NULL },
  { "D",                                 600, NULL },
  { "E",                                 600, NULL },
  { "onequarter",                        600, NULL },
  { "F",                                 600, NULL },
  { "G",                                 600, NULL },
  { "H",                                 600, NULL },
  { "I",                                 600, NULL },
  { "J",                                 600, NULL },
  { "K",                                 600, NULL },
  { "iogonek",                           600, NULL },
  { "backslash",                         600, NULL },
  { "L",                                 600, NULL },
  { "periodcentered",                    600, NULL },
  { "M",                                 600, NULL },
  { "N",                                 600, NULL },
  { "omacron",                           600, NULL },
  { "Tcommaaccent",                      600, NULL },
  { "O",                                 600, NULL },
  { "P",                                 600, NULL },
  { "Q",                                 600, NULL },
  { "Uhungarumlaut",                     600, NULL },
  { "R",                                 600, NULL },
  { "Aacute",                            600, NULL },
  { "caron",                             600, NULL },
  { "S",                                 600, NULL },
  { "T",                                 600, NULL },
  { "U",                                 600, NULL },
  { "agrave",                            600, NULL },
  { "V",                                 600, NULL },
  { "W",                                 600, NULL },
  { "X",                                 600, NULL },
  { "question",                          600, NULL },
  { "equal",                             600, NULL },
  { "Y",                                 600, NULL },
  { "Z",                                 600, NULL },
  { "four",                              600, NULL },
  { "a",                                 600, NULL },
  { "Gcommaaccent",                      600, NULL },
  { "b",                                 600, NULL },
  { "c",                                 600, NULL },
  { "d",                                 600, NULL },
  { "e",                                 600, NULL },
  { "f",                                 600, NULL },
  { "g",                                 600, NULL },
  { "bullet",                            600, NULL },
  { "h",                                 600, NULL },
  { "i",                                 600, NULL },
  { "Oslash",                            600, NULL },
  { "dagger",                            600, NULL },
  { "j",                                 600, NULL },
  { "k",                                 600, NULL },
  { "l",                                 600, NULL },
  { "m",                                 600, NULL },
  { "n",                                 600, NULL },
  { "tcommaaccent",                      600, NULL },
  { "o",                                 600, NULL },
  { "ordfeminine",                       600, NULL },
  { "ring",                              600, NULL },
  { "p",                                 600, NULL },
  { "q",                                 600, NULL },
  { "uhungarumlaut",                     600, NULL },
  { "r",                                 600, NULL },
  { "twosuperior",                       600, NULL },
  { "aacute",                            600, NULL },
  { "s",                                 600, NULL },
  { "OE",                                600, NULL },
  { "t",                                 600, NULL },
  { "divide",                            600, NULL },
  { "u",                                 600, NULL },
  { "Ccaron",                            600, NULL },
  { "v",                                 600, NULL },
  { "w",                                 600, NULL },
  { "x",                                 600, NULL },
  { "y",                                 600, NULL },
  { "z",                                 600, NULL },
  { "Gbreve",                            600, NULL },
  { "commaaccent",                       600, NULL },
  { "hungarumlaut",                      600, NULL },
  { "Idotaccent",                        600, NULL },
  { "Nacute",                            600, NULL },
  { "quotedbl",                          600, NULL },
  { "gcommaaccent",                      600, NULL },
  { "mu",                                600, NULL },
  { "greaterequal",                      600, NULL },
  { "Scaron",                            600, NULL },
  { "Lslash",                            600, NULL },
  { "semicolon",                         600, NULL },
  { "oslash",                            600, NULL },
  { "lessequal",                         600, NULL },
  { "lozenge",                           600, NULL },
  { "parenright",                        600, NULL },
  { "ccaron",                            600, NULL },
  { "Ecircumflex",                       600, NULL },
  { "gbreve",                            600, NULL },
  { "trademark",                         600, NULL },
  { "daggerdbl",                         600, NULL },
  { "nacute",                            600, NULL },
  { "macron",                            600, NULL },
  { "Otilde",                            600, NULL },
  { "Emacron",                           600, NULL },
  { "ellipsis",                          600, NULL },
  { "scaron",                            600, NULL },
  { "AE",                                600, NULL },
  { "Ucircumflex",                       600, NULL },
  { "lslash",                            600, NULL },
  { "quotedblleft",                      600, NULL },
  { "guilsinglright",                    600, NULL },
  { "hyphen",                            600, NULL },
  { "quotesingle",                       600, NULL },
  { "eight",                             600, NULL },
  { "exclamdown",                        600, NULL },
  { "endash",                            600, NULL },
  { "oe",                                600, NULL },
  { "Abreve",                            600, NULL },
  { "Umacron",                           600, NULL },
  { "ecircumflex",                       600, NULL },
  { "Adieresis",                         600, NULL },
  { "copyright",                         600, NULL },
  { "Egrave",                            600, NULL },
  { "slash",                             600, NULL },
  { "Edieresis",                         600, NULL },
  { "otilde",                            600, NULL },
  { "Idieresis",                         600, NULL },
  { "parenleft",                         600, NULL },
  { "one",                               600, NULL },
  { "emacron",                           600, NULL },
  { "Odieresis",                         600, NULL },
  { "ucircumflex",                       600, NULL },
  { "bracketleft",                       600, NULL },
  { "Ugrave",                            600, NULL },
  { "quoteright",                        600, NULL },
  { "Udieresis",                         600, NULL },
  { "perthousand",                       600, NULL },
  { "Ydieresis",                         600, NULL },
  { "umacron",                           600, NULL },
  { "abreve",                            600, NULL },
  { "Eacute",                            600, NULL },
  { "adieresis",                         600, NULL },
  { "egrave",                            600, NULL },
  { "edieresis",                         600, NULL },
  { "idieresis",                         600, NULL },
  { "Eth",                               600, NULL },
  { "ae",                                600, NULL },
  { "asterisk",                          600, NULL },
  { "odieresis",                         600, NULL },
  { "Uacute",                            600, NULL },
  { "ugrave",                            600, NULL },
  { "nine",                              600, NULL },
  { "five",                              600, NULL },
  { "udieresis",                         600, NULL },
  { "Zcaron",                            600, NULL },
  { "Scommaaccent",                      600, NULL },
  { "threequarters",                     600, NULL },
  { "guillemotright",                    600, NULL },
  { "Ccedilla",                          600, NULL },
  { "ydieresis",                         600, NULL },
  { "tilde",                             600, NULL },
  { "at",                                600, NULL },
  { "eacute",                            600, NULL },
  { "underscore",                        600, NULL },
  { "Euro",                              600, NULL },
  { "Dcroat",                            600, NULL },
  { "multiply",                          600, NULL },
  { "zero",                              600, NULL },
  { "eth",                               600, NULL },
  { "Scedilla",                          600, NULL },
  { "Ograve",                            600, NULL },
  { "Racute",                            600, NULL },
  { "partialdiff",                       600, NULL },
  { "uacute",                            600, NULL },
  { "braceleft",                         600, NULL },
  { "Thorn",                             600, NULL },
  { "zcaron",                            600, NULL },
  { "scommaaccent",                      600, NULL },
  { "ccedilla",                          600, NULL },
  { "Dcaron",                            600, NULL },
  { "dcroat",                            600, NULL },
  { "Ocircumflex",                       600, NULL },
  { "Oacute",                            600, NULL },
  { "scedilla",                          600, NULL },
  { "ogonek",                            600, NULL },
  { "ograve",                            600, NULL },
  { "racute",                            600, NULL },
  { "Tcaron",                            600, NULL },
  { "Eogonek",                           600, NULL },
  { "thorn",                             600, NULL },
  { "degree",                            600, NULL },
  { "registered",                        600, NULL },
  { "radical",                           600, NULL },
  { "Aring",                             600, NULL },
  { "percent",                           600, NULL },
  { "six",                               600, NULL },
  { "paragraph",                         600, NULL },
  { "dcaron",                            600, NULL },
  { "Uogonek",                           600, NULL },
  { "two",                               600, NULL },
  { "summation",                         600, NULL },
  { "Igrave",                            600, NULL },
  { "Lacute",                            600, NULL },
  { "ocircumflex",                       600, NULL },
  { "oacute",                            600, NULL },
  { "Uring",                             600, NULL },
  { "Lcommaaccent",                      600, NULL },
  { "tcaron",                            600, NULL },
  { "eogonek",                           600, NULL },
  { "Delta",                             600, NULL },
  { "Ohungarumlaut",                     600, NULL },
  { "asciicircum",                       600, NULL },
  { "aring",                             600, NULL },
  { "grave",                             600, NULL },
  { "uogonek",                           600, NULL },
  { "bracketright",                      600, NULL },
  { "Iacute",                            600, NULL },
  { "ampersand",                         600, NULL },
  { "igrave",                            600, NULL },
  { "lacute",                            600, NULL },
  { "Ncaron",                            600, NULL },
  { "plus",                              600, NULL },
  { "uring",                             600, NULL },
  { "quotesinglbase",                    600, NULL },
  { "lcommaaccent",                      600, NULL },
  { "Yacute",                            600, NULL },
  { "ohungarumlaut",                     600, NULL },
  { "threesuperior",                     600, NULL },
  { "acute",                             600, NULL },
  { "section",                           600, NULL },
  { "dieresis",                          600, NULL },
  { "iacute",                            600, NULL },
  { "quotedblbase",                      600, NULL },
  { "ncaron",                            600, NULL },
  { "florin",                            600, NULL },
  { "yacute",                            600, NULL },
  { "Rcommaaccent",                      600, NULL },
  { "fi",                                600, NULL },
  { "fl",                                600, NULL },
  { "Acircumflex",                       600, NULL },
  { "Cacute",                            600, NULL },
  { "Icircumflex",                       600, NULL },
  { "guillemotleft",                     600, NULL },
  { "germandbls",                        600, NULL },
  { "Amacron",                           600, NULL },
  { "seven",                             600, NULL },
  { "Sacute",                            600, NULL },
  { "ordmasculine",                      600, NULL },
  { "dotlessi",                          600, NULL },
  { "sterling",                          600, NULL },
  { "notequal",                          600, NULL },
  { "Imacron",                           600, NULL },
  { "rcommaaccent",                      600, NULL },
  { "Zdotaccent",                        600, NULL },
  { "acircumflex",                       600, NULL },
  { "cacute",                            600, NULL },
  { "Ecaron",                            600, NULL },
  { "icircumflex",                       600, NULL },
  { "braceright",                        600, NULL },
  { "quotedblright",                     600, NULL },
  { "amacron",                           600, NULL },
  { "sacute",                            600, NULL },
  { "imacron",                           600, NULL },
  { "cent",                              600, NULL },
  { "currency",                          600, NULL },
  { "logicalnot",                        600, NULL },
  { "zdotaccent",                        600, NULL },
  { "Atilde",                            600, NULL },
  { "breve",                             600, NULL },
  { "bar",                               600, NULL },
  { "fraction",                          600, NULL },
  { "less",                              600, NULL },
  { "ecaron",                            600, NULL },
  { "guilsinglleft",                     600, NULL },
  { "exclam",                            600, NULL },
  { "period",                            600, NULL },
  { "Rcaron",                            600, NULL },
  { "Kcommaaccent",                      600, NULL },
  { "greater",                           600, NULL },
  { "atilde",                            600, NULL },
  { "brokenbar",                         600, NULL },
  { "quoteleft",                         600, NULL },
  { "Edotaccent",                        600, NULL },
  { "onesuperior",                       600, NULL }
};

static BuiltinFontWidth helveticaWidthsTab[] = {
  { "Ntilde",                            722, NULL },
  { "rcaron",                            333, NULL },
  { "kcommaaccent",                      500, NULL },
  { "Ncommaaccent",                      722, NULL },
  { "Zacute",                            611, NULL },
  { "comma",                             278, NULL },
  { "cedilla",                           333, NULL },
  { "plusminus",                         584, NULL },
  { "circumflex",                        333, NULL },
  { "dotaccent",                         333, NULL },
  { "edotaccent",                        556, NULL },
  { "asciitilde",                        584, NULL },
  { "colon",                             278, NULL },
  { "onehalf",                           834, NULL },
  { "dollar",                            556, NULL },
  { "Lcaron",                            556, NULL },
  { "ntilde",                            556, NULL },
  { "Aogonek",                           667, NULL },
  { "ncommaaccent",                      556, NULL },
  { "minus",                             584, NULL },
  { "Iogonek",                           278, NULL },
  { "zacute",                            500, NULL },
  { "yen",                               556, NULL },
  { "space",                             278, NULL },
  { "Omacron",                           778, NULL },
  { "questiondown",                      611, NULL },
  { "emdash",                           1000, NULL },
  { "Agrave",                            667, NULL },
  { "three",                             556, NULL },
  { "numbersign",                        556, NULL },
  { "lcaron",                            299, NULL },
  { "A",                                 667, NULL },
  { "B",                                 667, NULL },
  { "C",                                 722, NULL },
  { "aogonek",                           556, NULL },
  { "D",                                 722, NULL },
  { "E",                                 667, NULL },
  { "onequarter",                        834, NULL },
  { "F",                                 611, NULL },
  { "G",                                 778, NULL },
  { "H",                                 722, NULL },
  { "I",                                 278, NULL },
  { "J",                                 500, NULL },
  { "K",                                 667, NULL },
  { "iogonek",                           222, NULL },
  { "backslash",                         278, NULL },
  { "L",                                 556, NULL },
  { "periodcentered",                    278, NULL },
  { "M",                                 833, NULL },
  { "N",                                 722, NULL },
  { "omacron",                           556, NULL },
  { "Tcommaaccent",                      611, NULL },
  { "O",                                 778, NULL },
  { "P",                                 667, NULL },
  { "Q",                                 778, NULL },
  { "Uhungarumlaut",                     722, NULL },
  { "R",                                 722, NULL },
  { "Aacute",                            667, NULL },
  { "caron",                             333, NULL },
  { "S",                                 667, NULL },
  { "T",                                 611, NULL },
  { "U",                                 722, NULL },
  { "agrave",                            556, NULL },
  { "V",                                 667, NULL },
  { "W",                                 944, NULL },
  { "X",                                 667, NULL },
  { "question",                          556, NULL },
  { "equal",                             584, NULL },
  { "Y",                                 667, NULL },
  { "Z",                                 611, NULL },
  { "four",                              556, NULL },
  { "a",                                 556, NULL },
  { "Gcommaaccent",                      778, NULL },
  { "b",                                 556, NULL },
  { "c",                                 500, NULL },
  { "d",                                 556, NULL },
  { "e",                                 556, NULL },
  { "f",                                 278, NULL },
  { "g",                                 556, NULL },
  { "bullet",                            350, NULL },
  { "h",                                 556, NULL },
  { "i",                                 222, NULL },
  { "Oslash",                            778, NULL },
  { "dagger",                            556, NULL },
  { "j",                                 222, NULL },
  { "k",                                 500, NULL },
  { "l",                                 222, NULL },
  { "m",                                 833, NULL },
  { "n",                                 556, NULL },
  { "tcommaaccent",                      278, NULL },
  { "o",                                 556, NULL },
  { "ordfeminine",                       370, NULL },
  { "ring",                              333, NULL },
  { "p",                                 556, NULL },
  { "q",                                 556, NULL },
  { "uhungarumlaut",                     556, NULL },
  { "r",                                 333, NULL },
  { "twosuperior",                       333, NULL },
  { "aacute",                            556, NULL },
  { "s",                                 500, NULL },
  { "OE",                               1000, NULL },
  { "t",                                 278, NULL },
  { "divide",                            584, NULL },
  { "u",                                 556, NULL },
  { "Ccaron",                            722, NULL },
  { "v",                                 500, NULL },
  { "w",                                 722, NULL },
  { "x",                                 500, NULL },
  { "y",                                 500, NULL },
  { "z",                                 500, NULL },
  { "Gbreve",                            778, NULL },
  { "commaaccent",                       250, NULL },
  { "hungarumlaut",                      333, NULL },
  { "Idotaccent",                        278, NULL },
  { "Nacute",                            722, NULL },
  { "quotedbl",                          355, NULL },
  { "gcommaaccent",                      556, NULL },
  { "mu",                                556, NULL },
  { "greaterequal",                      549, NULL },
  { "Scaron",                            667, NULL },
  { "Lslash",                            556, NULL },
  { "semicolon",                         278, NULL },
  { "oslash",                            611, NULL },
  { "lessequal",                         549, NULL },
  { "lozenge",                           471, NULL },
  { "parenright",                        333, NULL },
  { "ccaron",                            500, NULL },
  { "Ecircumflex",                       667, NULL },
  { "gbreve",                            556, NULL },
  { "trademark",                        1000, NULL },
  { "daggerdbl",                         556, NULL },
  { "nacute",                            556, NULL },
  { "macron",                            333, NULL },
  { "Otilde",                            778, NULL },
  { "Emacron",                           667, NULL },
  { "ellipsis",                         1000, NULL },
  { "scaron",                            500, NULL },
  { "AE",                               1000, NULL },
  { "Ucircumflex",                       722, NULL },
  { "lslash",                            222, NULL },
  { "quotedblleft",                      333, NULL },
  { "guilsinglright",                    333, NULL },
  { "hyphen",                            333, NULL },
  { "quotesingle",                       191, NULL },
  { "eight",                             556, NULL },
  { "exclamdown",                        333, NULL },
  { "endash",                            556, NULL },
  { "oe",                                944, NULL },
  { "Abreve",                            667, NULL },
  { "Umacron",                           722, NULL },
  { "ecircumflex",                       556, NULL },
  { "Adieresis",                         667, NULL },
  { "copyright",                         737, NULL },
  { "Egrave",                            667, NULL },
  { "slash",                             278, NULL },
  { "Edieresis",                         667, NULL },
  { "otilde",                            556, NULL },
  { "Idieresis",                         278, NULL },
  { "parenleft",                         333, NULL },
  { "one",                               556, NULL },
  { "emacron",                           556, NULL },
  { "Odieresis",                         778, NULL },
  { "ucircumflex",                       556, NULL },
  { "bracketleft",                       278, NULL },
  { "Ugrave",                            722, NULL },
  { "quoteright",                        222, NULL },
  { "Udieresis",                         722, NULL },
  { "perthousand",                      1000, NULL },
  { "Ydieresis",                         667, NULL },
  { "umacron",                           556, NULL },
  { "abreve",                            556, NULL },
  { "Eacute",                            667, NULL },
  { "adieresis",                         556, NULL },
  { "egrave",                            556, NULL },
  { "edieresis",                         556, NULL },
  { "idieresis",                         278, NULL },
  { "Eth",                               722, NULL },
  { "ae",                                889, NULL },
  { "asterisk",                          389, NULL },
  { "odieresis",                         556, NULL },
  { "Uacute",                            722, NULL },
  { "ugrave",                            556, NULL },
  { "nine",                              556, NULL },
  { "five",                              556, NULL },
  { "udieresis",                         556, NULL },
  { "Zcaron",                            611, NULL },
  { "Scommaaccent",                      667, NULL },
  { "threequarters",                     834, NULL },
  { "guillemotright",                    556, NULL },
  { "Ccedilla",                          722, NULL },
  { "ydieresis",                         500, NULL },
  { "tilde",                             333, NULL },
  { "at",                               1015, NULL },
  { "eacute",                            556, NULL },
  { "underscore",                        556, NULL },
  { "Euro",                              556, NULL },
  { "Dcroat",                            722, NULL },
  { "multiply",                          584, NULL },
  { "zero",                              556, NULL },
  { "eth",                               556, NULL },
  { "Scedilla",                          667, NULL },
  { "Ograve",                            778, NULL },
  { "Racute",                            722, NULL },
  { "partialdiff",                       476, NULL },
  { "uacute",                            556, NULL },
  { "braceleft",                         334, NULL },
  { "Thorn",                             667, NULL },
  { "zcaron",                            500, NULL },
  { "scommaaccent",                      500, NULL },
  { "ccedilla",                          500, NULL },
  { "Dcaron",                            722, NULL },
  { "dcroat",                            556, NULL },
  { "Ocircumflex",                       778, NULL },
  { "Oacute",                            778, NULL },
  { "scedilla",                          500, NULL },
  { "ogonek",                            333, NULL },
  { "ograve",                            556, NULL },
  { "racute",                            333, NULL },
  { "Tcaron",                            611, NULL },
  { "Eogonek",                           667, NULL },
  { "thorn",                             556, NULL },
  { "degree",                            400, NULL },
  { "registered",                        737, NULL },
  { "radical",                           453, NULL },
  { "Aring",                             667, NULL },
  { "percent",                           889, NULL },
  { "six",                               556, NULL },
  { "paragraph",                         537, NULL },
  { "dcaron",                            643, NULL },
  { "Uogonek",                           722, NULL },
  { "two",                               556, NULL },
  { "summation",                         600, NULL },
  { "Igrave",                            278, NULL },
  { "Lacute",                            556, NULL },
  { "ocircumflex",                       556, NULL },
  { "oacute",                            556, NULL },
  { "Uring",                             722, NULL },
  { "Lcommaaccent",                      556, NULL },
  { "tcaron",                            317, NULL },
  { "eogonek",                           556, NULL },
  { "Delta",                             612, NULL },
  { "Ohungarumlaut",                     778, NULL },
  { "asciicircum",                       469, NULL },
  { "aring",                             556, NULL },
  { "grave",                             333, NULL },
  { "uogonek",                           556, NULL },
  { "bracketright",                      278, NULL },
  { "Iacute",                            278, NULL },
  { "ampersand",                         667, NULL },
  { "igrave",                            278, NULL },
  { "lacute",                            222, NULL },
  { "Ncaron",                            722, NULL },
  { "plus",                              584, NULL },
  { "uring",                             556, NULL },
  { "quotesinglbase",                    222, NULL },
  { "lcommaaccent",                      222, NULL },
  { "Yacute",                            667, NULL },
  { "ohungarumlaut",                     556, NULL },
  { "threesuperior",                     333, NULL },
  { "acute",                             333, NULL },
  { "section",                           556, NULL },
  { "dieresis",                          333, NULL },
  { "iacute",                            278, NULL },
  { "quotedblbase",                      333, NULL },
  { "ncaron",                            556, NULL },
  { "florin",                            556, NULL },
  { "yacute",                            500, NULL },
  { "Rcommaaccent",                      722, NULL },
  { "fi",                                500, NULL },
  { "fl",                                500, NULL },
  { "Acircumflex",                       667, NULL },
  { "Cacute",                            722, NULL },
  { "Icircumflex",                       278, NULL },
  { "guillemotleft",                     556, NULL },
  { "germandbls",                        611, NULL },
  { "Amacron",                           667, NULL },
  { "seven",                             556, NULL },
  { "Sacute",                            667, NULL },
  { "ordmasculine",                      365, NULL },
  { "dotlessi",                          278, NULL },
  { "sterling",                          556, NULL },
  { "notequal",                          549, NULL },
  { "Imacron",                           278, NULL },
  { "rcommaaccent",                      333, NULL },
  { "Zdotaccent",                        611, NULL },
  { "acircumflex",                       556, NULL },
  { "cacute",                            500, NULL },
  { "Ecaron",                            667, NULL },
  { "icircumflex",                       278, NULL },
  { "braceright",                        334, NULL },
  { "quotedblright",                     333, NULL },
  { "amacron",                           556, NULL },
  { "sacute",                            500, NULL },
  { "imacron",                           278, NULL },
  { "cent",                              556, NULL },
  { "currency",                          556, NULL },
  { "logicalnot",                        584, NULL },
  { "zdotaccent",                        500, NULL },
  { "Atilde",                            667, NULL },
  { "breve",                             333, NULL },
  { "bar",                               260, NULL },
  { "fraction",                          167, NULL },
  { "less",                              584, NULL },
  { "ecaron",                            556, NULL },
  { "guilsinglleft",                     333, NULL },
  { "exclam",                            278, NULL },
  { "period",                            278, NULL },
  { "Rcaron",                            722, NULL },
  { "Kcommaaccent",                      667, NULL },
  { "greater",                           584, NULL },
  { "atilde",                            556, NULL },
  { "brokenbar",                         260, NULL },
  { "quoteleft",                         222, NULL },
  { "Edotaccent",                        667, NULL },
  { "onesuperior",                       333, NULL }
};

static BuiltinFontWidth helveticaBoldWidthsTab[] = {
  { "Ntilde",                            722, NULL },
  { "rcaron",                            389, NULL },
  { "kcommaaccent",                      556, NULL },
  { "Ncommaaccent",                      722, NULL },
  { "Zacute",                            611, NULL },
  { "comma",                             278, NULL },
  { "cedilla",                           333, NULL },
  { "plusminus",                         584, NULL },
  { "circumflex",                        333, NULL },
  { "dotaccent",                         333, NULL },
  { "edotaccent",                        556, NULL },
  { "asciitilde",                        584, NULL },
  { "colon",                             333, NULL },
  { "onehalf",                           834, NULL },
  { "dollar",                            556, NULL },
  { "Lcaron",                            611, NULL },
  { "ntilde",                            611, NULL },
  { "Aogonek",                           722, NULL },
  { "ncommaaccent",                      611, NULL },
  { "minus",                             584, NULL },
  { "Iogonek",                           278, NULL },
  { "zacute",                            500, NULL },
  { "yen",                               556, NULL },
  { "space",                             278, NULL },
  { "Omacron",                           778, NULL },
  { "questiondown",                      611, NULL },
  { "emdash",                           1000, NULL },
  { "Agrave",                            722, NULL },
  { "three",                             556, NULL },
  { "numbersign",                        556, NULL },
  { "lcaron",                            400, NULL },
  { "A",                                 722, NULL },
  { "B",                                 722, NULL },
  { "C",                                 722, NULL },
  { "aogonek",                           556, NULL },
  { "D",                                 722, NULL },
  { "E",                                 667, NULL },
  { "onequarter",                        834, NULL },
  { "F",                                 611, NULL },
  { "G",                                 778, NULL },
  { "H",                                 722, NULL },
  { "I",                                 278, NULL },
  { "J",                                 556, NULL },
  { "K",                                 722, NULL },
  { "iogonek",                           278, NULL },
  { "backslash",                         278, NULL },
  { "L",                                 611, NULL },
  { "periodcentered",                    278, NULL },
  { "M",                                 833, NULL },
  { "N",                                 722, NULL },
  { "omacron",                           611, NULL },
  { "Tcommaaccent",                      611, NULL },
  { "O",                                 778, NULL },
  { "P",                                 667, NULL },
  { "Q",                                 778, NULL },
  { "Uhungarumlaut",                     722, NULL },
  { "R",                                 722, NULL },
  { "Aacute",                            722, NULL },
  { "caron",                             333, NULL },
  { "S",                                 667, NULL },
  { "T",                                 611, NULL },
  { "U",                                 722, NULL },
  { "agrave",                            556, NULL },
  { "V",                                 667, NULL },
  { "W",                                 944, NULL },
  { "X",                                 667, NULL },
  { "question",                          611, NULL },
  { "equal",                             584, NULL },
  { "Y",                                 667, NULL },
  { "Z",                                 611, NULL },
  { "four",                              556, NULL },
  { "a",                                 556, NULL },
  { "Gcommaaccent",                      778, NULL },
  { "b",                                 611, NULL },
  { "c",                                 556, NULL },
  { "d",                                 611, NULL },
  { "e",                                 556, NULL },
  { "f",                                 333, NULL },
  { "g",                                 611, NULL },
  { "bullet",                            350, NULL },
  { "h",                                 611, NULL },
  { "i",                                 278, NULL },
  { "Oslash",                            778, NULL },
  { "dagger",                            556, NULL },
  { "j",                                 278, NULL },
  { "k",                                 556, NULL },
  { "l",                                 278, NULL },
  { "m",                                 889, NULL },
  { "n",                                 611, NULL },
  { "tcommaaccent",                      333, NULL },
  { "o",                                 611, NULL },
  { "ordfeminine",                       370, NULL },
  { "ring",                              333, NULL },
  { "p",                                 611, NULL },
  { "q",                                 611, NULL },
  { "uhungarumlaut",                     611, NULL },
  { "r",                                 389, NULL },
  { "twosuperior",                       333, NULL },
  { "aacute",                            556, NULL },
  { "s",                                 556, NULL },
  { "OE",                               1000, NULL },
  { "t",                                 333, NULL },
  { "divide",                            584, NULL },
  { "u",                                 611, NULL },
  { "Ccaron",                            722, NULL },
  { "v",                                 556, NULL },
  { "w",                                 778, NULL },
  { "x",                                 556, NULL },
  { "y",                                 556, NULL },
  { "z",                                 500, NULL },
  { "Gbreve",                            778, NULL },
  { "commaaccent",                       250, NULL },
  { "hungarumlaut",                      333, NULL },
  { "Idotaccent",                        278, NULL },
  { "Nacute",                            722, NULL },
  { "quotedbl",                          474, NULL },
  { "gcommaaccent",                      611, NULL },
  { "mu",                                611, NULL },
  { "greaterequal",                      549, NULL },
  { "Scaron",                            667, NULL },
  { "Lslash",                            611, NULL },
  { "semicolon",                         333, NULL },
  { "oslash",                            611, NULL },
  { "lessequal",                         549, NULL },
  { "lozenge",                           494, NULL },
  { "parenright",                        333, NULL },
  { "ccaron",                            556, NULL },
  { "Ecircumflex",                       667, NULL },
  { "gbreve",                            611, NULL },
  { "trademark",                        1000, NULL },
  { "daggerdbl",                         556, NULL },
  { "nacute",                            611, NULL },
  { "macron",                            333, NULL },
  { "Otilde",                            778, NULL },
  { "Emacron",                           667, NULL },
  { "ellipsis",                         1000, NULL },
  { "scaron",                            556, NULL },
  { "AE",                               1000, NULL },
  { "Ucircumflex",                       722, NULL },
  { "lslash",                            278, NULL },
  { "quotedblleft",                      500, NULL },
  { "guilsinglright",                    333, NULL },
  { "hyphen",                            333, NULL },
  { "quotesingle",                       238, NULL },
  { "eight",                             556, NULL },
  { "exclamdown",                        333, NULL },
  { "endash",                            556, NULL },
  { "oe",                                944, NULL },
  { "Abreve",                            722, NULL },
  { "Umacron",                           722, NULL },
  { "ecircumflex",                       556, NULL },
  { "Adieresis",                         722, NULL },
  { "copyright",                         737, NULL },
  { "Egrave",                            667, NULL },
  { "slash",                             278, NULL },
  { "Edieresis",                         667, NULL },
  { "otilde",                            611, NULL },
  { "Idieresis",                         278, NULL },
  { "parenleft",                         333, NULL },
  { "one",                               556, NULL },
  { "emacron",                           556, NULL },
  { "Odieresis",                         778, NULL },
  { "ucircumflex",                       611, NULL },
  { "bracketleft",                       333, NULL },
  { "Ugrave",                            722, NULL },
  { "quoteright",                        278, NULL },
  { "Udieresis",                         722, NULL },
  { "perthousand",                      1000, NULL },
  { "Ydieresis",                         667, NULL },
  { "umacron",                           611, NULL },
  { "abreve",                            556, NULL },
  { "Eacute",                            667, NULL },
  { "adieresis",                         556, NULL },
  { "egrave",                            556, NULL },
  { "edieresis",                         556, NULL },
  { "idieresis",                         278, NULL },
  { "Eth",                               722, NULL },
  { "ae",                                889, NULL },
  { "asterisk",                          389, NULL },
  { "odieresis",                         611, NULL },
  { "Uacute",                            722, NULL },
  { "ugrave",                            611, NULL },
  { "nine",                              556, NULL },
  { "five",                              556, NULL },
  { "udieresis",                         611, NULL },
  { "Zcaron",                            611, NULL },
  { "Scommaaccent",                      667, NULL },
  { "threequarters",                     834, NULL },
  { "guillemotright",                    556, NULL },
  { "Ccedilla",                          722, NULL },
  { "ydieresis",                         556, NULL },
  { "tilde",                             333, NULL },
  { "dbldaggerumlaut",                   556, NULL },
  { "at",                                975, NULL },
  { "eacute",                            556, NULL },
  { "underscore",                        556, NULL },
  { "Euro",                              556, NULL },
  { "Dcroat",                            722, NULL },
  { "multiply",                          584, NULL },
  { "zero",                              556, NULL },
  { "eth",                               611, NULL },
  { "Scedilla",                          667, NULL },
  { "Ograve",                            778, NULL },
  { "Racute",                            722, NULL },
  { "partialdiff",                       494, NULL },
  { "uacute",                            611, NULL },
  { "braceleft",                         389, NULL },
  { "Thorn",                             667, NULL },
  { "zcaron",                            500, NULL },
  { "scommaaccent",                      556, NULL },
  { "ccedilla",                          556, NULL },
  { "Dcaron",                            722, NULL },
  { "dcroat",                            611, NULL },
  { "Ocircumflex",                       778, NULL },
  { "Oacute",                            778, NULL },
  { "scedilla",                          556, NULL },
  { "ogonek",                            333, NULL },
  { "ograve",                            611, NULL },
  { "racute",                            389, NULL },
  { "Tcaron",                            611, NULL },
  { "Eogonek",                           667, NULL },
  { "thorn",                             611, NULL },
  { "degree",                            400, NULL },
  { "registered",                        737, NULL },
  { "radical",                           549, NULL },
  { "Aring",                             722, NULL },
  { "percent",                           889, NULL },
  { "six",                               556, NULL },
  { "paragraph",                         556, NULL },
  { "dcaron",                            743, NULL },
  { "Uogonek",                           722, NULL },
  { "two",                               556, NULL },
  { "summation",                         600, NULL },
  { "Igrave",                            278, NULL },
  { "Lacute",                            611, NULL },
  { "ocircumflex",                       611, NULL },
  { "oacute",                            611, NULL },
  { "Uring",                             722, NULL },
  { "Lcommaaccent",                      611, NULL },
  { "tcaron",                            389, NULL },
  { "eogonek",                           556, NULL },
  { "Delta",                             612, NULL },
  { "Ohungarumlaut",                     778, NULL },
  { "asciicircum",                       584, NULL },
  { "aring",                             556, NULL },
  { "grave",                             333, NULL },
  { "uogonek",                           611, NULL },
  { "bracketright",                      333, NULL },
  { "Iacute",                            278, NULL },
  { "ampersand",                         722, NULL },
  { "igrave",                            278, NULL },
  { "lacute",                            278, NULL },
  { "Ncaron",                            722, NULL },
  { "plus",                              584, NULL },
  { "uring",                             611, NULL },
  { "quotesinglbase",                    278, NULL },
  { "lcommaaccent",                      278, NULL },
  { "Yacute",                            667, NULL },
  { "ohungarumlaut",                     611, NULL },
  { "threesuperior",                     333, NULL },
  { "acute",                             333, NULL },
  { "section",                           556, NULL },
  { "dieresis",                          333, NULL },
  { "iacute",                            278, NULL },
  { "quotedblbase",                      500, NULL },
  { "ncaron",                            611, NULL },
  { "florin",                            556, NULL },
  { "yacute",                            556, NULL },
  { "Rcommaaccent",                      722, NULL },
  { "fi",                                611, NULL },
  { "fl",                                611, NULL },
  { "Acircumflex",                       722, NULL },
  { "Cacute",                            722, NULL },
  { "Icircumflex",                       278, NULL },
  { "guillemotleft",                     556, NULL },
  { "germandbls",                        611, NULL },
  { "Amacron",                           722, NULL },
  { "seven",                             556, NULL },
  { "Sacute",                            667, NULL },
  { "ordmasculine",                      365, NULL },
  { "dotlessi",                          278, NULL },
  { "sterling",                          556, NULL },
  { "notequal",                          549, NULL },
  { "Imacron",                           278, NULL },
  { "rcommaaccent",                      389, NULL },
  { "Zdotaccent",                        611, NULL },
  { "acircumflex",                       556, NULL },
  { "cacute",                            556, NULL },
  { "Ecaron",                            667, NULL },
  { "icircumflex",                       278, NULL },
  { "braceright",                        389, NULL },
  { "quotedblright",                     500, NULL },
  { "amacron",                           556, NULL },
  { "sacute",                            556, NULL },
  { "imacron",                           278, NULL },
  { "cent",                              556, NULL },
  { "currency",                          556, NULL },
  { "logicalnot",                        584, NULL },
  { "zdotaccent",                        500, NULL },
  { "Atilde",                            722, NULL },
  { "breve",                             333, NULL },
  { "bar",                               280, NULL },
  { "fraction",                          167, NULL },
  { "less",                              584, NULL },
  { "ecaron",                            556, NULL },
  { "guilsinglleft",                     333, NULL },
  { "exclam",                            333, NULL },
  { "period",                            278, NULL },
  { "Rcaron",                            722, NULL },
  { "Kcommaaccent",                      722, NULL },
  { "greater",                           584, NULL },
  { "atilde",                            556, NULL },
  { "brokenbar",                         280, NULL },
  { "quoteleft",                         278, NULL },
  { "Edotaccent",                        667, NULL },
  { "onesuperior",                       333, NULL }
};

static BuiltinFontWidth helveticaBoldObliqueWidthsTab[] = {
  { "Ntilde",                            722, NULL },
  { "rcaron",                            389, NULL },
  { "kcommaaccent",                      556, NULL },
  { "Ncommaaccent",                      722, NULL },
  { "Zacute",                            611, NULL },
  { "comma",                             278, NULL },
  { "cedilla",                           333, NULL },
  { "plusminus",                         584, NULL },
  { "circumflex",                        333, NULL },
  { "dotaccent",                         333, NULL },
  { "edotaccent",                        556, NULL },
  { "asciitilde",                        584, NULL },
  { "colon",                             333, NULL },
  { "onehalf",                           834, NULL },
  { "dollar",                            556, NULL },
  { "Lcaron",                            611, NULL },
  { "ntilde",                            611, NULL },
  { "Aogonek",                           722, NULL },
  { "ncommaaccent",                      611, NULL },
  { "minus",                             584, NULL },
  { "Iogonek",                           278, NULL },
  { "zacute",                            500, NULL },
  { "yen",                               556, NULL },
  { "space",                             278, NULL },
  { "Omacron",                           778, NULL },
  { "questiondown",                      611, NULL },
  { "emdash",                           1000, NULL },
  { "Agrave",                            722, NULL },
  { "three",                             556, NULL },
  { "numbersign",                        556, NULL },
  { "lcaron",                            400, NULL },
  { "A",                                 722, NULL },
  { "B",                                 722, NULL },
  { "C",                                 722, NULL },
  { "aogonek",                           556, NULL },
  { "D",                                 722, NULL },
  { "E",                                 667, NULL },
  { "onequarter",                        834, NULL },
  { "F",                                 611, NULL },
  { "G",                                 778, NULL },
  { "H",                                 722, NULL },
  { "I",                                 278, NULL },
  { "J",                                 556, NULL },
  { "K",                                 722, NULL },
  { "iogonek",                           278, NULL },
  { "backslash",                         278, NULL },
  { "L",                                 611, NULL },
  { "periodcentered",                    278, NULL },
  { "M",                                 833, NULL },
  { "N",                                 722, NULL },
  { "omacron",                           611, NULL },
  { "Tcommaaccent",                      611, NULL },
  { "O",                                 778, NULL },
  { "P",                                 667, NULL },
  { "Q",                                 778, NULL },
  { "Uhungarumlaut",                     722, NULL },
  { "R",                                 722, NULL },
  { "Aacute",                            722, NULL },
  { "caron",                             333, NULL },
  { "S",                                 667, NULL },
  { "T",                                 611, NULL },
  { "U",                                 722, NULL },
  { "agrave",                            556, NULL },
  { "V",                                 667, NULL },
  { "W",                                 944, NULL },
  { "X",                                 667, NULL },
  { "question",                          611, NULL },
  { "equal",                             584, NULL },
  { "Y",                                 667, NULL },
  { "Z",                                 611, NULL },
  { "four",                              556, NULL },
  { "a",                                 556, NULL },
  { "Gcommaaccent",                      778, NULL },
  { "b",                                 611, NULL },
  { "c",                                 556, NULL },
  { "d",                                 611, NULL },
  { "e",                                 556, NULL },
  { "f",                                 333, NULL },
  { "g",                                 611, NULL },
  { "bullet",                            350, NULL },
  { "h",                                 611, NULL },
  { "i",                                 278, NULL },
  { "Oslash",                            778, NULL },
  { "dagger",                            556, NULL },
  { "j",                                 278, NULL },
  { "k",                                 556, NULL },
  { "l",                                 278, NULL },
  { "m",                                 889, NULL },
  { "n",                                 611, NULL },
  { "tcommaaccent",                      333, NULL },
  { "o",                                 611, NULL },
  { "ordfeminine",                       370, NULL },
  { "ring",                              333, NULL },
  { "p",                                 611, NULL },
  { "q",                                 611, NULL },
  { "uhungarumlaut",                     611, NULL },
  { "r",                                 389, NULL },
  { "twosuperior",                       333, NULL },
  { "aacute",                            556, NULL },
  { "s",                                 556, NULL },
  { "OE",                               1000, NULL },
  { "t",                                 333, NULL },
  { "divide",                            584, NULL },
  { "u",                                 611, NULL },
  { "Ccaron",                            722, NULL },
  { "v",                                 556, NULL },
  { "w",                                 778, NULL },
  { "x",                                 556, NULL },
  { "y",                                 556, NULL },
  { "z",                                 500, NULL },
  { "Gbreve",                            778, NULL },
  { "commaaccent",                       250, NULL },
  { "hungarumlaut",                      333, NULL },
  { "Idotaccent",                        278, NULL },
  { "Nacute",                            722, NULL },
  { "quotedbl",                          474, NULL },
  { "gcommaaccent",                      611, NULL },
  { "mu",                                611, NULL },
  { "greaterequal",                      549, NULL },
  { "Scaron",                            667, NULL },
  { "Lslash",                            611, NULL },
  { "semicolon",                         333, NULL },
  { "oslash",                            611, NULL },
  { "lessequal",                         549, NULL },
  { "lozenge",                           494, NULL },
  { "parenright",                        333, NULL },
  { "ccaron",                            556, NULL },
  { "Ecircumflex",                       667, NULL },
  { "gbreve",                            611, NULL },
  { "trademark",                        1000, NULL },
  { "daggerdbl",                         556, NULL },
  { "nacute",                            611, NULL },
  { "macron",                            333, NULL },
  { "Otilde",                            778, NULL },
  { "Emacron",                           667, NULL },
  { "ellipsis",                         1000, NULL },
  { "scaron",                            556, NULL },
  { "AE",                               1000, NULL },
  { "Ucircumflex",                       722, NULL },
  { "lslash",                            278, NULL },
  { "quotedblleft",                      500, NULL },
  { "guilsinglright",                    333, NULL },
  { "hyphen",                            333, NULL },
  { "quotesingle",                       238, NULL },
  { "eight",                             556, NULL },
  { "exclamdown",                        333, NULL },
  { "endash",                            556, NULL },
  { "oe",                                944, NULL },
  { "Abreve",                            722, NULL },
  { "Umacron",                           722, NULL },
  { "ecircumflex",                       556, NULL },
  { "Adieresis",                         722, NULL },
  { "copyright",                         737, NULL },
  { "Egrave",                            667, NULL },
  { "slash",                             278, NULL },
  { "Edieresis",                         667, NULL },
  { "otilde",                            611, NULL },
  { "Idieresis",                         278, NULL },
  { "parenleft",                         333, NULL },
  { "one",                               556, NULL },
  { "emacron",                           556, NULL },
  { "Odieresis",                         778, NULL },
  { "ucircumflex",                       611, NULL },
  { "bracketleft",                       333, NULL },
  { "Ugrave",                            722, NULL },
  { "quoteright",                        278, NULL },
  { "Udieresis",                         722, NULL },
  { "perthousand",                      1000, NULL },
  { "Ydieresis",                         667, NULL },
  { "umacron",                           611, NULL },
  { "abreve",                            556, NULL },
  { "Eacute",                            667, NULL },
  { "adieresis",                         556, NULL },
  { "egrave",                            556, NULL },
  { "edieresis",                         556, NULL },
  { "idieresis",                         278, NULL },
  { "Eth",                               722, NULL },
  { "ae",                                889, NULL },
  { "asterisk",                          389, NULL },
  { "odieresis",                         611, NULL },
  { "Uacute",                            722, NULL },
  { "ugrave",                            611, NULL },
  { "nine",                              556, NULL },
  { "five",                              556, NULL },
  { "udieresis",                         611, NULL },
  { "Zcaron",                            611, NULL },
  { "Scommaaccent",                      667, NULL },
  { "threequarters",                     834, NULL },
  { "guillemotright",                    556, NULL },
  { "Ccedilla",                          722, NULL },
  { "ydieresis",                         556, NULL },
  { "tilde",                             333, NULL },
  { "at",                                975, NULL },
  { "eacute",                            556, NULL },
  { "underscore",                        556, NULL },
  { "Euro",                              556, NULL },
  { "Dcroat",                            722, NULL },
  { "multiply",                          584, NULL },
  { "zero",                              556, NULL },
  { "eth",                               611, NULL },
  { "Scedilla",                          667, NULL },
  { "Ograve",                            778, NULL },
  { "Racute",                            722, NULL },
  { "partialdiff",                       494, NULL },
  { "uacute",                            611, NULL },
  { "braceleft",                         389, NULL },
  { "Thorn",                             667, NULL },
  { "zcaron",                            500, NULL },
  { "scommaaccent",                      556, NULL },
  { "ccedilla",                          556, NULL },
  { "Dcaron",                            722, NULL },
  { "dcroat",                            611, NULL },
  { "Ocircumflex",                       778, NULL },
  { "Oacute",                            778, NULL },
  { "scedilla",                          556, NULL },
  { "ogonek",                            333, NULL },
  { "ograve",                            611, NULL },
  { "racute",                            389, NULL },
  { "Tcaron",                            611, NULL },
  { "Eogonek",                           667, NULL },
  { "thorn",                             611, NULL },
  { "degree",                            400, NULL },
  { "registered",                        737, NULL },
  { "radical",                           549, NULL },
  { "Aring",                             722, NULL },
  { "percent",                           889, NULL },
  { "six",                               556, NULL },
  { "paragraph",                         556, NULL },
  { "dcaron",                            743, NULL },
  { "Uogonek",                           722, NULL },
  { "two",                               556, NULL },
  { "summation",                         600, NULL },
  { "Igrave",                            278, NULL },
  { "Lacute",                            611, NULL },
  { "ocircumflex",                       611, NULL },
  { "oacute",                            611, NULL },
  { "Uring",                             722, NULL },
  { "Lcommaaccent",                      611, NULL },
  { "tcaron",                            389, NULL },
  { "eogonek",                           556, NULL },
  { "Delta",                             612, NULL },
  { "Ohungarumlaut",                     778, NULL },
  { "asciicircum",                       584, NULL },
  { "aring",                             556, NULL },
  { "grave",                             333, NULL },
  { "uogonek",                           611, NULL },
  { "bracketright",                      333, NULL },
  { "Iacute",                            278, NULL },
  { "ampersand",                         722, NULL },
  { "igrave",                            278, NULL },
  { "lacute",                            278, NULL },
  { "Ncaron",                            722, NULL },
  { "plus",                              584, NULL },
  { "uring",                             611, NULL },
  { "quotesinglbase",                    278, NULL },
  { "lcommaaccent",                      278, NULL },
  { "Yacute",                            667, NULL },
  { "ohungarumlaut",                     611, NULL },
  { "threesuperior",                     333, NULL },
  { "acute",                             333, NULL },
  { "section",                           556, NULL },
  { "dieresis",                          333, NULL },
  { "iacute",                            278, NULL },
  { "quotedblbase",                      500, NULL },
  { "ncaron",                            611, NULL },
  { "florin",                            556, NULL },
  { "yacute",                            556, NULL },
  { "Rcommaaccent",                      722, NULL },
  { "fi",                                611, NULL },
  { "fl",                                611, NULL },
  { "Acircumflex",                       722, NULL },
  { "Cacute",                            722, NULL },
  { "Icircumflex",                       278, NULL },
  { "guillemotleft",                     556, NULL },
  { "germandbls",                        611, NULL },
  { "Amacron",                           722, NULL },
  { "seven",                             556, NULL },
  { "Sacute",                            667, NULL },
  { "ordmasculine",                      365, NULL },
  { "dotlessi",                          278, NULL },
  { "sterling",                          556, NULL },
  { "notequal",                          549, NULL },
  { "Imacron",                           278, NULL },
  { "rcommaaccent",                      389, NULL },
  { "Zdotaccent",                        611, NULL },
  { "acircumflex",                       556, NULL },
  { "cacute",                            556, NULL },
  { "Ecaron",                            667, NULL },
  { "icircumflex",                       278, NULL },
  { "braceright",                        389, NULL },
  { "quotedblright",                     500, NULL },
  { "amacron",                           556, NULL },
  { "sacute",                            556, NULL },
  { "imacron",                           278, NULL },
  { "cent",                              556, NULL },
  { "currency",                          556, NULL },
  { "logicalnot",                        584, NULL },
  { "zdotaccent",                        500, NULL },
  { "Atilde",                            722, NULL },
  { "breve",                             333, NULL },
  { "bar",                               280, NULL },
  { "fraction",                          167, NULL },
  { "less",                              584, NULL },
  { "ecaron",                            556, NULL },
  { "guilsinglleft",                     333, NULL },
  { "exclam",                            333, NULL },
  { "period",                            278, NULL },
  { "Rcaron",                            722, NULL },
  { "Kcommaaccent",                      722, NULL },
  { "greater",                           584, NULL },
  { "atilde",                            556, NULL },
  { "brokenbar",                         280, NULL },
  { "quoteleft",                         278, NULL },
  { "Edotaccent",                        667, NULL },
  { "onesuperior",                       333, NULL }
};

static BuiltinFontWidth helveticaObliqueWidthsTab[] = {
  { "Ntilde",                            722, NULL },
  { "rcaron",                            333, NULL },
  { "kcommaaccent",                      500, NULL },
  { "Ncommaaccent",                      722, NULL },
  { "Zacute",                            611, NULL },
  { "comma",                             278, NULL },
  { "cedilla",                           333, NULL },
  { "plusminus",                         584, NULL },
  { "circumflex",                        333, NULL },
  { "dotaccent",                         333, NULL },
  { "edotaccent",                        556, NULL },
  { "asciitilde",                        584, NULL },
  { "colon",                             278, NULL },
  { "onehalf",                           834, NULL },
  { "dollar",                            556, NULL },
  { "Lcaron",                            556, NULL },
  { "ntilde",                            556, NULL },
  { "Aogonek",                           667, NULL },
  { "ncommaaccent",                      556, NULL },
  { "minus",                             584, NULL },
  { "Iogonek",                           278, NULL },
  { "zacute",                            500, NULL },
  { "yen",                               556, NULL },
  { "space",                             278, NULL },
  { "Omacron",                           778, NULL },
  { "questiondown",                      611, NULL },
  { "emdash",                           1000, NULL },
  { "Agrave",                            667, NULL },
  { "three",                             556, NULL },
  { "numbersign",                        556, NULL },
  { "lcaron",                            299, NULL },
  { "A",                                 667, NULL },
  { "B",                                 667, NULL },
  { "C",                                 722, NULL },
  { "aogonek",                           556, NULL },
  { "D",                                 722, NULL },
  { "E",                                 667, NULL },
  { "onequarter",                        834, NULL },
  { "F",                                 611, NULL },
  { "G",                                 778, NULL },
  { "H",                                 722, NULL },
  { "I",                                 278, NULL },
  { "J",                                 500, NULL },
  { "K",                                 667, NULL },
  { "iogonek",                           222, NULL },
  { "backslash",                         278, NULL },
  { "L",                                 556, NULL },
  { "periodcentered",                    278, NULL },
  { "M",                                 833, NULL },
  { "N",                                 722, NULL },
  { "omacron",                           556, NULL },
  { "Tcommaaccent",                      611, NULL },
  { "O",                                 778, NULL },
  { "P",                                 667, NULL },
  { "Q",                                 778, NULL },
  { "Uhungarumlaut",                     722, NULL },
  { "R",                                 722, NULL },
  { "Aacute",                            667, NULL },
  { "caron",                             333, NULL },
  { "S",                                 667, NULL },
  { "T",                                 611, NULL },
  { "U",                                 722, NULL },
  { "agrave",                            556, NULL },
  { "V",                                 667, NULL },
  { "W",                                 944, NULL },
  { "X",                                 667, NULL },
  { "question",                          556, NULL },
  { "equal",                             584, NULL },
  { "Y",                                 667, NULL },
  { "Z",                                 611, NULL },
  { "four",                              556, NULL },
  { "a",                                 556, NULL },
  { "Gcommaaccent",                      778, NULL },
  { "b",                                 556, NULL },
  { "c",                                 500, NULL },
  { "d",                                 556, NULL },
  { "e",                                 556, NULL },
  { "f",                                 278, NULL },
  { "g",                                 556, NULL },
  { "bullet",                            350, NULL },
  { "h",                                 556, NULL },
  { "i",                                 222, NULL },
  { "Oslash",                            778, NULL },
  { "dagger",                            556, NULL },
  { "j",                                 222, NULL },
  { "k",                                 500, NULL },
  { "l",                                 222, NULL },
  { "m",                                 833, NULL },
  { "n",                                 556, NULL },
  { "tcommaaccent",                      278, NULL },
  { "o",                                 556, NULL },
  { "ordfeminine",                       370, NULL },
  { "ring",                              333, NULL },
  { "p",                                 556, NULL },
  { "q",                                 556, NULL },
  { "uhungarumlaut",                     556, NULL },
  { "r",                                 333, NULL },
  { "twosuperior",                       333, NULL },
  { "aacute",                            556, NULL },
  { "s",                                 500, NULL },
  { "OE",                               1000, NULL },
  { "t",                                 278, NULL },
  { "divide",                            584, NULL },
  { "u",                                 556, NULL },
  { "Ccaron",                            722, NULL },
  { "v",                                 500, NULL },
  { "w",                                 722, NULL },
  { "x",                                 500, NULL },
  { "y",                                 500, NULL },
  { "z",                                 500, NULL },
  { "Gbreve",                            778, NULL },
  { "commaaccent",                       250, NULL },
  { "hungarumlaut",                      333, NULL },
  { "Idotaccent",                        278, NULL },
  { "Nacute",                            722, NULL },
  { "quotedbl",                          355, NULL },
  { "gcommaaccent",                      556, NULL },
  { "mu",                                556, NULL },
  { "greaterequal",                      549, NULL },
  { "Scaron",                            667, NULL },
  { "Lslash",                            556, NULL },
  { "semicolon",                         278, NULL },
  { "oslash",                            611, NULL },
  { "lessequal",                         549, NULL },
  { "lozenge",                           471, NULL },
  { "parenright",                        333, NULL },
  { "ccaron",                            500, NULL },
  { "Ecircumflex",                       667, NULL },
  { "gbreve",                            556, NULL },
  { "trademark",                        1000, NULL },
  { "daggerdbl",                         556, NULL },
  { "nacute",                            556, NULL },
  { "macron",                            333, NULL },
  { "Otilde",                            778, NULL },
  { "Emacron",                           667, NULL },
  { "ellipsis",                         1000, NULL },
  { "scaron",                            500, NULL },
  { "AE",                               1000, NULL },
  { "Ucircumflex",                       722, NULL },
  { "lslash",                            222, NULL },
  { "quotedblleft",                      333, NULL },
  { "guilsinglright",                    333, NULL },
  { "hyphen",                            333, NULL },
  { "quotesingle",                       191, NULL },
  { "eight",                             556, NULL },
  { "exclamdown",                        333, NULL },
  { "endash",                            556, NULL },
  { "oe",                                944, NULL },
  { "Abreve",                            667, NULL },
  { "Umacron",                           722, NULL },
  { "ecircumflex",                       556, NULL },
  { "Adieresis",                         667, NULL },
  { "copyright",                         737, NULL },
  { "Egrave",                            667, NULL },
  { "slash",                             278, NULL },
  { "Edieresis",                         667, NULL },
  { "otilde",                            556, NULL },
  { "Idieresis",                         278, NULL },
  { "parenleft",                         333, NULL },
  { "one",                               556, NULL },
  { "emacron",                           556, NULL },
  { "Odieresis",                         778, NULL },
  { "ucircumflex",                       556, NULL },
  { "bracketleft",                       278, NULL },
  { "Ugrave",                            722, NULL },
  { "quoteright",                        222, NULL },
  { "Udieresis",                         722, NULL },
  { "perthousand",                      1000, NULL },
  { "Ydieresis",                         667, NULL },
  { "umacron",                           556, NULL },
  { "abreve",                            556, NULL },
  { "Eacute",                            667, NULL },
  { "adieresis",                         556, NULL },
  { "egrave",                            556, NULL },
  { "edieresis",                         556, NULL },
  { "idieresis",                         278, NULL },
  { "Eth",                               722, NULL },
  { "ae",                                889, NULL },
  { "asterisk",                          389, NULL },
  { "odieresis",                         556, NULL },
  { "Uacute",                            722, NULL },
  { "ugrave",                            556, NULL },
  { "nine",                              556, NULL },
  { "five",                              556, NULL },
  { "udieresis",                         556, NULL },
  { "Zcaron",                            611, NULL },
  { "Scommaaccent",                      667, NULL },
  { "threequarters",                     834, NULL },
  { "guillemotright",                    556, NULL },
  { "Ccedilla",                          722, NULL },
  { "ydieresis",                         500, NULL },
  { "tilde",                             333, NULL },
  { "at",                               1015, NULL },
  { "eacute",                            556, NULL },
  { "underscore",                        556, NULL },
  { "Euro",                              556, NULL },
  { "Dcroat",                            722, NULL },
  { "multiply",                          584, NULL },
  { "zero",                              556, NULL },
  { "eth",                               556, NULL },
  { "Scedilla",                          667, NULL },
  { "Ograve",                            778, NULL },
  { "Racute",                            722, NULL },
  { "partialdiff",                       476, NULL },
  { "uacute",                            556, NULL },
  { "braceleft",                         334, NULL },
  { "Thorn",                             667, NULL },
  { "zcaron",                            500, NULL },
  { "scommaaccent",                      500, NULL },
  { "ccedilla",                          500, NULL },
  { "Dcaron",                            722, NULL },
  { "dcroat",                            556, NULL },
  { "Ocircumflex",                       778, NULL },
  { "Oacute",                            778, NULL },
  { "scedilla",                          500, NULL },
  { "ogonek",                            333, NULL },
  { "ograve",                            556, NULL },
  { "racute",                            333, NULL },
  { "Tcaron",                            611, NULL },
  { "Eogonek",                           667, NULL },
  { "thorn",                             556, NULL },
  { "degree",                            400, NULL },
  { "registered",                        737, NULL },
  { "radical",                           453, NULL },
  { "Aring",                             667, NULL },
  { "percent",                           889, NULL },
  { "six",                               556, NULL },
  { "paragraph",                         537, NULL },
  { "dcaron",                            643, NULL },
  { "Uogonek",                           722, NULL },
  { "two",                               556, NULL },
  { "summation",                         600, NULL },
  { "Igrave",                            278, NULL },
  { "Lacute",                            556, NULL },
  { "ocircumflex",                       556, NULL },
  { "oacute",                            556, NULL },
  { "Uring",                             722, NULL },
  { "Lcommaaccent",                      556, NULL },
  { "tcaron",                            317, NULL },
  { "eogonek",                           556, NULL },
  { "Delta",                             612, NULL },
  { "Ohungarumlaut",                     778, NULL },
  { "asciicircum",                       469, NULL },
  { "aring",                             556, NULL },
  { "grave",                             333, NULL },
  { "uogonek",                           556, NULL },
  { "bracketright",                      278, NULL },
  { "Iacute",                            278, NULL },
  { "ampersand",                         667, NULL },
  { "igrave",                            278, NULL },
  { "lacute",                            222, NULL },
  { "Ncaron",                            722, NULL },
  { "plus",                              584, NULL },
  { "uring",                             556, NULL },
  { "quotesinglbase",                    222, NULL },
  { "lcommaaccent",                      222, NULL },
  { "Yacute",                            667, NULL },
  { "ohungarumlaut",                     556, NULL },
  { "threesuperior",                     333, NULL },
  { "acute",                             333, NULL },
  { "section",                           556, NULL },
  { "dieresis",                          333, NULL },
  { "iacute",                            278, NULL },
  { "quotedblbase",                      333, NULL },
  { "ncaron",                            556, NULL },
  { "florin",                            556, NULL },
  { "yacute",                            500, NULL },
  { "Rcommaaccent",                      722, NULL },
  { "fi",                                500, NULL },
  { "fl",                                500, NULL },
  { "Acircumflex",                       667, NULL },
  { "Cacute",                            722, NULL },
  { "Icircumflex",                       278, NULL },
  { "guillemotleft",                     556, NULL },
  { "germandbls",                        611, NULL },
  { "Amacron",                           667, NULL },
  { "seven",                             556, NULL },
  { "Sacute",                            667, NULL },
  { "ordmasculine",                      365, NULL },
  { "dotlessi",                          278, NULL },
  { "sterling",                          556, NULL },
  { "notequal",                          549, NULL },
  { "Imacron",                           278, NULL },
  { "rcommaaccent",                      333, NULL },
  { "Zdotaccent",                        611, NULL },
  { "acircumflex",                       556, NULL },
  { "cacute",                            500, NULL },
  { "Ecaron",                            667, NULL },
  { "icircumflex",                       278, NULL },
  { "braceright",                        334, NULL },
  { "quotedblright",                     333, NULL },
  { "amacron",                           556, NULL },
  { "sacute",                            500, NULL },
  { "imacron",                           278, NULL },
  { "cent",                              556, NULL },
  { "currency",                          556, NULL },
  { "logicalnot",                        584, NULL },
  { "zdotaccent",                        500, NULL },
  { "Atilde",                            667, NULL },
  { "breve",                             333, NULL },
  { "bar",                               260, NULL },
  { "fraction",                          167, NULL },
  { "less",                              584, NULL },
  { "ecaron",                            556, NULL },
  { "guilsinglleft",                     333, NULL },
  { "exclam",                            278, NULL },
  { "period",                            278, NULL },
  { "Rcaron",                            722, NULL },
  { "Kcommaaccent",                      667, NULL },
  { "greater",                           584, NULL },
  { "atilde",                            556, NULL },
  { "brokenbar",                         260, NULL },
  { "quoteleft",                         222, NULL },
  { "Edotaccent",                        667, NULL },
  { "onesuperior",                       333, NULL }
};

static BuiltinFontWidth symbolWidthsTab[] = {
  { "bracketleftex",                     384, NULL },
  { "alpha",                             631, NULL },
  { "union",                             768, NULL },
  { "infinity",                          713, NULL },
  { "comma",                             250, NULL },
  { "copyrightsans",                     790, NULL },
  { "plusminus",                         549, NULL },
  { "arrowup",                           603, NULL },
  { "apple",                             790, NULL },
  { "parenleftbt",                       384, NULL },
  { "notelement",                        713, NULL },
  { "colon",                             278, NULL },
  { "beta",                              549, NULL },
  { "braceleftbt",                       494, NULL },
  { "Lambda",                            686, NULL },
  { "Phi",                               763, NULL },
  { "minus",                             549, NULL },
  { "space",                             250, NULL },
  { "Sigma",                             592, NULL },
  { "approxequal",                       549, NULL },
  { "minute",                            247, NULL },
  { "circleplus",                        768, NULL },
  { "Omicron",                           722, NULL },
  { "three",                             500, NULL },
  { "numbersign",                        500, NULL },
  { "lambda",                            549, NULL },
  { "phi",                               521, NULL },
  { "aleph",                             823, NULL },
  { "Tau",                               611, NULL },
  { "spade",                             753, NULL },
  { "logicaland",                        603, NULL },
  { "sigma",                             603, NULL },
  { "propersuperset",                    713, NULL },
  { "omicron",                           549, NULL },
  { "question",                          444, NULL },
  { "equal",                             549, NULL },
  { "Epsilon",                           611, NULL },
  { "emptyset",                          823, NULL },
  { "diamond",                           753, NULL },
  { "four",                              500, NULL },
  { "Mu",                                889, NULL },
  { "parenlefttp",                       384, NULL },
  { "club",                              753, NULL },
  { "bullet",                            460, NULL },
  { "Omega",                             768, NULL },
  { "tau",                               439, NULL },
  { "Upsilon",                           690, NULL },
  { "bracelefttp",                       494, NULL },
  { "heart",                             753, NULL },
  { "divide",                            549, NULL },
  { "epsilon",                           439, NULL },
  { "logicalor",                         603, NULL },
  { "parenleftex",                       384, NULL },
  { "greaterequal",                      549, NULL },
  { "mu",                                576, NULL },
  { "Nu",                                722, NULL },
  { "therefore",                         863, NULL },
  { "notsubset",                         713, NULL },
  { "omega",                             686, NULL },
  { "semicolon",                         278, NULL },
  { "element",                           713, NULL },
  { "upsilon",                           576, NULL },
  { "existential",                       549, NULL },
  { "integralbt",                        686, NULL },
  { "lessequal",                         549, NULL },
  { "phi1",                              603, NULL },
  { "lozenge",                           494, NULL },
  { "trademarkserif",                    890, NULL },
  { "parenright",                        333, NULL },
  { "reflexsuperset",                    713, NULL },
  { "sigma1",                            439, NULL },
  { "nu",                                521, NULL },
  { "Gamma",                             603, NULL },
  { "angleright",                        329, NULL },
  { "ellipsis",                         1000, NULL },
  { "Rho",                               556, NULL },
  { "parenrightbt",                      384, NULL },
  { "radicalex",                         500, NULL },
  { "eight",                             500, NULL },
  { "angleleft",                         329, NULL },
  { "arrowdbldown",                      603, NULL },
  { "congruent",                         549, NULL },
  { "Theta",                             741, NULL },
  { "intersection",                      768, NULL },
  { "Pi",                                768, NULL },
  { "slash",                             278, NULL },
  { "registerserif",                     790, NULL },
  { "parenleft",                         333, NULL },
  { "one",                               500, NULL },
  { "gamma",                             411, NULL },
  { "bracketleft",                       333, NULL },
  { "rho",                               549, NULL },
  { "circlemultiply",                    768, NULL },
  { "Chi",                               722, NULL },
  { "theta",                             521, NULL },
  { "pi",                                549, NULL },
  { "integraltp",                        686, NULL },
  { "Eta",                               722, NULL },
  { "product",                           823, NULL },
  { "nine",                              500, NULL },
  { "five",                              500, NULL },
  { "propersubset",                      713, NULL },
  { "bracketrightbt",                    384, NULL },
  { "trademarksans",                     786, NULL },
  { "dotmath",                           250, NULL },
  { "integralex",                        686, NULL },
  { "chi",                               549, NULL },
  { "parenrighttp",                      384, NULL },
  { "eta",                               603, NULL },
  { "underscore",                        500, NULL },
  { "Euro",                              750, NULL },
  { "multiply",                          549, NULL },
  { "zero",                              500, NULL },
  { "partialdiff",                       494, NULL },
  { "angle",                             768, NULL },
  { "arrowdblleft",                      987, NULL },
  { "braceleft",                         480, NULL },
  { "parenrightex",                      384, NULL },
  { "Rfraktur",                          795, NULL },
  { "Zeta",                              611, NULL },
  { "braceex",                           494, NULL },
  { "arrowdblup",                        603, NULL },
  { "arrowdown",                         603, NULL },
  { "Ifraktur",                          686, NULL },
  { "degree",                            400, NULL },
  { "Iota",                              333, NULL },
  { "perpendicular",                     658, NULL },
  { "radical",                           549, NULL },
  { "asteriskmath",                      500, NULL },
  { "percent",                           833, NULL },
  { "zeta",                              494, NULL },
  { "six",                               500, NULL },
  { "two",                               500, NULL },
  { "weierstrass",                       987, NULL },
  { "summation",                         713, NULL },
  { "bracketrighttp",                    384, NULL },
  { "carriagereturn",                    658, NULL },
  { "suchthat",                          439, NULL },
  { "arrowvertex",                       603, NULL },
  { "Delta",                             612, NULL },
  { "iota",                              329, NULL },
  { "arrowhorizex",                     1000, NULL },
  { "bracketrightex",                    384, NULL },
  { "bracketright",                      333, NULL },
  { "ampersand",                         778, NULL },
  { "plus",                              549, NULL },
  { "proportional",                      713, NULL },
  { "delta",                             494, NULL },
  { "copyrightserif",                    790, NULL },
  { "bracerightmid",                     494, NULL },
  { "arrowleft",                         987, NULL },
  { "second",                            411, NULL },
  { "arrowdblboth",                     1042, NULL },
  { "florin",                            500, NULL },
  { "Psi",                               795, NULL },
  { "bracerightbt",                      494, NULL },
  { "bracketleftbt",                     384, NULL },
  { "seven",                             500, NULL },
  { "braceleftmid",                      494, NULL },
  { "notequal",                          549, NULL },
  { "psi",                               686, NULL },
  { "equivalence",                       549, NULL },
  { "universal",                         713, NULL },
  { "arrowdblright",                     987, NULL },
  { "braceright",                        480, NULL },
  { "reflexsubset",                      713, NULL },
  { "Xi",                                645, NULL },
  { "theta1",                            631, NULL },
  { "logicalnot",                        713, NULL },
  { "Kappa",                             722, NULL },
  { "similar",                           549, NULL },
  { "bar",                               200, NULL },
  { "fraction",                          167, NULL },
  { "less",                              549, NULL },
  { "registersans",                      790, NULL },
  { "omega1",                            713, NULL },
  { "exclam",                            333, NULL },
  { "Upsilon1",                          620, NULL },
  { "bracerighttp",                      494, NULL },
  { "xi",                                493, NULL },
  { "period",                            250, NULL },
  { "Alpha",                             722, NULL },
  { "arrowright",                        987, NULL },
  { "greater",                           549, NULL },
  { "bracketlefttp",                     384, NULL },
  { "kappa",                             549, NULL },
  { "gradient",                          713, NULL },
  { "integral",                          274, NULL },
  { "arrowboth",                        1042, NULL },
  { "Beta",                              667, NULL }
};

static BuiltinFontWidth timesBoldWidthsTab[] = {
  { "Ntilde",                            722, NULL },
  { "rcaron",                            444, NULL },
  { "kcommaaccent",                      556, NULL },
  { "Ncommaaccent",                      722, NULL },
  { "Zacute",                            667, NULL },
  { "comma",                             250, NULL },
  { "cedilla",                           333, NULL },
  { "plusminus",                         570, NULL },
  { "circumflex",                        333, NULL },
  { "dotaccent",                         333, NULL },
  { "edotaccent",                        444, NULL },
  { "asciitilde",                        520, NULL },
  { "colon",                             333, NULL },
  { "onehalf",                           750, NULL },
  { "dollar",                            500, NULL },
  { "Lcaron",                            667, NULL },
  { "ntilde",                            556, NULL },
  { "Aogonek",                           722, NULL },
  { "ncommaaccent",                      556, NULL },
  { "minus",                             570, NULL },
  { "Iogonek",                           389, NULL },
  { "zacute",                            444, NULL },
  { "yen",                               500, NULL },
  { "space",                             250, NULL },
  { "Omacron",                           778, NULL },
  { "questiondown",                      500, NULL },
  { "emdash",                           1000, NULL },
  { "Agrave",                            722, NULL },
  { "three",                             500, NULL },
  { "numbersign",                        500, NULL },
  { "lcaron",                            394, NULL },
  { "A",                                 722, NULL },
  { "B",                                 667, NULL },
  { "C",                                 722, NULL },
  { "aogonek",                           500, NULL },
  { "D",                                 722, NULL },
  { "E",                                 667, NULL },
  { "onequarter",                        750, NULL },
  { "F",                                 611, NULL },
  { "G",                                 778, NULL },
  { "H",                                 778, NULL },
  { "I",                                 389, NULL },
  { "J",                                 500, NULL },
  { "K",                                 778, NULL },
  { "iogonek",                           278, NULL },
  { "backslash",                         278, NULL },
  { "L",                                 667, NULL },
  { "periodcentered",                    250, NULL },
  { "M",                                 944, NULL },
  { "N",                                 722, NULL },
  { "omacron",                           500, NULL },
  { "Tcommaaccent",                      667, NULL },
  { "O",                                 778, NULL },
  { "P",                                 611, NULL },
  { "Q",                                 778, NULL },
  { "Uhungarumlaut",                     722, NULL },
  { "R",                                 722, NULL },
  { "Aacute",                            722, NULL },
  { "caron",                             333, NULL },
  { "S",                                 556, NULL },
  { "T",                                 667, NULL },
  { "U",                                 722, NULL },
  { "agrave",                            500, NULL },
  { "V",                                 722, NULL },
  { "W",                                1000, NULL },
  { "X",                                 722, NULL },
  { "question",                          500, NULL },
  { "equal",                             570, NULL },
  { "Y",                                 722, NULL },
  { "Z",                                 667, NULL },
  { "four",                              500, NULL },
  { "a",                                 500, NULL },
  { "Gcommaaccent",                      778, NULL },
  { "b",                                 556, NULL },
  { "c",                                 444, NULL },
  { "d",                                 556, NULL },
  { "e",                                 444, NULL },
  { "f",                                 333, NULL },
  { "g",                                 500, NULL },
  { "bullet",                            350, NULL },
  { "h",                                 556, NULL },
  { "i",                                 278, NULL },
  { "Oslash",                            778, NULL },
  { "dagger",                            500, NULL },
  { "j",                                 333, NULL },
  { "k",                                 556, NULL },
  { "l",                                 278, NULL },
  { "m",                                 833, NULL },
  { "n",                                 556, NULL },
  { "tcommaaccent",                      333, NULL },
  { "o",                                 500, NULL },
  { "ordfeminine",                       300, NULL },
  { "ring",                              333, NULL },
  { "p",                                 556, NULL },
  { "q",                                 556, NULL },
  { "uhungarumlaut",                     556, NULL },
  { "r",                                 444, NULL },
  { "twosuperior",                       300, NULL },
  { "aacute",                            500, NULL },
  { "s",                                 389, NULL },
  { "OE",                               1000, NULL },
  { "t",                                 333, NULL },
  { "divide",                            570, NULL },
  { "u",                                 556, NULL },
  { "Ccaron",                            722, NULL },
  { "v",                                 500, NULL },
  { "w",                                 722, NULL },
  { "x",                                 500, NULL },
  { "y",                                 500, NULL },
  { "z",                                 444, NULL },
  { "Gbreve",                            778, NULL },
  { "commaaccent",                       250, NULL },
  { "hungarumlaut",                      333, NULL },
  { "Idotaccent",                        389, NULL },
  { "Nacute",                            722, NULL },
  { "quotedbl",                          555, NULL },
  { "gcommaaccent",                      500, NULL },
  { "mu",                                556, NULL },
  { "greaterequal",                      549, NULL },
  { "Scaron",                            556, NULL },
  { "Lslash",                            667, NULL },
  { "semicolon",                         333, NULL },
  { "oslash",                            500, NULL },
  { "lessequal",                         549, NULL },
  { "lozenge",                           494, NULL },
  { "parenright",                        333, NULL },
  { "ccaron",                            444, NULL },
  { "Ecircumflex",                       667, NULL },
  { "gbreve",                            500, NULL },
  { "trademark",                        1000, NULL },
  { "daggerdbl",                         500, NULL },
  { "nacute",                            556, NULL },
  { "macron",                            333, NULL },
  { "Otilde",                            778, NULL },
  { "Emacron",                           667, NULL },
  { "ellipsis",                         1000, NULL },
  { "scaron",                            389, NULL },
  { "AE",                               1000, NULL },
  { "Ucircumflex",                       722, NULL },
  { "lslash",                            278, NULL },
  { "quotedblleft",                      500, NULL },
  { "guilsinglright",                    333, NULL },
  { "hyphen",                            333, NULL },
  { "quotesingle",                       278, NULL },
  { "eight",                             500, NULL },
  { "exclamdown",                        333, NULL },
  { "endash",                            500, NULL },
  { "oe",                                722, NULL },
  { "Abreve",                            722, NULL },
  { "Umacron",                           722, NULL },
  { "ecircumflex",                       444, NULL },
  { "Adieresis",                         722, NULL },
  { "copyright",                         747, NULL },
  { "Egrave",                            667, NULL },
  { "slash",                             278, NULL },
  { "Edieresis",                         667, NULL },
  { "otilde",                            500, NULL },
  { "Idieresis",                         389, NULL },
  { "parenleft",                         333, NULL },
  { "one",                               500, NULL },
  { "emacron",                           444, NULL },
  { "Odieresis",                         778, NULL },
  { "ucircumflex",                       556, NULL },
  { "bracketleft",                       333, NULL },
  { "Ugrave",                            722, NULL },
  { "quoteright",                        333, NULL },
  { "Udieresis",                         722, NULL },
  { "perthousand",                      1000, NULL },
  { "Ydieresis",                         722, NULL },
  { "umacron",                           556, NULL },
  { "abreve",                            500, NULL },
  { "Eacute",                            667, NULL },
  { "adieresis",                         500, NULL },
  { "egrave",                            444, NULL },
  { "edieresis",                         444, NULL },
  { "idieresis",                         278, NULL },
  { "Eth",                               722, NULL },
  { "ae",                                722, NULL },
  { "asterisk",                          500, NULL },
  { "odieresis",                         500, NULL },
  { "Uacute",                            722, NULL },
  { "ugrave",                            556, NULL },
  { "nine",                              500, NULL },
  { "five",                              500, NULL },
  { "udieresis",                         556, NULL },
  { "Zcaron",                            667, NULL },
  { "Scommaaccent",                      556, NULL },
  { "threequarters",                     750, NULL },
  { "guillemotright",                    500, NULL },
  { "Ccedilla",                          722, NULL },
  { "ydieresis",                         500, NULL },
  { "tilde",                             333, NULL },
  { "at",                                930, NULL },
  { "eacute",                            444, NULL },
  { "underscore",                        500, NULL },
  { "Euro",                              500, NULL },
  { "Dcroat",                            722, NULL },
  { "multiply",                          570, NULL },
  { "zero",                              500, NULL },
  { "eth",                               500, NULL },
  { "Scedilla",                          556, NULL },
  { "Ograve",                            778, NULL },
  { "Racute",                            722, NULL },
  { "partialdiff",                       494, NULL },
  { "uacute",                            556, NULL },
  { "braceleft",                         394, NULL },
  { "Thorn",                             611, NULL },
  { "zcaron",                            444, NULL },
  { "scommaaccent",                      389, NULL },
  { "ccedilla",                          444, NULL },
  { "Dcaron",                            722, NULL },
  { "dcroat",                            556, NULL },
  { "Ocircumflex",                       778, NULL },
  { "Oacute",                            778, NULL },
  { "scedilla",                          389, NULL },
  { "ogonek",                            333, NULL },
  { "ograve",                            500, NULL },
  { "racute",                            444, NULL },
  { "Tcaron",                            667, NULL },
  { "Eogonek",                           667, NULL },
  { "thorn",                             556, NULL },
  { "degree",                            400, NULL },
  { "registered",                        747, NULL },
  { "radical",                           549, NULL },
  { "Aring",                             722, NULL },
  { "percent",                          1000, NULL },
  { "six",                               500, NULL },
  { "paragraph",                         540, NULL },
  { "dcaron",                            672, NULL },
  { "Uogonek",                           722, NULL },
  { "two",                               500, NULL },
  { "summation",                         600, NULL },
  { "Igrave",                            389, NULL },
  { "Lacute",                            667, NULL },
  { "ocircumflex",                       500, NULL },
  { "oacute",                            500, NULL },
  { "Uring",                             722, NULL },
  { "Lcommaaccent",                      667, NULL },
  { "tcaron",                            416, NULL },
  { "eogonek",                           444, NULL },
  { "Delta",                             612, NULL },
  { "Ohungarumlaut",                     778, NULL },
  { "asciicircum",                       581, NULL },
  { "aring",                             500, NULL },
  { "grave",                             333, NULL },
  { "uogonek",                           556, NULL },
  { "bracketright",                      333, NULL },
  { "Iacute",                            389, NULL },
  { "ampersand",                         833, NULL },
  { "igrave",                            278, NULL },
  { "lacute",                            278, NULL },
  { "Ncaron",                            722, NULL },
  { "plus",                              570, NULL },
  { "uring",                             556, NULL },
  { "quotesinglbase",                    333, NULL },
  { "lcommaaccent",                      278, NULL },
  { "Yacute",                            722, NULL },
  { "ohungarumlaut",                     500, NULL },
  { "threesuperior",                     300, NULL },
  { "acute",                             333, NULL },
  { "section",                           500, NULL },
  { "dieresis",                          333, NULL },
  { "iacute",                            278, NULL },
  { "quotedblbase",                      500, NULL },
  { "ncaron",                            556, NULL },
  { "florin",                            500, NULL },
  { "yacute",                            500, NULL },
  { "Rcommaaccent",                      722, NULL },
  { "fi",                                556, NULL },
  { "fl",                                556, NULL },
  { "Acircumflex",                       722, NULL },
  { "Cacute",                            722, NULL },
  { "Icircumflex",                       389, NULL },
  { "guillemotleft",                     500, NULL },
  { "germandbls",                        556, NULL },
  { "Amacron",                           722, NULL },
  { "seven",                             500, NULL },
  { "Sacute",                            556, NULL },
  { "ordmasculine",                      330, NULL },
  { "dotlessi",                          278, NULL },
  { "sterling",                          500, NULL },
  { "notequal",                          549, NULL },
  { "Imacron",                           389, NULL },
  { "rcommaaccent",                      444, NULL },
  { "Zdotaccent",                        667, NULL },
  { "acircumflex",                       500, NULL },
  { "cacute",                            444, NULL },
  { "Ecaron",                            667, NULL },
  { "icircumflex",                       278, NULL },
  { "braceright",                        394, NULL },
  { "quotedblright",                     500, NULL },
  { "amacron",                           500, NULL },
  { "sacute",                            389, NULL },
  { "imacron",                           278, NULL },
  { "cent",                              500, NULL },
  { "currency",                          500, NULL },
  { "logicalnot",                        570, NULL },
  { "zdotaccent",                        444, NULL },
  { "Atilde",                            722, NULL },
  { "breve",                             333, NULL },
  { "bar",                               220, NULL },
  { "fraction",                          167, NULL },
  { "less",                              570, NULL },
  { "ecaron",                            444, NULL },
  { "guilsinglleft",                     333, NULL },
  { "exclam",                            333, NULL },
  { "period",                            250, NULL },
  { "Rcaron",                            722, NULL },
  { "Kcommaaccent",                      778, NULL },
  { "greater",                           570, NULL },
  { "atilde",                            500, NULL },
  { "brokenbar",                         220, NULL },
  { "quoteleft",                         333, NULL },
  { "Edotaccent",                        667, NULL },
  { "onesuperior",                       300, NULL }
};

static BuiltinFontWidth timesBoldItalicWidthsTab[] = {
  { "Ntilde",                            722, NULL },
  { "rcaron",                            389, NULL },
  { "kcommaaccent",                      500, NULL },
  { "Ncommaaccent",                      722, NULL },
  { "Zacute",                            611, NULL },
  { "comma",                             250, NULL },
  { "cedilla",                           333, NULL },
  { "plusminus",                         570, NULL },
  { "circumflex",                        333, NULL },
  { "dotaccent",                         333, NULL },
  { "edotaccent",                        444, NULL },
  { "asciitilde",                        570, NULL },
  { "colon",                             333, NULL },
  { "onehalf",                           750, NULL },
  { "dollar",                            500, NULL },
  { "Lcaron",                            611, NULL },
  { "ntilde",                            556, NULL },
  { "Aogonek",                           667, NULL },
  { "ncommaaccent",                      556, NULL },
  { "minus",                             606, NULL },
  { "Iogonek",                           389, NULL },
  { "zacute",                            389, NULL },
  { "yen",                               500, NULL },
  { "space",                             250, NULL },
  { "Omacron",                           722, NULL },
  { "questiondown",                      500, NULL },
  { "emdash",                           1000, NULL },
  { "Agrave",                            667, NULL },
  { "three",                             500, NULL },
  { "numbersign",                        500, NULL },
  { "lcaron",                            382, NULL },
  { "A",                                 667, NULL },
  { "B",                                 667, NULL },
  { "C",                                 667, NULL },
  { "aogonek",                           500, NULL },
  { "D",                                 722, NULL },
  { "E",                                 667, NULL },
  { "onequarter",                        750, NULL },
  { "F",                                 667, NULL },
  { "G",                                 722, NULL },
  { "H",                                 778, NULL },
  { "I",                                 389, NULL },
  { "J",                                 500, NULL },
  { "K",                                 667, NULL },
  { "iogonek",                           278, NULL },
  { "backslash",                         278, NULL },
  { "L",                                 611, NULL },
  { "periodcentered",                    250, NULL },
  { "M",                                 889, NULL },
  { "N",                                 722, NULL },
  { "omacron",                           500, NULL },
  { "Tcommaaccent",                      611, NULL },
  { "O",                                 722, NULL },
  { "P",                                 611, NULL },
  { "Q",                                 722, NULL },
  { "Uhungarumlaut",                     722, NULL },
  { "R",                                 667, NULL },
  { "Aacute",                            667, NULL },
  { "caron",                             333, NULL },
  { "S",                                 556, NULL },
  { "T",                                 611, NULL },
  { "U",                                 722, NULL },
  { "agrave",                            500, NULL },
  { "V",                                 667, NULL },
  { "W",                                 889, NULL },
  { "X",                                 667, NULL },
  { "question",                          500, NULL },
  { "equal",                             570, NULL },
  { "Y",                                 611, NULL },
  { "Z",                                 611, NULL },
  { "four",                              500, NULL },
  { "a",                                 500, NULL },
  { "Gcommaaccent",                      722, NULL },
  { "b",                                 500, NULL },
  { "c",                                 444, NULL },
  { "d",                                 500, NULL },
  { "e",                                 444, NULL },
  { "f",                                 333, NULL },
  { "g",                                 500, NULL },
  { "bullet",                            350, NULL },
  { "h",                                 556, NULL },
  { "i",                                 278, NULL },
  { "Oslash",                            722, NULL },
  { "dagger",                            500, NULL },
  { "j",                                 278, NULL },
  { "k",                                 500, NULL },
  { "l",                                 278, NULL },
  { "m",                                 778, NULL },
  { "n",                                 556, NULL },
  { "tcommaaccent",                      278, NULL },
  { "o",                                 500, NULL },
  { "ordfeminine",                       266, NULL },
  { "ring",                              333, NULL },
  { "p",                                 500, NULL },
  { "q",                                 500, NULL },
  { "uhungarumlaut",                     556, NULL },
  { "r",                                 389, NULL },
  { "twosuperior",                       300, NULL },
  { "aacute",                            500, NULL },
  { "s",                                 389, NULL },
  { "OE",                                944, NULL },
  { "t",                                 278, NULL },
  { "divide",                            570, NULL },
  { "u",                                 556, NULL },
  { "Ccaron",                            667, NULL },
  { "v",                                 444, NULL },
  { "w",                                 667, NULL },
  { "x",                                 500, NULL },
  { "y",                                 444, NULL },
  { "z",                                 389, NULL },
  { "Gbreve",                            722, NULL },
  { "commaaccent",                       250, NULL },
  { "hungarumlaut",                      333, NULL },
  { "Idotaccent",                        389, NULL },
  { "Nacute",                            722, NULL },
  { "quotedbl",                          555, NULL },
  { "gcommaaccent",                      500, NULL },
  { "mu",                                576, NULL },
  { "greaterequal",                      549, NULL },
  { "Scaron",                            556, NULL },
  { "Lslash",                            611, NULL },
  { "semicolon",                         333, NULL },
  { "oslash",                            500, NULL },
  { "lessequal",                         549, NULL },
  { "lozenge",                           494, NULL },
  { "parenright",                        333, NULL },
  { "ccaron",                            444, NULL },
  { "Ecircumflex",                       667, NULL },
  { "gbreve",                            500, NULL },
  { "trademark",                        1000, NULL },
  { "daggerdbl",                         500, NULL },
  { "nacute",                            556, NULL },
  { "macron",                            333, NULL },
  { "Otilde",                            722, NULL },
  { "Emacron",                           667, NULL },
  { "ellipsis",                         1000, NULL },
  { "scaron",                            389, NULL },
  { "AE",                                944, NULL },
  { "Ucircumflex",                       722, NULL },
  { "lslash",                            278, NULL },
  { "quotedblleft",                      500, NULL },
  { "guilsinglright",                    333, NULL },
  { "hyphen",                            333, NULL },
  { "quotesingle",                       278, NULL },
  { "eight",                             500, NULL },
  { "exclamdown",                        389, NULL },
  { "endash",                            500, NULL },
  { "oe",                                722, NULL },
  { "Abreve",                            667, NULL },
  { "Umacron",                           722, NULL },
  { "ecircumflex",                       444, NULL },
  { "Adieresis",                         667, NULL },
  { "copyright",                         747, NULL },
  { "Egrave",                            667, NULL },
  { "slash",                             278, NULL },
  { "Edieresis",                         667, NULL },
  { "otilde",                            500, NULL },
  { "Idieresis",                         389, NULL },
  { "parenleft",                         333, NULL },
  { "one",                               500, NULL },
  { "emacron",                           444, NULL },
  { "Odieresis",                         722, NULL },
  { "ucircumflex",                       556, NULL },
  { "bracketleft",                       333, NULL },
  { "Ugrave",                            722, NULL },
  { "quoteright",                        333, NULL },
  { "Udieresis",                         722, NULL },
  { "perthousand",                      1000, NULL },
  { "Ydieresis",                         611, NULL },
  { "umacron",                           556, NULL },
  { "abreve",                            500, NULL },
  { "Eacute",                            667, NULL },
  { "adieresis",                         500, NULL },
  { "egrave",                            444, NULL },
  { "edieresis",                         444, NULL },
  { "idieresis",                         278, NULL },
  { "Eth",                               722, NULL },
  { "ae",                                722, NULL },
  { "asterisk",                          500, NULL },
  { "odieresis",                         500, NULL },
  { "Uacute",                            722, NULL },
  { "ugrave",                            556, NULL },
  { "nine",                              500, NULL },
  { "five",                              500, NULL },
  { "udieresis",                         556, NULL },
  { "Zcaron",                            611, NULL },
  { "Scommaaccent",                      556, NULL },
  { "threequarters",                     750, NULL },
  { "guillemotright",                    500, NULL },
  { "Ccedilla",                          667, NULL },
  { "ydieresis",                         444, NULL },
  { "tilde",                             333, NULL },
  { "at",                                832, NULL },
  { "eacute",                            444, NULL },
  { "underscore",                        500, NULL },
  { "Euro",                              500, NULL },
  { "Dcroat",                            722, NULL },
  { "multiply",                          570, NULL },
  { "zero",                              500, NULL },
  { "eth",                               500, NULL },
  { "Scedilla",                          556, NULL },
  { "Ograve",                            722, NULL },
  { "Racute",                            667, NULL },
  { "partialdiff",                       494, NULL },
  { "uacute",                            556, NULL },
  { "braceleft",                         348, NULL },
  { "Thorn",                             611, NULL },
  { "zcaron",                            389, NULL },
  { "scommaaccent",                      389, NULL },
  { "ccedilla",                          444, NULL },
  { "Dcaron",                            722, NULL },
  { "dcroat",                            500, NULL },
  { "Ocircumflex",                       722, NULL },
  { "Oacute",                            722, NULL },
  { "scedilla",                          389, NULL },
  { "ogonek",                            333, NULL },
  { "ograve",                            500, NULL },
  { "racute",                            389, NULL },
  { "Tcaron",                            611, NULL },
  { "Eogonek",                           667, NULL },
  { "thorn",                             500, NULL },
  { "degree",                            400, NULL },
  { "registered",                        747, NULL },
  { "radical",                           549, NULL },
  { "Aring",                             667, NULL },
  { "percent",                           833, NULL },
  { "six",                               500, NULL },
  { "paragraph",                         500, NULL },
  { "dcaron",                            608, NULL },
  { "Uogonek",                           722, NULL },
  { "two",                               500, NULL },
  { "summation",                         600, NULL },
  { "Igrave",                            389, NULL },
  { "Lacute",                            611, NULL },
  { "ocircumflex",                       500, NULL },
  { "oacute",                            500, NULL },
  { "Uring",                             722, NULL },
  { "Lcommaaccent",                      611, NULL },
  { "tcaron",                            366, NULL },
  { "eogonek",                           444, NULL },
  { "Delta",                             612, NULL },
  { "Ohungarumlaut",                     722, NULL },
  { "asciicircum",                       570, NULL },
  { "aring",                             500, NULL },
  { "grave",                             333, NULL },
  { "uogonek",                           556, NULL },
  { "bracketright",                      333, NULL },
  { "Iacute",                            389, NULL },
  { "ampersand",                         778, NULL },
  { "igrave",                            278, NULL },
  { "lacute",                            278, NULL },
  { "Ncaron",                            722, NULL },
  { "plus",                              570, NULL },
  { "uring",                             556, NULL },
  { "quotesinglbase",                    333, NULL },
  { "lcommaaccent",                      278, NULL },
  { "Yacute",                            611, NULL },
  { "ohungarumlaut",                     500, NULL },
  { "threesuperior",                     300, NULL },
  { "acute",                             333, NULL },
  { "section",                           500, NULL },
  { "dieresis",                          333, NULL },
  { "iacute",                            278, NULL },
  { "quotedblbase",                      500, NULL },
  { "ncaron",                            556, NULL },
  { "florin",                            500, NULL },
  { "yacute",                            444, NULL },
  { "Rcommaaccent",                      667, NULL },
  { "fi",                                556, NULL },
  { "fl",                                556, NULL },
  { "Acircumflex",                       667, NULL },
  { "Cacute",                            667, NULL },
  { "Icircumflex",                       389, NULL },
  { "guillemotleft",                     500, NULL },
  { "germandbls",                        500, NULL },
  { "Amacron",                           667, NULL },
  { "seven",                             500, NULL },
  { "Sacute",                            556, NULL },
  { "ordmasculine",                      300, NULL },
  { "dotlessi",                          278, NULL },
  { "sterling",                          500, NULL },
  { "notequal",                          549, NULL },
  { "Imacron",                           389, NULL },
  { "rcommaaccent",                      389, NULL },
  { "Zdotaccent",                        611, NULL },
  { "acircumflex",                       500, NULL },
  { "cacute",                            444, NULL },
  { "Ecaron",                            667, NULL },
  { "icircumflex",                       278, NULL },
  { "braceright",                        348, NULL },
  { "quotedblright",                     500, NULL },
  { "amacron",                           500, NULL },
  { "sacute",                            389, NULL },
  { "imacron",                           278, NULL },
  { "cent",                              500, NULL },
  { "currency",                          500, NULL },
  { "logicalnot",                        606, NULL },
  { "zdotaccent",                        389, NULL },
  { "Atilde",                            667, NULL },
  { "breve",                             333, NULL },
  { "bar",                               220, NULL },
  { "fraction",                          167, NULL },
  { "less",                              570, NULL },
  { "ecaron",                            444, NULL },
  { "guilsinglleft",                     333, NULL },
  { "exclam",                            389, NULL },
  { "period",                            250, NULL },
  { "Rcaron",                            667, NULL },
  { "Kcommaaccent",                      667, NULL },
  { "greater",                           570, NULL },
  { "atilde",                            500, NULL },
  { "brokenbar",                         220, NULL },
  { "quoteleft",                         333, NULL },
  { "Edotaccent",                        667, NULL },
  { "onesuperior",                       300, NULL }
};

static BuiltinFontWidth timesItalicWidthsTab[] = {
  { "Ntilde",                            667, NULL },
  { "rcaron",                            389, NULL },
  { "kcommaaccent",                      444, NULL },
  { "Ncommaaccent",                      667, NULL },
  { "Zacute",                            556, NULL },
  { "comma",                             250, NULL },
  { "cedilla",                           333, NULL },
  { "plusminus",                         675, NULL },
  { "circumflex",                        333, NULL },
  { "dotaccent",                         333, NULL },
  { "edotaccent",                        444, NULL },
  { "asciitilde",                        541, NULL },
  { "colon",                             333, NULL },
  { "onehalf",                           750, NULL },
  { "dollar",                            500, NULL },
  { "Lcaron",                            611, NULL },
  { "ntilde",                            500, NULL },
  { "Aogonek",                           611, NULL },
  { "ncommaaccent",                      500, NULL },
  { "minus",                             675, NULL },
  { "Iogonek",                           333, NULL },
  { "zacute",                            389, NULL },
  { "yen",                               500, NULL },
  { "space",                             250, NULL },
  { "Omacron",                           722, NULL },
  { "questiondown",                      500, NULL },
  { "emdash",                            889, NULL },
  { "Agrave",                            611, NULL },
  { "three",                             500, NULL },
  { "numbersign",                        500, NULL },
  { "lcaron",                            300, NULL },
  { "A",                                 611, NULL },
  { "B",                                 611, NULL },
  { "C",                                 667, NULL },
  { "aogonek",                           500, NULL },
  { "D",                                 722, NULL },
  { "E",                                 611, NULL },
  { "onequarter",                        750, NULL },
  { "F",                                 611, NULL },
  { "G",                                 722, NULL },
  { "H",                                 722, NULL },
  { "I",                                 333, NULL },
  { "J",                                 444, NULL },
  { "K",                                 667, NULL },
  { "iogonek",                           278, NULL },
  { "backslash",                         278, NULL },
  { "L",                                 556, NULL },
  { "periodcentered",                    250, NULL },
  { "M",                                 833, NULL },
  { "N",                                 667, NULL },
  { "omacron",                           500, NULL },
  { "Tcommaaccent",                      556, NULL },
  { "O",                                 722, NULL },
  { "P",                                 611, NULL },
  { "Q",                                 722, NULL },
  { "Uhungarumlaut",                     722, NULL },
  { "R",                                 611, NULL },
  { "Aacute",                            611, NULL },
  { "caron",                             333, NULL },
  { "S",                                 500, NULL },
  { "T",                                 556, NULL },
  { "U",                                 722, NULL },
  { "agrave",                            500, NULL },
  { "V",                                 611, NULL },
  { "W",                                 833, NULL },
  { "X",                                 611, NULL },
  { "question",                          500, NULL },
  { "equal",                             675, NULL },
  { "Y",                                 556, NULL },
  { "Z",                                 556, NULL },
  { "four",                              500, NULL },
  { "a",                                 500, NULL },
  { "Gcommaaccent",                      722, NULL },
  { "b",                                 500, NULL },
  { "c",                                 444, NULL },
  { "d",                                 500, NULL },
  { "e",                                 444, NULL },
  { "f",                                 278, NULL },
  { "g",                                 500, NULL },
  { "bullet",                            350, NULL },
  { "h",                                 500, NULL },
  { "i",                                 278, NULL },
  { "Oslash",                            722, NULL },
  { "dagger",                            500, NULL },
  { "j",                                 278, NULL },
  { "k",                                 444, NULL },
  { "l",                                 278, NULL },
  { "m",                                 722, NULL },
  { "n",                                 500, NULL },
  { "tcommaaccent",                      278, NULL },
  { "o",                                 500, NULL },
  { "ordfeminine",                       276, NULL },
  { "ring",                              333, NULL },
  { "p",                                 500, NULL },
  { "q",                                 500, NULL },
  { "uhungarumlaut",                     500, NULL },
  { "r",                                 389, NULL },
  { "twosuperior",                       300, NULL },
  { "aacute",                            500, NULL },
  { "s",                                 389, NULL },
  { "OE",                                944, NULL },
  { "t",                                 278, NULL },
  { "divide",                            675, NULL },
  { "u",                                 500, NULL },
  { "Ccaron",                            667, NULL },
  { "v",                                 444, NULL },
  { "w",                                 667, NULL },
  { "x",                                 444, NULL },
  { "y",                                 444, NULL },
  { "z",                                 389, NULL },
  { "Gbreve",                            722, NULL },
  { "commaaccent",                       250, NULL },
  { "hungarumlaut",                      333, NULL },
  { "Idotaccent",                        333, NULL },
  { "Nacute",                            667, NULL },
  { "quotedbl",                          420, NULL },
  { "gcommaaccent",                      500, NULL },
  { "mu",                                500, NULL },
  { "greaterequal",                      549, NULL },
  { "Scaron",                            500, NULL },
  { "Lslash",                            556, NULL },
  { "semicolon",                         333, NULL },
  { "oslash",                            500, NULL },
  { "lessequal",                         549, NULL },
  { "lozenge",                           471, NULL },
  { "parenright",                        333, NULL },
  { "ccaron",                            444, NULL },
  { "Ecircumflex",                       611, NULL },
  { "gbreve",                            500, NULL },
  { "trademark",                         980, NULL },
  { "daggerdbl",                         500, NULL },
  { "nacute",                            500, NULL },
  { "macron",                            333, NULL },
  { "Otilde",                            722, NULL },
  { "Emacron",                           611, NULL },
  { "ellipsis",                          889, NULL },
  { "scaron",                            389, NULL },
  { "AE",                                889, NULL },
  { "Ucircumflex",                       722, NULL },
  { "lslash",                            278, NULL },
  { "quotedblleft",                      556, NULL },
  { "guilsinglright",                    333, NULL },
  { "hyphen",                            333, NULL },
  { "quotesingle",                       214, NULL },
  { "eight",                             500, NULL },
  { "exclamdown",                        389, NULL },
  { "endash",                            500, NULL },
  { "oe",                                667, NULL },
  { "Abreve",                            611, NULL },
  { "Umacron",                           722, NULL },
  { "ecircumflex",                       444, NULL },
  { "Adieresis",                         611, NULL },
  { "copyright",                         760, NULL },
  { "Egrave",                            611, NULL },
  { "slash",                             278, NULL },
  { "Edieresis",                         611, NULL },
  { "otilde",                            500, NULL },
  { "Idieresis",                         333, NULL },
  { "parenleft",                         333, NULL },
  { "one",                               500, NULL },
  { "emacron",                           444, NULL },
  { "Odieresis",                         722, NULL },
  { "ucircumflex",                       500, NULL },
  { "bracketleft",                       389, NULL },
  { "Ugrave",                            722, NULL },
  { "quoteright",                        333, NULL },
  { "Udieresis",                         722, NULL },
  { "perthousand",                      1000, NULL },
  { "Ydieresis",                         556, NULL },
  { "umacron",                           500, NULL },
  { "abreve",                            500, NULL },
  { "Eacute",                            611, NULL },
  { "adieresis",                         500, NULL },
  { "egrave",                            444, NULL },
  { "edieresis",                         444, NULL },
  { "idieresis",                         278, NULL },
  { "Eth",                               722, NULL },
  { "ae",                                667, NULL },
  { "asterisk",                          500, NULL },
  { "odieresis",                         500, NULL },
  { "Uacute",                            722, NULL },
  { "ugrave",                            500, NULL },
  { "nine",                              500, NULL },
  { "five",                              500, NULL },
  { "udieresis",                         500, NULL },
  { "Zcaron",                            556, NULL },
  { "Scommaaccent",                      500, NULL },
  { "threequarters",                     750, NULL },
  { "guillemotright",                    500, NULL },
  { "Ccedilla",                          667, NULL },
  { "ydieresis",                         444, NULL },
  { "tilde",                             333, NULL },
  { "at",                                920, NULL },
  { "eacute",                            444, NULL },
  { "underscore",                        500, NULL },
  { "Euro",                              500, NULL },
  { "Dcroat",                            722, NULL },
  { "multiply",                          675, NULL },
  { "zero",                              500, NULL },
  { "eth",                               500, NULL },
  { "Scedilla",                          500, NULL },
  { "Ograve",                            722, NULL },
  { "Racute",                            611, NULL },
  { "partialdiff",                       476, NULL },
  { "uacute",                            500, NULL },
  { "braceleft",                         400, NULL },
  { "Thorn",                             611, NULL },
  { "zcaron",                            389, NULL },
  { "scommaaccent",                      389, NULL },
  { "ccedilla",                          444, NULL },
  { "Dcaron",                            722, NULL },
  { "dcroat",                            500, NULL },
  { "Ocircumflex",                       722, NULL },
  { "Oacute",                            722, NULL },
  { "scedilla",                          389, NULL },
  { "ogonek",                            333, NULL },
  { "ograve",                            500, NULL },
  { "racute",                            389, NULL },
  { "Tcaron",                            556, NULL },
  { "Eogonek",                           611, NULL },
  { "thorn",                             500, NULL },
  { "degree",                            400, NULL },
  { "registered",                        760, NULL },
  { "radical",                           453, NULL },
  { "Aring",                             611, NULL },
  { "percent",                           833, NULL },
  { "six",                               500, NULL },
  { "paragraph",                         523, NULL },
  { "dcaron",                            544, NULL },
  { "Uogonek",                           722, NULL },
  { "two",                               500, NULL },
  { "summation",                         600, NULL },
  { "Igrave",                            333, NULL },
  { "Lacute",                            556, NULL },
  { "ocircumflex",                       500, NULL },
  { "oacute",                            500, NULL },
  { "Uring",                             722, NULL },
  { "Lcommaaccent",                      556, NULL },
  { "tcaron",                            300, NULL },
  { "eogonek",                           444, NULL },
  { "Delta",                             612, NULL },
  { "Ohungarumlaut",                     722, NULL },
  { "asciicircum",                       422, NULL },
  { "aring",                             500, NULL },
  { "grave",                             333, NULL },
  { "uogonek",                           500, NULL },
  { "bracketright",                      389, NULL },
  { "Iacute",                            333, NULL },
  { "ampersand",                         778, NULL },
  { "igrave",                            278, NULL },
  { "lacute",                            278, NULL },
  { "Ncaron",                            667, NULL },
  { "plus",                              675, NULL },
  { "uring",                             500, NULL },
  { "quotesinglbase",                    333, NULL },
  { "lcommaaccent",                      278, NULL },
  { "Yacute",                            556, NULL },
  { "ohungarumlaut",                     500, NULL },
  { "threesuperior",                     300, NULL },
  { "acute",                             333, NULL },
  { "section",                           500, NULL },
  { "dieresis",                          333, NULL },
  { "iacute",                            278, NULL },
  { "quotedblbase",                      556, NULL },
  { "ncaron",                            500, NULL },
  { "florin",                            500, NULL },
  { "yacute",                            444, NULL },
  { "Rcommaaccent",                      611, NULL },
  { "fi",                                500, NULL },
  { "fl",                                500, NULL },
  { "Acircumflex",                       611, NULL },
  { "Cacute",                            667, NULL },
  { "Icircumflex",                       333, NULL },
  { "guillemotleft",                     500, NULL },
  { "germandbls",                        500, NULL },
  { "Amacron",                           611, NULL },
  { "seven",                             500, NULL },
  { "Sacute",                            500, NULL },
  { "ordmasculine",                      310, NULL },
  { "dotlessi",                          278, NULL },
  { "sterling",                          500, NULL },
  { "notequal",                          549, NULL },
  { "Imacron",                           333, NULL },
  { "rcommaaccent",                      389, NULL },
  { "Zdotaccent",                        556, NULL },
  { "acircumflex",                       500, NULL },
  { "cacute",                            444, NULL },
  { "Ecaron",                            611, NULL },
  { "icircumflex",                       278, NULL },
  { "braceright",                        400, NULL },
  { "quotedblright",                     556, NULL },
  { "amacron",                           500, NULL },
  { "sacute",                            389, NULL },
  { "imacron",                           278, NULL },
  { "cent",                              500, NULL },
  { "currency",                          500, NULL },
  { "logicalnot",                        675, NULL },
  { "zdotaccent",                        389, NULL },
  { "Atilde",                            611, NULL },
  { "breve",                             333, NULL },
  { "bar",                               275, NULL },
  { "fraction",                          167, NULL },
  { "less",                              675, NULL },
  { "ecaron",                            444, NULL },
  { "guilsinglleft",                     333, NULL },
  { "exclam",                            333, NULL },
  { "period",                            250, NULL },
  { "Rcaron",                            611, NULL },
  { "Kcommaaccent",                      667, NULL },
  { "greater",                           675, NULL },
  { "atilde",                            500, NULL },
  { "brokenbar",                         275, NULL },
  { "quoteleft",                         333, NULL },
  { "Edotaccent",                        611, NULL },
  { "onesuperior",                       300, NULL }
};

static BuiltinFontWidth timesRomanWidthsTab[] = {
  { "Ntilde",                            722, NULL },
  { "rcaron",                            333, NULL },
  { "kcommaaccent",                      500, NULL },
  { "Ncommaaccent",                      722, NULL },
  { "Zacute",                            611, NULL },
  { "comma",                             250, NULL },
  { "cedilla",                           333, NULL },
  { "plusminus",                         564, NULL },
  { "circumflex",                        333, NULL },
  { "dotaccent",                         333, NULL },
  { "edotaccent",                        444, NULL },
  { "asciitilde",                        541, NULL },
  { "colon",                             278, NULL },
  { "onehalf",                           750, NULL },
  { "dollar",                            500, NULL },
  { "Lcaron",                            611, NULL },
  { "ntilde",                            500, NULL },
  { "Aogonek",                           722, NULL },
  { "ncommaaccent",                      500, NULL },
  { "minus",                             564, NULL },
  { "Iogonek",                           333, NULL },
  { "zacute",                            444, NULL },
  { "yen",                               500, NULL },
  { "space",                             250, NULL },
  { "Omacron",                           722, NULL },
  { "questiondown",                      444, NULL },
  { "emdash",                           1000, NULL },
  { "Agrave",                            722, NULL },
  { "three",                             500, NULL },
  { "numbersign",                        500, NULL },
  { "lcaron",                            344, NULL },
  { "A",                                 722, NULL },
  { "B",                                 667, NULL },
  { "C",                                 667, NULL },
  { "aogonek",                           444, NULL },
  { "D",                                 722, NULL },
  { "E",                                 611, NULL },
  { "onequarter",                        750, NULL },
  { "F",                                 556, NULL },
  { "G",                                 722, NULL },
  { "H",                                 722, NULL },
  { "I",                                 333, NULL },
  { "J",                                 389, NULL },
  { "K",                                 722, NULL },
  { "iogonek",                           278, NULL },
  { "backslash",                         278, NULL },
  { "L",                                 611, NULL },
  { "periodcentered",                    250, NULL },
  { "M",                                 889, NULL },
  { "N",                                 722, NULL },
  { "omacron",                           500, NULL },
  { "Tcommaaccent",                      611, NULL },
  { "O",                                 722, NULL },
  { "P",                                 556, NULL },
  { "Q",                                 722, NULL },
  { "Uhungarumlaut",                     722, NULL },
  { "R",                                 667, NULL },
  { "Aacute",                            722, NULL },
  { "caron",                             333, NULL },
  { "S",                                 556, NULL },
  { "T",                                 611, NULL },
  { "U",                                 722, NULL },
  { "agrave",                            444, NULL },
  { "V",                                 722, NULL },
  { "W",                                 944, NULL },
  { "X",                                 722, NULL },
  { "question",                          444, NULL },
  { "equal",                             564, NULL },
  { "Y",                                 722, NULL },
  { "Z",                                 611, NULL },
  { "four",                              500, NULL },
  { "a",                                 444, NULL },
  { "Gcommaaccent",                      722, NULL },
  { "b",                                 500, NULL },
  { "c",                                 444, NULL },
  { "d",                                 500, NULL },
  { "e",                                 444, NULL },
  { "f",                                 333, NULL },
  { "g",                                 500, NULL },
  { "bullet",                            350, NULL },
  { "h",                                 500, NULL },
  { "i",                                 278, NULL },
  { "Oslash",                            722, NULL },
  { "dagger",                            500, NULL },
  { "j",                                 278, NULL },
  { "k",                                 500, NULL },
  { "l",                                 278, NULL },
  { "m",                                 778, NULL },
  { "n",                                 500, NULL },
  { "tcommaaccent",                      278, NULL },
  { "o",                                 500, NULL },
  { "ordfeminine",                       276, NULL },
  { "ring",                              333, NULL },
  { "p",                                 500, NULL },
  { "q",                                 500, NULL },
  { "uhungarumlaut",                     500, NULL },
  { "r",                                 333, NULL },
  { "twosuperior",                       300, NULL },
  { "aacute",                            444, NULL },
  { "s",                                 389, NULL },
  { "OE",                                889, NULL },
  { "t",                                 278, NULL },
  { "divide",                            564, NULL },
  { "u",                                 500, NULL },
  { "Ccaron",                            667, NULL },
  { "v",                                 500, NULL },
  { "w",                                 722, NULL },
  { "x",                                 500, NULL },
  { "y",                                 500, NULL },
  { "z",                                 444, NULL },
  { "Gbreve",                            722, NULL },
  { "commaaccent",                       250, NULL },
  { "hungarumlaut",                      333, NULL },
  { "Idotaccent",                        333, NULL },
  { "Nacute",                            722, NULL },
  { "quotedbl",                          408, NULL },
  { "gcommaaccent",                      500, NULL },
  { "mu",                                500, NULL },
  { "greaterequal",                      549, NULL },
  { "Scaron",                            556, NULL },
  { "Lslash",                            611, NULL },
  { "semicolon",                         278, NULL },
  { "oslash",                            500, NULL },
  { "lessequal",                         549, NULL },
  { "lozenge",                           471, NULL },
  { "parenright",                        333, NULL },
  { "ccaron",                            444, NULL },
  { "Ecircumflex",                       611, NULL },
  { "gbreve",                            500, NULL },
  { "trademark",                         980, NULL },
  { "daggerdbl",                         500, NULL },
  { "nacute",                            500, NULL },
  { "macron",                            333, NULL },
  { "Otilde",                            722, NULL },
  { "Emacron",                           611, NULL },
  { "ellipsis",                         1000, NULL },
  { "scaron",                            389, NULL },
  { "AE",                                889, NULL },
  { "Ucircumflex",                       722, NULL },
  { "lslash",                            278, NULL },
  { "quotedblleft",                      444, NULL },
  { "guilsinglright",                    333, NULL },
  { "hyphen",                            333, NULL },
  { "quotesingle",                       180, NULL },
  { "eight",                             500, NULL },
  { "exclamdown",                        333, NULL },
  { "endash",                            500, NULL },
  { "oe",                                722, NULL },
  { "Abreve",                            722, NULL },
  { "Umacron",                           722, NULL },
  { "ecircumflex",                       444, NULL },
  { "Adieresis",                         722, NULL },
  { "copyright",                         760, NULL },
  { "Egrave",                            611, NULL },
  { "slash",                             278, NULL },
  { "Edieresis",                         611, NULL },
  { "otilde",                            500, NULL },
  { "Idieresis",                         333, NULL },
  { "parenleft",                         333, NULL },
  { "one",                               500, NULL },
  { "emacron",                           444, NULL },
  { "Odieresis",                         722, NULL },
  { "ucircumflex",                       500, NULL },
  { "bracketleft",                       333, NULL },
  { "Ugrave",                            722, NULL },
  { "quoteright",                        333, NULL },
  { "Udieresis",                         722, NULL },
  { "perthousand",                      1000, NULL },
  { "Ydieresis",                         722, NULL },
  { "umacron",                           500, NULL },
  { "abreve",                            444, NULL },
  { "Eacute",                            611, NULL },
  { "adieresis",                         444, NULL },
  { "egrave",                            444, NULL },
  { "edieresis",                         444, NULL },
  { "idieresis",                         278, NULL },
  { "Eth",                               722, NULL },
  { "ae",                                667, NULL },
  { "asterisk",                          500, NULL },
  { "odieresis",                         500, NULL },
  { "Uacute",                            722, NULL },
  { "ugrave",                            500, NULL },
  { "nine",                              500, NULL },
  { "five",                              500, NULL },
  { "udieresis",                         500, NULL },
  { "Zcaron",                            611, NULL },
  { "Scommaaccent",                      556, NULL },
  { "threequarters",                     750, NULL },
  { "guillemotright",                    500, NULL },
  { "Ccedilla",                          667, NULL },
  { "ydieresis",                         500, NULL },
  { "tilde",                             333, NULL },
  { "at",                                921, NULL },
  { "eacute",                            444, NULL },
  { "underscore",                        500, NULL },
  { "Euro",                              500, NULL },
  { "Dcroat",                            722, NULL },
  { "multiply",                          564, NULL },
  { "zero",                              500, NULL },
  { "eth",                               500, NULL },
  { "Scedilla",                          556, NULL },
  { "Ograve",                            722, NULL },
  { "Racute",                            667, NULL },
  { "partialdiff",                       476, NULL },
  { "uacute",                            500, NULL },
  { "braceleft",                         480, NULL },
  { "Thorn",                             556, NULL },
  { "zcaron",                            444, NULL },
  { "scommaaccent",                      389, NULL },
  { "ccedilla",                          444, NULL },
  { "Dcaron",                            722, NULL },
  { "dcroat",                            500, NULL },
  { "Ocircumflex",                       722, NULL },
  { "Oacute",                            722, NULL },
  { "scedilla",                          389, NULL },
  { "ogonek",                            333, NULL },
  { "ograve",                            500, NULL },
  { "racute",                            333, NULL },
  { "Tcaron",                            611, NULL },
  { "Eogonek",                           611, NULL },
  { "thorn",                             500, NULL },
  { "degree",                            400, NULL },
  { "registered",                        760, NULL },
  { "radical",                           453, NULL },
  { "Aring",                             722, NULL },
  { "percent",                           833, NULL },
  { "six",                               500, NULL },
  { "paragraph",                         453, NULL },
  { "dcaron",                            588, NULL },
  { "Uogonek",                           722, NULL },
  { "two",                               500, NULL },
  { "summation",                         600, NULL },
  { "Igrave",                            333, NULL },
  { "Lacute",                            611, NULL },
  { "ocircumflex",                       500, NULL },
  { "oacute",                            500, NULL },
  { "Uring",                             722, NULL },
  { "Lcommaaccent",                      611, NULL },
  { "tcaron",                            326, NULL },
  { "eogonek",                           444, NULL },
  { "Delta",                             612, NULL },
  { "Ohungarumlaut",                     722, NULL },
  { "asciicircum",                       469, NULL },
  { "aring",                             444, NULL },
  { "grave",                             333, NULL },
  { "uogonek",                           500, NULL },
  { "bracketright",                      333, NULL },
  { "Iacute",                            333, NULL },
  { "ampersand",                         778, NULL },
  { "igrave",                            278, NULL },
  { "lacute",                            278, NULL },
  { "Ncaron",                            722, NULL },
  { "plus",                              564, NULL },
  { "uring",                             500, NULL },
  { "quotesinglbase",                    333, NULL },
  { "lcommaaccent",                      278, NULL },
  { "Yacute",                            722, NULL },
  { "ohungarumlaut",                     500, NULL },
  { "threesuperior",                     300, NULL },
  { "acute",                             333, NULL },
  { "section",                           500, NULL },
  { "dieresis",                          333, NULL },
  { "iacute",                            278, NULL },
  { "quotedblbase",                      444, NULL },
  { "ncaron",                            500, NULL },
  { "florin",                            500, NULL },
  { "yacute",                            500, NULL },
  { "Rcommaaccent",                      667, NULL },
  { "fi",                                556, NULL },
  { "fl",                                556, NULL },
  { "Acircumflex",                       722, NULL },
  { "Cacute",                            667, NULL },
  { "Icircumflex",                       333, NULL },
  { "guillemotleft",                     500, NULL },
  { "germandbls",                        500, NULL },
  { "Amacron",                           722, NULL },
  { "seven",                             500, NULL },
  { "Sacute",                            556, NULL },
  { "ordmasculine",                      310, NULL },
  { "dotlessi",                          278, NULL },
  { "sterling",                          500, NULL },
  { "notequal",                          549, NULL },
  { "Imacron",                           333, NULL },
  { "rcommaaccent",                      333, NULL },
  { "Zdotaccent",                        611, NULL },
  { "acircumflex",                       444, NULL },
  { "cacute",                            444, NULL },
  { "Ecaron",                            611, NULL },
  { "icircumflex",                       278, NULL },
  { "braceright",                        480, NULL },
  { "quotedblright",                     444, NULL },
  { "amacron",                           444, NULL },
  { "sacute",                            389, NULL },
  { "imacron",                           278, NULL },
  { "cent",                              500, NULL },
  { "currency",                          500, NULL },
  { "logicalnot",                        564, NULL },
  { "zdotaccent",                        444, NULL },
  { "Atilde",                            722, NULL },
  { "breve",                             333, NULL },
  { "bar",                               200, NULL },
  { "fraction",                          167, NULL },
  { "less",                              564, NULL },
  { "ecaron",                            444, NULL },
  { "guilsinglleft",                     333, NULL },
  { "exclam",                            333, NULL },
  { "period",                            250, NULL },
  { "Rcaron",                            667, NULL },
  { "Kcommaaccent",                      722, NULL },
  { "greater",                           564, NULL },
  { "atilde",                            444, NULL },
  { "brokenbar",                         200, NULL },
  { "quoteleft",                         333, NULL },
  { "Edotaccent",                        611, NULL },
  { "onesuperior",                       300, NULL }
};

static BuiltinFontWidth zapfDingbatsWidthsTab[] = {
  { "a81",                               438, NULL },
  { "a82",                               138, NULL },
  { "a83",                               277, NULL },
  { "a84",                               415, NULL },
  { "a85",                               509, NULL },
  { "a86",                               410, NULL },
  { "a87",                               234, NULL },
  { "a88",                               234, NULL },
  { "a89",                               390, NULL },
  { "a140",                              788, NULL },
  { "a141",                              788, NULL },
  { "a142",                              788, NULL },
  { "a143",                              788, NULL },
  { "a144",                              788, NULL },
  { "a145",                              788, NULL },
  { "a146",                              788, NULL },
  { "a147",                              788, NULL },
  { "a148",                              788, NULL },
  { "a149",                              788, NULL },
  { "a90",                               390, NULL },
  { "a91",                               276, NULL },
  { "a92",                               276, NULL },
  { "space",                             278, NULL },
  { "a93",                               317, NULL },
  { "a94",                               317, NULL },
  { "a95",                               334, NULL },
  { "a96",                               334, NULL },
  { "a97",                               392, NULL },
  { "a98",                               392, NULL },
  { "a99",                               668, NULL },
  { "a150",                              788, NULL },
  { "a151",                              788, NULL },
  { "a152",                              788, NULL },
  { "a153",                              788, NULL },
  { "a154",                              788, NULL },
  { "a155",                              788, NULL },
  { "a156",                              788, NULL },
  { "a157",                              788, NULL },
  { "a158",                              788, NULL },
  { "a159",                              788, NULL },
  { "a160",                              894, NULL },
  { "a161",                              838, NULL },
  { "a162",                              924, NULL },
  { "a163",                             1016, NULL },
  { "a164",                              458, NULL },
  { "a165",                              924, NULL },
  { "a166",                              918, NULL },
  { "a167",                              927, NULL },
  { "a168",                              928, NULL },
  { "a169",                              928, NULL },
  { "a170",                              834, NULL },
  { "a171",                              873, NULL },
  { "a172",                              828, NULL },
  { "a173",                              924, NULL },
  { "a174",                              917, NULL },
  { "a175",                              930, NULL },
  { "a176",                              931, NULL },
  { "a177",                              463, NULL },
  { "a178",                              883, NULL },
  { "a179",                              836, NULL },
  { "a180",                              867, NULL },
  { "a181",                              696, NULL },
  { "a182",                              874, NULL },
  { "a183",                              760, NULL },
  { "a184",                              946, NULL },
  { "a185",                              865, NULL },
  { "a186",                              967, NULL },
  { "a187",                              831, NULL },
  { "a188",                              873, NULL },
  { "a189",                              927, NULL },
  { "a1",                                974, NULL },
  { "a2",                                961, NULL },
  { "a3",                                980, NULL },
  { "a4",                                719, NULL },
  { "a5",                                789, NULL },
  { "a6",                                494, NULL },
  { "a7",                                552, NULL },
  { "a8",                                537, NULL },
  { "a9",                                577, NULL },
  { "a190",                              970, NULL },
  { "a191",                              918, NULL },
  { "a192",                              748, NULL },
  { "a193",                              836, NULL },
  { "a194",                              771, NULL },
  { "a195",                              888, NULL },
  { "a196",                              748, NULL },
  { "a197",                              771, NULL },
  { "a198",                              888, NULL },
  { "a199",                              867, NULL },
  { "a10",                               692, NULL },
  { "a11",                               960, NULL },
  { "a12",                               939, NULL },
  { "a13",                               549, NULL },
  { "a14",                               855, NULL },
  { "a15",                               911, NULL },
  { "a16",                               933, NULL },
  { "a17",                               945, NULL },
  { "a18",                               974, NULL },
  { "a19",                               755, NULL },
  { "a20",                               846, NULL },
  { "a21",                               762, NULL },
  { "a22",                               761, NULL },
  { "a23",                               571, NULL },
  { "a24",                               677, NULL },
  { "a25",                               763, NULL },
  { "a26",                               760, NULL },
  { "a27",                               759, NULL },
  { "a28",                               754, NULL },
  { "a29",                               786, NULL },
  { "a30",                               788, NULL },
  { "a31",                               788, NULL },
  { "a32",                               790, NULL },
  { "a33",                               793, NULL },
  { "a34",                               794, NULL },
  { "a35",                               816, NULL },
  { "a36",                               823, NULL },
  { "a37",                               789, NULL },
  { "a38",                               841, NULL },
  { "a39",                               823, NULL },
  { "a40",                               833, NULL },
  { "a41",                               816, NULL },
  { "a42",                               831, NULL },
  { "a43",                               923, NULL },
  { "a44",                               744, NULL },
  { "a45",                               723, NULL },
  { "a46",                               749, NULL },
  { "a47",                               790, NULL },
  { "a48",                               792, NULL },
  { "a49",                               695, NULL },
  { "a100",                              668, NULL },
  { "a101",                              732, NULL },
  { "a102",                              544, NULL },
  { "a103",                              544, NULL },
  { "a104",                              910, NULL },
  { "a105",                              911, NULL },
  { "a106",                              667, NULL },
  { "a107",                              760, NULL },
  { "a108",                              760, NULL },
  { "a109",                              626, NULL },
  { "a50",                               776, NULL },
  { "a51",                               768, NULL },
  { "a52",                               792, NULL },
  { "a53",                               759, NULL },
  { "a54",                               707, NULL },
  { "a55",                               708, NULL },
  { "a56",                               682, NULL },
  { "a57",                               701, NULL },
  { "a58",                               826, NULL },
  { "a59",                               815, NULL },
  { "a110",                              694, NULL },
  { "a111",                              595, NULL },
  { "a112",                              776, NULL },
  { "a117",                              690, NULL },
  { "a118",                              791, NULL },
  { "a119",                              790, NULL },
  { "a60",                               789, NULL },
  { "a61",                               789, NULL },
  { "a62",                               707, NULL },
  { "a63",                               687, NULL },
  { "a64",                               696, NULL },
  { "a65",                               689, NULL },
  { "a66",                               786, NULL },
  { "a67",                               787, NULL },
  { "a68",                               713, NULL },
  { "a69",                               791, NULL },
  { "a200",                              696, NULL },
  { "a201",                              874, NULL },
  { "a120",                              788, NULL },
  { "a121",                              788, NULL },
  { "a202",                              974, NULL },
  { "a122",                              788, NULL },
  { "a203",                              762, NULL },
  { "a123",                              788, NULL },
  { "a204",                              759, NULL },
  { "a124",                              788, NULL },
  { "a205",                              509, NULL },
  { "a125",                              788, NULL },
  { "a206",                              410, NULL },
  { "a126",                              788, NULL },
  { "a127",                              788, NULL },
  { "a128",                              788, NULL },
  { "a129",                              788, NULL },
  { "a70",                               785, NULL },
  { "a71",                               791, NULL },
  { "a72",                               873, NULL },
  { "a73",                               761, NULL },
  { "a74",                               762, NULL },
  { "a75",                               759, NULL },
  { "a76",                               892, NULL },
  { "a77",                               892, NULL },
  { "a78",                               788, NULL },
  { "a79",                               784, NULL },
  { "a130",                              788, NULL },
  { "a131",                              788, NULL },
  { "a132",                              788, NULL },
  { "a133",                              788, NULL },
  { "a134",                              788, NULL },
  { "a135",                              788, NULL },
  { "a136",                              788, NULL },
  { "a137",                              788, NULL },
  { "a138",                              788, NULL },
  { "a139",                              788, NULL }
};

BuiltinFont builtinFonts[] = {
  { "Courier",               standardEncoding,            629, -157, { -23, -250,  715,  805}, NULL },
  { "Courier-Bold",          standardEncoding,            629, -157, {-113, -250,  749,  801}, NULL },
  { "Courier-BoldOblique",   standardEncoding,            629, -157, { -57, -250,  869,  801}, NULL },
  { "Courier-Oblique",       standardEncoding,            629, -157, { -27, -250,  849,  805}, NULL },
  { "Helvetica",             standardEncoding,            718, -207, {-166, -225, 1000,  931}, NULL },
  { "Helvetica-Bold",        standardEncoding,            718, -207, {-170, -228, 1003,  962}, NULL },
  { "Helvetica-BoldOblique", standardEncoding,            718, -207, {-174, -228, 1114,  962}, NULL },
  { "Helvetica-Oblique",     standardEncoding,            718, -207, {-170, -225, 1116,  931}, NULL },
  { "Symbol",                symbolEncoding,             1010, -293, {-180, -293, 1090, 1010}, NULL },
  { "Times-Bold",            standardEncoding,            683, -217, {-168, -218, 1000,  935}, NULL },
  { "Times-BoldItalic",      standardEncoding,            683, -217, {-200, -218,  996,  921}, NULL },
  { "Times-Italic",          standardEncoding,            683, -217, {-169, -217, 1010,  883}, NULL },
  { "Times-Roman",           standardEncoding,            683, -217, {-168, -218, 1000,  898}, NULL },
  { "ZapfDingbats",          zapfDingbatsEncoding,        820, -143, {  -1, -143,  981,  820}, NULL }
};

BuiltinFont *builtinFontSubst[] = {
  &builtinFonts[0],
  &builtinFonts[3],
  &builtinFonts[1],
  &builtinFonts[2],
  &builtinFonts[4],
  &builtinFonts[7],
  &builtinFonts[5],
  &builtinFonts[6],
  &builtinFonts[12],
  &builtinFonts[11],
  &builtinFonts[9],
  &builtinFonts[10]
};

void initBuiltinFontTables() {
  builtinFonts[0].widths = new BuiltinFontWidths(courierWidthsTab, 315);
  builtinFonts[1].widths = new BuiltinFontWidths(courierBoldWidthsTab, 315);
  builtinFonts[2].widths = new BuiltinFontWidths(courierBoldObliqueWidthsTab, 315);
  builtinFonts[3].widths = new BuiltinFontWidths(courierObliqueWidthsTab, 315);
  builtinFonts[4].widths = new BuiltinFontWidths(helveticaWidthsTab, 315);
  builtinFonts[5].widths = new BuiltinFontWidths(helveticaBoldWidthsTab, 316);
  builtinFonts[6].widths = new BuiltinFontWidths(helveticaBoldObliqueWidthsTab, 315);
  builtinFonts[7].widths = new BuiltinFontWidths(helveticaObliqueWidthsTab, 315);
  builtinFonts[8].widths = new BuiltinFontWidths(symbolWidthsTab, 190);
  builtinFonts[9].widths = new BuiltinFontWidths(timesBoldWidthsTab, 315);
  builtinFonts[10].widths = new BuiltinFontWidths(timesBoldItalicWidthsTab, 315);
  builtinFonts[11].widths = new BuiltinFontWidths(timesItalicWidthsTab, 315);
  builtinFonts[12].widths = new BuiltinFontWidths(timesRomanWidthsTab, 315);
  builtinFonts[13].widths = new BuiltinFontWidths(zapfDingbatsWidthsTab, 202);
}

void freeBuiltinFontTables() {
  int i;

  for (i = 0; i < 14; ++i) {
    delete builtinFonts[i].widths;
  }
}
