#!/bin/bash

# Generate a pcmanfm configuration file reading values from gconf

echo "# ~/.pcmanfm/main configuration file generated by $0"
echo

echo '[General]'
echo 'terminal=gnome-terminal'
echo

echo '[Desktop]'
echo 'showDesktop=1'

# Detect wallpaper setting
WALLPAPER=`gconftool-2 --get /desktop/gnome/background/picture_filename`
if ! [ -z "$WALLPAPER" ]
then
    echo 'showWallpaper=1'
    echo "wallpaper=$WALLPAPER"
fi

# Detect color setting (doesn't really work: I could not find significant keys)
#COLOR=`gconftool-2 --get /desktop/gnome/background/primary_color`
#if ! [ -z "$COLOR" ]
#then
#   R=$(( $(printf %d 0x${COLOR:1:2}) * 65536 / 256 ))
#   G=$(( $(printf %d 0x${COLOR:3:2}) * 65536 / 256 ))
#   B=$(( $(printf %d 0x${COLOR:5:2}) * 65536 / 256 ))
#   echo "Bg1=$R,$G,$B"
#fi
