/* This file is part of Patchage.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef JACKDRIVER_H
#define JACKDRIVER_H

#include <iostream>
#include <jack/jack.h>
#include <pthread.h>
#include <queue>
#include <string>
class Patchage;
class PatchagePatchBayArea;

using std::queue; using std::string;


/** Handles all externally driven functionality, registering ports etc.
 *
 * Jack callbacks and connect methods and things like that live here.
 * Right now just for jack ports, but that will change...
 */
class JackDriver
{
public:
	JackDriver(Patchage* app, pthread_mutex_t* refresh_mutex);
	~JackDriver();
	
	void attach();
	void detach();

	void refresh();

	bool connect(const string& src_module_name, const string& src_port_name,
                 const string& dst_module_name,  const string& dest_port_name);
	
	bool disconnect(const string& src_module_name, const string& src_port_name,
                    const string& dst_module_name,  const string& dest_port_name); 
	
	PatchagePatchBayArea* patch_bay() { return m_patch_bay; }

private:
	Patchage*             m_app;
	PatchagePatchBayArea* m_patch_bay;

	jack_client_t* m_client;

	pthread_mutex_t* m_refresh_mutex;

	static void jack_port_registration_cb(jack_port_id_t port_id, int registered, void* controller);
	static int  jack_graph_order_cb(void* controller);
};


#endif // JACKDRIVER_H
