#include <Foundation/NSObject.h>
#include <Foundation/NSData.h>

#include "TestCase.h"

#import <Pantomime/MimeBodyPart.h>
#import <Pantomime/MimeMultipart.h>
#import <Pantomime/Constants.h>


@interface test_MimeBodypart : TestCase
@end

/* TODO */
@implementation test_MimeBodypart

-(void) test_basic_sending_data
{
static const char *str1=
"Content-Transfer-Encoding: 7bit\n"
"Content-ID: id__1\n"
"Content-Description: =?iso-8859-1?q?desc_=E5=E4=F6_foo=5Fbar=3F?=\n"
//"Content-Type: text/plain; charset=\"us-ascii\"; format=\"flowed\"\n" /* why flowed? */
"Content-Type: text/plain; charset=\"us-ascii\"\n"
"Content-Disposition: inline\n"
"\n"
"Test message.\n"
"Foo: bar zot.\n"
"> quoted bla bla\n"
"> bla\n"
"\n";


static const char *str2=
"Content-Transfer-Encoding: 8bit\n"
"Content-Type: text/plain; charset=\"iso-8859-1\"\n"
"\n"
"Test message with other charsets .\n";

static const char *str3=
"Content-Transfer-Encoding: quoted-printable\n"
"Content-Type: text/plain; charset=\"iso-8859-1\"\n"
"\n"
"Test message with other charsets =E5=E4=F6.\n";

static const char *str4=
"Content-Transfer-Encoding: base64\n"
"Content-Type: text/plain; charset=\"iso-8859-1\"\n"
"\n"
"VGVzdCBtZXNzYWdlIHdpdGggb3RoZXIgY2hhcnNldHMg5eT2Lgo=\n";

	MimeBodyPart *b;
	NSData *got,*expected;

	b=[[MimeBodyPart alloc] init];
	[b setContentType: @"text/plain"];
	[b setContentID: @"id__1"];
	[b setContentDescription: @"desc  foo_bar?"];
	[b setContentDisposition: @"inline"];
	[b setContentTransferEncoding: NONE];
	[b setContent: @"Test message.\nFoo: bar zot.\n> quoted bla bla\n> bla\n\n"];
	[b setCharset: @"us-ascii"];

	got=[b dataUsingSendingMode: SEND_TO_FOLDER];

	expected=[NSData dataWithBytes: str1 length: strlen(str1)];
	[self equalData: expected : got];

	DESTROY(b);


	b=[[MimeBodyPart alloc] init];
	[b setContentType: @"text/plain"];
	[b setContent: @"Test message with other charsets .\n"];
	[b setCharset: @"iso-8859-1"];

	[b setContentTransferEncoding: EIGHTBIT];
	got=[b dataUsingSendingMode: SEND_TO_FOLDER];
	expected=[NSData dataWithBytes: str2 length: strlen(str2)];
	[self equalData: expected : got];

	[b setContentTransferEncoding: QUOTEDPRINTABLE];
	got=[b dataUsingSendingMode: SEND_TO_FOLDER];
	expected=[NSData dataWithBytes: str3 length: strlen(str3)];
	[self equalData: expected : got];

	[b setContentTransferEncoding: BASE64];
	got=[b dataUsingSendingMode: SEND_TO_FOLDER];
	expected=[NSData dataWithBytes: str4 length: strlen(str4)];
	[self equalData: expected : got];

	DESTROY(b);
}

@end

