/*
**  LocalMessage.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#import <Pantomime/LocalMessage.h>

#import <Pantomime/Constants.h>
#import <Pantomime/LocalFolder.h>
#import <Pantomime/NSDataExtensions.h>

#import <string.h>

@implementation LocalMessage 

//
// NSCoding protocol
//
- (void) encodeWithCoder: (NSCoder *) theCoder
{
  //NSLog(@"Encoding LocalMessage...");
  [super encodeWithCoder: theCoder];
  
  [theCoder encodeObject: [NSNumber numberWithLong: [self filePosition]]];
  [theCoder encodeObject: [NSNumber numberWithLong: [self bodyFilePosition]]];
}

- (id) initWithCoder: (NSCoder *) theCoder
{ 
  self = [super initWithCoder: theCoder];
  
  //NSLog(@"Decoding LocalMessage...");

  [self setFilePosition: [[theCoder decodeObject] longValue]];
  [self setBodyFilePosition: [[theCoder decodeObject] longValue]];
  
  return self;
}

//
// access / mutation methods
//
- (long) filePosition
{
  return filePosition;
}

- (void) setFilePosition: (long) theFilePosition
{
  filePosition = theFilePosition;
}

- (long) bodyFilePosition
{
  return bodyFilePosition;
}

- (void) setBodyFilePosition: (long) theBodyFilePosition
{
  bodyFilePosition = theBodyFilePosition;
}

- (NSData *) rawSource
{
  NSMutableData *aMutableData;
  LocalFolder *aLocalFolder;
  char aLine[1024];

  FILE *aStream;
  long mark;

  aLocalFolder = (LocalFolder *)[self folder];
  aStream = [aLocalFolder stream];

  mark = ftell(aStream);

  if (fseek(aStream, [self filePosition], SEEK_SET) < 0)
    {
      NSLog( @"Seek operation failed!" );
      return nil;
    }

  // We initialize our mutable data and our buffer
  aMutableData = [[NSMutableData alloc] init];
  bzero(aLine, 1024);

  while( fgets(aLine, 1024, aStream) != NULL && 
	 ftell(aStream) < ([self filePosition] + [self size]) )
    {
      [aMutableData appendBytes: aLine  length: strlen(aLine) ];
      bzero(aLine, 1024);
    }

  fseek(aStream, mark, SEEK_SET);

  return AUTORELEASE(aMutableData);
}

//
// This method is called to initialize the message if it wasn't.
// If we set it to NO and we HAD a content, we release the content;
//
- (void) setInitialized: (BOOL) aBOOL
{
  [super setInitialized: aBOOL];

  if ( aBOOL )
    {
      NSMutableData *aMutableData;
      LocalFolder *aLocalFolder;
      FILE *aStream;
      char aLine[1024];
      
      int lengthOfBody;
      long mark;
      
      
      aLocalFolder = (LocalFolder *)[self folder];
      aStream = [aLocalFolder stream];
      
      mark = ftell(aStream);
      
      if (fseek(aStream, [self bodyFilePosition], SEEK_SET) < 0)
	{
	  NSLog( @"Seek operation failed!" );
	  [super setInitialized: NO];
	  return;
	}
     
      // We calculate the length of our body to make parsing faster
      lengthOfBody = ([self filePosition] + [self size] - [self bodyFilePosition]);
      aMutableData = [[NSMutableData alloc] initWithCapacity: lengthOfBody];
      
      bzero(aLine, 1024);
      while( fgets(aLine, 1024, aStream) != NULL && 
	     ftell(aStream) < ([self filePosition] + [self size]) )
	{
	  [aMutableData appendBytes: aLine  length: strlen(aLine) ];
	  bzero(aLine, 1024);
	}
      
      
      fseek(aStream, mark, SEEK_SET);
      
      [self setContentFromRawSource: aMutableData];
      RELEASE(aMutableData);
    }
  else
    {
      TEST_RELEASE(content);
      content = nil;
    }
}

@end
