/*
**  TCPConnection.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#import <Foundation/Foundation.h>

@interface TCPConnection : NSObject
{
  // ivars
  NSString *name;
  int port;
  int connectionTimeout;
  int readTimeout;
  int writeTimeout;
  int fd;
}

- (void) dealloc;

- (id) initWithName: (NSString *) theName
               port: (int) thePort;

- (id) initWithName: (NSString *) theName
	       port: (int) thePort
  connectionTimeout: (int) theConnectionTimeout
	readTimeout: (int) theReadTimeout
       writeTimeout: (int) theWriteTimeout;


//
// access / mutation methods
//

- (NSString *) name;
- (void) setName: (NSString *) theName;

- (int) port;
- (void) setPort: (int) thePort;

- (int) connectionTimeout;
- (void) setConnectionTimeout: (int) theConnectionTimeout;

- (int) readTimeout;
- (void) setReadTimeout: (int) theReadTimeout;

- (int) writeTimeout;
- (void) setWriteTimeout: (int) theWriteTimeout;

- (int) fd;

//
// other methods
//

- (void) close;

- (NSString *) readLine;
- (NSString *) readLineBySkippingCR: (BOOL) aBOOL;


- (NSData *) readDataOfLength: (int) theLength;
- (NSString *) readStringOfLength: (int) theLength;

- (BOOL) writeLine: (NSString *) theLine;

- (BOOL) writeData: (NSData *) theData;
- (BOOL) writeString: (NSString *) theString;

@end


//
// private methods
// 
@interface TCPConnection (Private)

- (char) _readByte;
- (void) _writeByte: (char) byte;

@end
