/*
/--------------------------------------------------------------------
|
|      $Id: pltestfilters.h,v 1.3 2003/07/27 18:08:38 uzadow Exp $
|
|      Copyright (c) 1996-2002 Ulrich von Zadow
|
\--------------------------------------------------------------------
*/

#ifndef INCL_PLTESTFILTERS
#define INCL_PLTESTFILTERS

#include "pltest.h"

class PLFilter;
class PLBmp;

class PLTestFilters: public PLTest
{
public:
  PLTestFilters(PLBmp* pBmp32, PLBmp* pBmp8);
  virtual ~PLTestFilters();

  virtual void RunTests ();

private:
  void testFilterWithBmp (const PLFilter& Filter, PLBmp& SrcBmp);
  void testDoubleFilter (const PLFilter& Filter);
  void testQuant (int DthPal, int Dth);
  void testFillRect ();
  void testFill ();
  void testRotate ();
  void testFlipRGB (); 

  PLBmp * m_pBmp32;
  PLBmp * m_pBmp8;

};

#endif

/*
/--------------------------------------------------------------------
|
|      $Log: pltestfilters.h,v $
|      Revision 1.3  2003/07/27 18:08:38  uzadow
|      Added plfilterfliprgb
|
|      Revision 1.2  2003/02/27 22:46:59  uzadow
|      Added plfilterrotate.
|
|      Revision 1.1  2002/08/04 20:12:34  uzadow
|      Added PLBmpInfo class, ability to extract metainformation from images without loading the whole image and proper greyscale support.
|      Major improvements in tests.
|
|
|
\--------------------------------------------------------------------
*/
