//
// C++ Interface: tagselectionwidget
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef __TAGSELECTIONWIDGET_H_2004_05_25
#define __TAGSELECTIONWIDGET_H_2004_05_25

#include <qwidget.h>

#include "helpers.h"

#include "tagselectionlistview.h"

class QLineEdit;

namespace NPlugin
{
	class DebtagsPluginContainer;
}


namespace NWidgets {

/**
@author Benjamin Mesing
*/
class TagSelectionWidget : public QWidget
{
	Q_OBJECT
	QLineEdit* _pFilterInput;
	TagSelectionListView* _pTagSelectionList;
private slots:
	/** This is neccessary to relay the text changed signal of the #_pFilterInput to the #_pTagSelectionList
	  * filterByNameSlot, as the arguments does not match (string vs. QString). */
	void onFilterTextChanged(const QString& text)	
		{ _pTagSelectionList->setFilterByNamePattern( toString(text) ); };
public:
	TagSelectionWidget(QWidget *parent, const NPlugin::DebtagsPluginContainer* pContainer, const char *name = 0);
	~TagSelectionWidget();
	TagSelectionListView* tagSelection()	{ return _pTagSelectionList; };
};

};

#endif	//  __NWIDGETSTAGSELECTIONWIDGET_H_2004_05_25
