#ifndef __PLUGIN_H_2004_06_21
#define __PLUGIN_H_2004_06_21

#include <string>

#include <qobject.h>
#include <qmainwindow.h>

namespace NPlugin
{

class IProvider;

/**
  * @author Benjamin Mesing
  */
class Plugin : public QObject 
{
protected:
	/** This offers an empty string for its children. */
	static const QString _emptyString;
public:
	virtual ~Plugin() {};
	/**
	  * 
	  * @param pluginManager the search window this plugin is added to
	  */
	virtual void init(IProvider* pProvider) = 0;
	/**
	  * Enables/Disables all widgets that belong to this plugin.
	  * @param enabled 
	  */
	virtual void setEnabled(bool enabled) = 0;
	/**
	  * Shows or hides the given plugin.
	  * @param visible 
	  */
	virtual void setVisible(bool visible) = 0;
	/** @brief Returns the title of the plugin, this is how it will be shown in configuration
	  * dialogs or similar.
	  * 
	  */
	virtual QString title() const = 0;
	/** @returns a brief description for this plugin. */
	virtual QString briefDescription() const = 0;
	/** @returns a description for this plugin. */
	virtual QString description() const = 0;
};



}	// namespace NPlugin

#endif	// __PLUGIN_H_2004_06_21

