#!/usr/bin/python

from distutils.core import setup
import string

author = 'David Villa Alises'
author_email = 'David.Villa@uclm.es'
website = 'http://arco.inf-cr.uclm.es/~david.villa/ows.html'
version = file('debian/changelog').readline().split()[1][1:-1]

ows_globals_in = string.Template(file('ows/ows_globals.py.in').read())
ows_globals = ows_globals_in.substitute(author=author,
                                        author_email=author_email,
                                        website=website,
                                        version=version)
file('ows/ows_globals.py', 'wt').write(ows_globals)

setup(name         = 'ows',
      version      = version,
      description  = 'Workspace OSD GNOME Applet',
      author       = author,
      author_email = author_email,
      url          = 'http://arco.inf-cr.uclm.es/~david.villa/ows.html',
      license      = 'GPL v2 or later',
      data_files   = [('/usr/lib/gnome-applets',   ['ows/ows_applet.py']),
                      ('/usr/lib/bonobo/servers',
                       ['data/GNOME_OSDWorkspaceSwitcherApplet.server']),
                      ('/usr/share/ows',          ['ows/ows.glade']),
                      ('/usr/share/gconf/schemas', ['data/ows.schemas']),
                      ('/usr/share/pixmaps',       ['images/ows.png']),
                      ('/usr/share/python-support/ows/ows',
                       ['ows/ows_globals.py',
                        'ows/__init__.py']),
                      ],
      )

#http://docs.python.org/dist/module-distutils.core.html
