/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import org.javagroups.Address;
import org.javagroups.Message;
import org.javagroups.conf.ClassConfigurator;
import org.javagroups.log.Trace;
import org.javagroups.protocols.FD_SOCK;
import org.javagroups.protocols.FRAG;
import org.javagroups.protocols.PingHeader;
import org.javagroups.protocols.UNICAST;
import org.javagroups.protocols.UdpHeader;
import org.javagroups.protocols.VERIFY_SUSPECT;
import org.javagroups.protocols.pbcast.GMS;
import org.javagroups.protocols.pbcast.NakAckHeader;
import org.javagroups.protocols.pbcast.STABLE;
import org.javagroups.stack.IpAddress;

public class MessageSerializationTest {
    static /* synthetic */ Class class$org$javagroups$Message;

    public static void main(String[] args) throws Exception {
        boolean add_headers = false;
        InetAddress addr = InetAddress.getLocalHost();
        int num = 10000;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-help")) {
                MessageSerializationTest.help();
                return;
            }
            if (args[i].equals("-add_headers")) {
                add_headers = true;
            } else if (args[i].equals("-num")) {
                num = Integer.parseInt(args[++i]);
            }
            ++i;
        }
        Trace.init();
        ClassConfigurator.getInstance();
        long start = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < num) {
            Message m = new Message((Address)new IpAddress(addr, 5555), (Address)new IpAddress(addr, 6666), new byte[256]);
            if (add_headers) {
                MessageSerializationTest.addHeaders(m);
            }
            ByteArrayOutputStream msg_data = new ByteArrayOutputStream();
            ObjectOutputStream msg_out = new ObjectOutputStream(msg_data);
            m.writeExternal(msg_out);
            msg_out.flush();
            msg_out.close();
            byte[] data = msg_data.toByteArray();
            ByteArrayInputStream msg_in_data = new ByteArrayInputStream(data);
            ObjectInputStream msg_in = new ObjectInputStream(msg_in_data);
            Class clazz = class$org$javagroups$Message;
            if (clazz == null) {
                clazz = MessageSerializationTest.class$("[Lorg.javagroups.Message;", false);
            }
            Message m2 = (Message)clazz.newInstance();
            m2.readExternal(msg_in);
            ++i2;
        }
        long stop = System.currentTimeMillis();
        System.out.println("Serializing and deserializing a message " + num + " times took " + (stop - start) + "ms.");
    }

    static void addHeaders(Message msg) {
        msg.putHeader("UDP", new UdpHeader("MyGroup"));
        msg.putHeader("PING", new PingHeader(1, null));
        msg.putHeader("FD_SOCK", new FD_SOCK.FdHeader());
        msg.putHeader("VERIFY_SUSPECT", new VERIFY_SUSPECT.VerifyHeader());
        msg.putHeader("STABLE", new STABLE.StableHeader());
        msg.putHeader("NAKACK", new NakAckHeader());
        msg.putHeader("UNICAST", new UNICAST.UnicastHeader());
        msg.putHeader("FRAG", new FRAG.FragHeader());
        msg.putHeader("GMS", new GMS.GmsHeader());
    }

    static void help() {
        System.out.println("MessageSerializationTest [-help] [-add_headers] [-num <iterations>]");
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

