/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols.ring;

import java.io.Serializable;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.protocols.TOTAL_TOKEN;
import org.javagroups.protocols.ring.RingNode;
import org.javagroups.protocols.ring.TokenLostException;
import org.javagroups.stack.IpAddress;
import org.javagroups.stack.RpcProtocol;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UdpRingNode
implements RingNode {
    Address thisNode;
    Address nextNode;
    RpcProtocol rpcProtocol;
    Object token;
    Object mutex;
    TOTAL_TOKEN.RingTokenHeader tokenHeader;
    boolean tokenInStack;

    public IpAddress getTokenReceiverAddress() {
        return (IpAddress)this.thisNode;
    }

    public synchronized void tokenArrived(Object token) {
        this.tokenInStack = true;
        this.token = token;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object receiveToken(int timeout) throws TokenLostException {
        Address wasNext = this.nextNode;
        try {
            UdpRingNode udpRingNode = this;
            synchronized (udpRingNode) {
                if (!this.tokenInStack) {
                    this.wait(timeout);
                }
                if (this.tokenInStack) return this.token;
                throw new TokenLostException("Token wait timout expired", null, wasNext, TokenLostException.WHILE_RECEIVING);
            }
        }
        catch (InterruptedException ie) {
            throw new TokenLostException("Token thread interrupted", (Throwable)ie, wasNext, TokenLostException.WHILE_RECEIVING);
        }
    }

    public Object receiveToken() throws TokenLostException {
        return this.receiveToken(0);
    }

    public synchronized void passToken(Object token) {
        Message t = new Message(this.nextNode, this.thisNode, (Serializable)token);
        t.putHeader("TOTAL_TOKEN", this.tokenHeader);
        this.rpcProtocol.passDown(new Event(1, t));
        this.tokenInStack = false;
    }

    public synchronized void reconfigure(Vector newMembers) {
        if (this.isNextNeighbourChanged(newMembers)) {
            this.nextNode = this.getNextNode(newMembers);
        }
    }

    private final boolean isNextNeighbourChanged(Vector newMembers) {
        Address oldNeighbour = this.nextNode;
        Address newNeighbour = this.getNextNode(newMembers);
        return newNeighbour.equals(oldNeighbour) ^ true;
    }

    private final Address getNextNode(Vector otherNodes) {
        int myIndex = otherNodes.indexOf(this.thisNode);
        return myIndex == otherNodes.size() - 1 ? (Address)otherNodes.firstElement() : (Address)otherNodes.elementAt(myIndex + 1);
    }

    private final /* synthetic */ void this() {
        this.mutex = new Object();
        this.tokenInStack = false;
    }

    public UdpRingNode(RpcProtocol owner, Address memberAddress) {
        this.this();
        this.rpcProtocol = owner;
        this.thisNode = memberAddress;
        this.nextNode = null;
        this.tokenHeader = new TOTAL_TOKEN.RingTokenHeader();
    }
}

