/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.demos;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import org.javagroups.Channel;
import org.javagroups.ChannelClosedException;
import org.javagroups.GetStateEvent;
import org.javagroups.JChannel;
import org.javagroups.Message;
import org.javagroups.SetStateEvent;
import org.javagroups.View;
import org.javagroups.demos.MyCanvas;
import org.javagroups.demos.TotOrderRequest;
import org.javagroups.log.Trace;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TotalOrder
extends Frame {
    final Font def_font;
    final Font def_font2;
    MyCanvas canvas;
    MenuBar menubar;
    Button start;
    Button stop;
    Button clear;
    Button get_state;
    Button quit;
    Panel button_panel;
    SenderThread sender;
    ReceiverThread receiver;
    Channel channel;
    Dialog error_dlg;
    long timeout;
    int field_size;
    int num_fields;
    final int x_offset = 30;
    final int y_offset = 40;

    void error(String s) {
        System.err.println(s);
    }

    void processRequest(TotOrderRequest req) throws Exception {
        int x = req.x;
        int y = req.y;
        int val = req.val;
        int result = 0;
        if (req.type == 0) {
            this.stopSender();
            return;
        }
        switch (req.type) {
            case 1: {
                result = this.canvas.addValueTo(x, y, val);
                break;
            }
            case 2: {
                result = this.canvas.subtractValueFrom(x, y, val);
                break;
            }
            case 3: {
                result = this.canvas.multiplyValueWith(x, y, val);
                break;
            }
            case 4: {
                result = this.canvas.divideValueBy(x, y, val);
                break;
            }
        }
        this.canvas.update();
    }

    void startSender() {
        if (this.sender == null) {
            this.sender = new SenderThread();
            this.sender.start();
        }
    }

    void stopSender() {
        if (this.sender != null) {
            this.sender.stopSender();
            this.sender = null;
        }
    }

    void startReceiver() {
        if (this.receiver == null) {
            this.receiver = new ReceiverThread();
            this.receiver.setPriority(10);
            this.receiver.start();
        }
    }

    void stopReceiver() {
        if (this.receiver != null) {
            this.receiver.stopReceiver();
            this.receiver = null;
        }
    }

    MenuBar createMenuBar() {
        MenuBar ret = new MenuBar();
        Menu file = new Menu("File");
        MenuItem quit = new MenuItem("Quit");
        ret.setFont(this.def_font2);
        ret.add(file);
        file.addSeparator();
        file.add(quit);
        quit.addActionListener(new ActionListener(this){
            final /* synthetic */ TotalOrder this$0;

            public final void actionPerformed(ActionEvent e) {
                System.exit(1);
            }
            {
                this.this$0 = totalOrder;
            }
        });
        return ret;
    }

    public void rrror(String msg) {
        Button ok = new Button("Ok");
        Label l = new Label(msg);
        this.error_dlg = new Dialog(this, msg, true);
        this.error_dlg.setLocation(90, 150);
        this.error_dlg.setSize(420, 100);
        this.error_dlg.setLayout(new BorderLayout());
        this.error_dlg.setFont(this.def_font2);
        ok.addActionListener(new ActionListener(this){
            final /* synthetic */ TotalOrder this$0;

            public final void actionPerformed(ActionEvent e) {
                this.this$0.error_dlg.dispose();
            }
            {
                this.this$0 = totalOrder;
            }
        });
        this.error_dlg.add("Center", l);
        this.error_dlg.add("South", ok);
        this.error_dlg.show();
    }

    TotOrderRequest createRandomRequest() {
        TotOrderRequest ret = null;
        int op_type = (int)(Math.random() * 10.0 % (double)4 + 1.0);
        int x = (int)(Math.random() * (double)this.num_fields * (double)2 % (double)this.num_fields);
        int y = (int)(Math.random() * (double)this.num_fields * (double)2 % (double)this.num_fields);
        int val = (int)(Math.random() * (double)this.num_fields * 200.0 % 10.0);
        ret = new TotOrderRequest(op_type, x, y, val);
        return ret;
    }

    public static void main(String[] args) {
        long timeout = 200L;
        int num_fields = 3;
        int field_size = 80;
        String props = null;
        props = "UDP(mcast_addr=224.0.0.35;mcast_port=45566;ip_ttl=0;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.STABLE(desired_avg_gossip=20000):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=5000):FRAG(frag_size=4096;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER";
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equals("-timeout")) {
                timeout = new Long(args[++i]);
            } else if (arg.equals("-num_fields")) {
                num_fields = new Integer(args[++i]);
            } else if (arg.equals("-field_size")) {
                field_size = new Integer(args[++i]);
            } else {
                if (arg.equals("-help")) {
                    System.out.println("\nTotalOrder [-timeout <value>] [-num_fields <value>] [-field_size <value>] [-props <properties (can be URL)>]\n");
                    return;
                }
                if (arg.equals("-props")) {
                    props = args[++i];
                }
            }
            ++i;
        }
        Trace.init();
        try {
            TotalOrder g = new TotalOrder("Total Order Demo on " + InetAddress.getLocalHost().getHostName(), timeout, num_fields, field_size, props);
            g.show();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private final /* synthetic */ void this() {
        this.def_font = new Font("Helvetica", 1, 12);
        this.def_font2 = new Font("Helvetica", 0, 12);
        this.menubar = this.createMenuBar();
        this.start = new Button("Start");
        this.stop = new Button("Stop");
        this.clear = new Button("Clear");
        this.get_state = new Button("Get State");
        this.quit = new Button("Quit");
        this.button_panel = new Panel();
        this.sender = null;
        this.receiver = null;
        this.timeout = 0L;
        this.field_size = 0;
        this.num_fields = 0;
        this.x_offset = 30;
        this.y_offset = 40;
    }

    public TotalOrder(String title, long timeout, int num_fields, int field_size, String props) {
        this.this();
        this.timeout = timeout;
        this.num_fields = num_fields;
        this.field_size = field_size;
        this.setFont(this.def_font);
        try {
            this.channel = new JChannel(props);
            this.channel.setOpt(4, new Boolean(true));
            this.channel.connect("TotalOrderGroup");
            boolean rc = this.channel.getState(null, 8000L);
        }
        catch (Exception e) {
            this.error(e.toString());
            System.exit(-1);
        }
        this.start.addActionListener(new ActionListener(this){
            final /* synthetic */ TotalOrder this$0;

            public final void actionPerformed(ActionEvent e) {
                this.this$0.startSender();
            }
            {
                this.this$0 = totalOrder;
            }
        });
        this.stop.addActionListener(new ActionListener(this){
            final /* synthetic */ TotalOrder this$0;

            public final void actionPerformed(ActionEvent e) {
                try {
                    this.this$0.channel.send(new Message(null, null, Util.objectToByteBuffer(new TotOrderRequest(0, 0, 0, 0))));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            {
                this.this$0 = totalOrder;
            }
        });
        this.clear.addActionListener(new ActionListener(this){
            final /* synthetic */ TotalOrder this$0;

            public final void actionPerformed(ActionEvent e) {
                this.this$0.canvas.clear();
            }
            {
                this.this$0 = totalOrder;
            }
        });
        this.get_state.addActionListener(new ActionListener(this){
            final /* synthetic */ TotalOrder this$0;

            public final void actionPerformed(ActionEvent e) {
                try {
                    boolean rc = this.this$0.channel.getState(null, 3000L);
                    if (!rc) {
                        this.this$0.error("State could not be retrieved !");
                    }
                }
                catch (Throwable t) {
                    this.this$0.error("exception fetching state: " + t);
                }
            }
            {
                this.this$0 = totalOrder;
            }
        });
        this.quit.addActionListener(new ActionListener(this){
            final /* synthetic */ TotalOrder this$0;

            public final void actionPerformed(ActionEvent e) {
                this.this$0.channel.disconnect();
                this.this$0.channel.close();
                System.exit(0);
            }
            {
                this.this$0 = totalOrder;
            }
        });
        this.setTitle(title);
        this.addWindowListener(new EventHandler(this));
        this.setBackground(Color.white);
        this.setMenuBar(this.menubar);
        this.setLayout(new BorderLayout());
        this.canvas = new MyCanvas(num_fields, field_size, 30, 40);
        this.add("Center", this.canvas);
        this.button_panel.setLayout(new FlowLayout());
        this.button_panel.setFont(this.def_font2);
        this.button_panel.add(this.start);
        this.button_panel.add(this.stop);
        this.button_panel.add(this.clear);
        this.button_panel.add(this.get_state);
        this.button_panel.add(this.quit);
        this.add("South", this.button_panel);
        Dimension s = this.canvas.getSize();
        s.height += 100;
        this.setSize(s);
        this.startReceiver();
    }

    class EventHandler
    extends WindowAdapter {
        Frame gui;

        public void windowClosing(WindowEvent e) {
            this.gui.dispose();
            System.exit(0);
        }

        public EventHandler(Frame g) {
            this.gui = g;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SenderThread
    extends Thread {
        TotOrderRequest req;
        boolean running;

        public void stopSender() {
            this.running = false;
            this.interrupt();
        }

        public void run() {
            this.setName("SenderThread");
            while (this.running) {
                try {
                    this.req = TotalOrder.this.createRandomRequest();
                    TotalOrder.this.channel.send(new Message(null, null, Util.objectToByteBuffer(this.req)));
                    Util.sleep(TotalOrder.this.timeout);
                }
                catch (Exception e) {
                    TotalOrder.this.error(e.toString());
                    return;
                }
            }
        }

        private final /* synthetic */ void this() {
            this.running = true;
        }

        SenderThread() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ReceiverThread
    extends Thread {
        Object o;
        Message msg;
        TotOrderRequest req;
        SetStateEvent set_state_evt;
        boolean running;

        public void stopReceiver() {
            this.running = false;
            this.interrupt();
        }

        public void run() {
            this.setName("ReceiverThread");
            while (this.running) {
                try {
                    this.o = TotalOrder.this.channel.receive(0L);
                    if (this.o instanceof Message) {
                        try {
                            this.msg = (Message)this.o;
                            Object tmp = Util.objectFromByteBuffer(this.msg.getBuffer());
                            if (!(tmp instanceof TotOrderRequest)) {
                                System.err.println("tmp is " + tmp.getClass() + ": " + tmp);
                                if (tmp instanceof Message) {
                                    System.out.print("Hdrs are ");
                                    ((Message)tmp).printObjectHeaders();
                                }
                            }
                            this.req = (TotOrderRequest)tmp;
                            TotalOrder.this.processRequest(this.req);
                        }
                        catch (Exception e) {
                            System.err.println(e);
                        }
                        continue;
                    }
                    if (this.o instanceof GetStateEvent) {
                        int[][] copy_of_state = TotalOrder.this.canvas.getCopyOfState();
                        TotalOrder.this.channel.returnState(Util.objectToByteBuffer(copy_of_state));
                        continue;
                    }
                    if (this.o instanceof SetStateEvent) {
                        this.set_state_evt = (SetStateEvent)this.o;
                        TotalOrder.this.canvas.setState(Util.objectFromByteBuffer(this.set_state_evt.getArg()));
                        continue;
                    }
                    if (!(this.o instanceof View)) continue;
                    System.out.println(this.o.toString());
                }
                catch (ChannelClosedException closed) {
                    TotalOrder.this.error("Channel has been closed; receiver thread quits");
                    return;
                }
                catch (Exception e) {
                    TotalOrder.this.error(e.toString());
                    return;
                }
            }
        }

        private final /* synthetic */ void this() {
            this.running = true;
        }

        ReceiverThread() {
            this.this();
        }
    }
}

