/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.blocks;

import java.io.Serializable;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.Event;
import org.javagroups.JChannel;
import org.javagroups.MembershipListener;
import org.javagroups.Message;
import org.javagroups.MessageListener;
import org.javagroups.View;
import org.javagroups.blocks.PullPushAdapter;
import org.javagroups.log.Trace;
import org.javagroups.util.Promise;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NotificationBus
implements MessageListener,
MembershipListener {
    Vector members;
    JChannel channel;
    Address local_addr;
    PullPushAdapter ad;
    Consumer consumer;
    String bus_name;
    Promise get_cache_promise;
    Object cache_mutex;
    String props;

    public void setConsumer(Consumer c) {
        this.consumer = c;
    }

    public Address getLocalAddress() {
        if (this.local_addr != null) {
            return this.local_addr;
        }
        if (this.channel != null) {
            this.local_addr = this.channel.getLocalAddress();
        }
        return this.local_addr;
    }

    public Vector getMembership() {
        return this.members;
    }

    public Channel getChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCoordinator() {
        Object first_mbr = null;
        Vector vector = this.members;
        synchronized (vector) {
            if (this.members.size() <= 0) return true;
            Object v0 = this.members.elementAt(0);
            first_mbr = v0;
            if (first_mbr == null) {
                return true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
            if (this.getLocalAddress() == null) return false;
            if (first_mbr == null) return false;
            return this.getLocalAddress().equals(first_mbr);
        }
    }

    public void start() throws Exception {
        this.channel.connect(this.bus_name);
        this.ad = new PullPushAdapter(this.channel, this, this);
    }

    public void stop() {
        if (this.ad != null) {
            this.ad.stop();
            this.ad = null;
        }
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public void sendNotification(Serializable n) {
        block4: {
            Message msg = null;
            byte[] data = null;
            try {
                if (n == null) {
                    return;
                }
                Info info = new Info(1, n);
                data = Util.objectToByteBuffer(info);
                msg = new Message(null, null, data);
                if (this.channel == null) {
                    Trace.error("NotificationBus.sendNotification()", "channel is null.  Won't send notification");
                    return;
                }
                this.channel.send(msg);
            }
            catch (Throwable ex) {
                if (!Trace.trace) break block4;
                Trace.error("NotificationBus.sendNotification()", "exception is " + ex);
            }
        }
    }

    public Serializable getCacheFromCoordinator(long timeout, int max_tries) {
        return this.getCacheFromMember(null, timeout, max_tries);
    }

    public Serializable getCacheFromMember(Address mbr, long timeout, int max_tries) {
        Serializable cache = null;
        int num_tries = 0;
        Info info = new Info(2);
        Address dst = mbr;
        if (max_tries < 1) {
            max_tries = 1;
        }
        this.get_cache_promise.reset();
        while (num_tries <= max_tries) {
            if (mbr == null && ((dst = this.determineCoordinator()) == null || dst.equals(this.getLocalAddress()))) {
                if (Trace.trace) {
                    Trace.info("NotificationBus.getCacheFromMember()", "[" + this.getLocalAddress() + "] no coordinator found --> first member (cache is empty)");
                }
                return null;
            }
            Trace.info("NotificationBus.getCacheFromMember()", "[" + this.getLocalAddress() + "] dst=" + dst + ", timeout=" + timeout + ", max_tries=" + max_tries + ", num_tries=" + num_tries);
            if (dst != null) {
                info = new Info(2);
                Message msg = new Message(dst, null, info);
                this.channel.down(new Event(1, msg));
                long start = System.currentTimeMillis();
                cache = (Serializable)this.get_cache_promise.getResult(timeout);
                long stop = System.currentTimeMillis();
                if (cache != null) {
                    if (Trace.trace) {
                        Trace.info("NotificationBus.getCacheFromMember()", "got cache from " + dst + ": cache is valid (waited " + (stop - start) + " msecs on get_cache_promise)");
                    }
                    return cache;
                }
                if (Trace.trace) {
                    Trace.error("NotificationBus.getCacheFromMember()", "received null cache; retrying (waited " + (stop - start) + " msecs on get_cache_promise)");
                }
            }
            Util.sleep(500L);
            ++num_tries;
        }
        if (cache == null) {
            Trace.error("NotificationBus.getCacheFromMember()", "[" + this.getLocalAddress() + "] cache is null (num_tries=" + num_tries + ')');
        }
        return cache;
    }

    public void notifyConsumer(Serializable n) {
        if (this.consumer != null && n != null) {
            this.consumer.handleNotification(n);
        }
    }

    public void receive(Message msg) {
        block10: {
            byte[] data;
            Info info = null;
            if (msg == null || (data = msg.getBuffer()) == null) {
                return;
            }
            try {
                Object obj = Util.objectFromByteBuffer(data);
                if (!(obj instanceof Info)) {
                    if (Trace.trace) {
                        Trace.error("NotificationBus.receive()", "expected an instance of Info (received " + obj.getClass().getName() + ')');
                    }
                    return;
                }
                info = (Info)obj;
                switch (info.type) {
                    case 1: {
                        this.notifyConsumer(info.data);
                        break;
                    }
                    case 2: {
                        this.handleCacheRequest(msg.getSrc());
                        break;
                    }
                    case 3: {
                        Trace.debug("NotificationBus.receive()", "[GET_CACHE_RSP] cache was received from " + msg.getSrc());
                        this.get_cache_promise.setResult(info.data);
                        break;
                    }
                    default: {
                        Trace.error("NotificationBus.receive()", "type " + info.type + " unknown");
                        break;
                    }
                }
            }
            catch (Throwable ex) {
                if (!Trace.trace) break block10;
                Trace.error("NotificationBus.receive()", "exception=" + ex);
            }
        }
    }

    public byte[] getState() {
        return null;
    }

    public void setState(byte[] state) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void viewAccepted(View new_view) {
        if (new_view == null) {
            return;
        }
        tmp = new_view.getMembers();
        var6_3 = this.members;
        synchronized (var6_3) {
            joined_mbrs = new Vector<E>();
            i = 0;
            while (true) {
                block13: {
                    if (i < tmp.size()) break block13;
                    left_mbrs = new Vector<E>();
                    i = 0;
                    if (true) ** GOTO lbl27
                }
                tmp_mbr = tmp.elementAt(i);
                if (!this.members.contains(tmp_mbr)) {
                    joined_mbrs.addElement(tmp_mbr);
                }
                ++i;
            }
            do {
                if (!tmp.contains(tmp_mbr = this.members.elementAt(i))) {
                    left_mbrs.addElement(tmp_mbr);
                }
                ++i;
lbl27:
                // 2 sources

            } while (i < this.members.size());
            this.members.removeAllElements();
            this.members.addAll(tmp);
            ** if (this.consumer == null) goto lbl44
        }
lbl-1000:
        // 1 sources

        {
            if (joined_mbrs.size() > 0) {
                i = 0;
                while (i < joined_mbrs.size()) {
                    this.consumer.memberJoined((Address)joined_mbrs.elementAt(i));
                    ++i;
                }
            }
            if (left_mbrs.size() > 0) {
                i = 0;
                while (i < left_mbrs.size()) {
                    this.consumer.memberLeft((Address)left_mbrs.elementAt(i));
                    ++i;
                }
            }
        }
lbl44:
        // 4 sources

    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    Address determineCoordinator() {
        Vector v = this.channel != null ? this.channel.getView().getMembers() : null;
        return v != null ? (Address)v.elementAt(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void handleCacheRequest(Address sender) {
        Serializable cache = null;
        if (sender == null) {
            Trace.error("NotificationBus.handleCacheRequest()", "sender is null");
            return;
        }
        Object object = this.cache_mutex;
        synchronized (object) {
            cache = this.getCache();
            Info info = new Info(3, cache);
            Message msg = new Message(sender, null, info);
            Trace.info("NotificationBus.handleCacheRequest()", "[" + this.getLocalAddress() + "] returning cache to " + sender);
            this.channel.down(new Event(1, msg));
            return;
        }
    }

    public Serializable getCache() {
        return this.consumer != null ? this.consumer.getCache() : null;
    }

    private final /* synthetic */ void this() {
        this.members = new Vector();
        this.channel = null;
        this.local_addr = null;
        this.ad = null;
        this.consumer = null;
        this.bus_name = "notification_bus";
        this.get_cache_promise = new Promise();
        this.cache_mutex = new Object();
        this.props = "UDP(mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=0;trace=true):PING(timeout=3000;num_initial_members=6):FD(trace=true;timeout=5000):VERIFY_SUSPECT(trace=false;timeout=1500):pbcast.STABLE(trace=true;desired_avg_gossip=5000):pbcast.NAKACK(trace=true;gc_lag=5;retransmit_timeout=3000):UNICAST(timeout=5000):FRAG:pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;trace=true;shun=false;print_local_addr=false)";
    }

    public NotificationBus() throws Exception {
        this(null, null);
    }

    public NotificationBus(String bus_name) throws Exception {
        this(bus_name, null);
    }

    public NotificationBus(String bus_name, String properties) throws Exception {
        this.this();
        if (bus_name != null) {
            this.bus_name = bus_name;
        }
        if (properties != null) {
            this.props = properties;
        }
        this.channel = new JChannel(this.props);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Info
    implements Serializable {
        public static final int NOTIFICATION = 1;
        public static final int GET_CACHE_REQ = 2;
        public static final int GET_CACHE_RSP = 3;
        int type;
        Serializable data;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("type= ");
            if (this.type == 1) {
                sb.append("NOTIFICATION");
            } else if (this.type == 2) {
                sb.append("GET_CACHE_REQ");
            } else if (this.type == 3) {
                sb.append("GET_CACHE_RSP");
            } else {
                sb.append("<unknown>");
            }
            if (this.data != null) {
                if (this.type == 1) {
                    sb.append(", notification=" + this.data);
                } else if (this.type == 3) {
                    sb.append(", cache=" + this.data);
                }
            }
            return sb.toString();
        }

        private final /* synthetic */ void this() {
            this.type = 0;
            this.data = null;
        }

        public Info(int type) {
            this.this();
            this.type = type;
        }

        public Info(int type, Serializable data) {
            this.this();
            this.type = type;
            this.data = data;
        }
    }

    public static interface Consumer {
        public void handleNotification(Serializable var1);

        public Serializable getCache();

        public void memberJoined(Address var1);

        public void memberLeft(Address var1);
    }
}

