/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.blocks;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.ChannelClosedException;
import org.javagroups.ChannelFactory;
import org.javagroups.ChannelNotConnectedException;
import org.javagroups.JChannel;
import org.javagroups.MembershipListener;
import org.javagroups.Message;
import org.javagroups.MessageListener;
import org.javagroups.View;
import org.javagroups.blocks.MethodCall;
import org.javagroups.blocks.RpcDispatcher;
import org.javagroups.util.RspList;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DistributedQueue
implements MessageListener,
MembershipListener,
Cloneable {
    static Logger logger;
    Object mutex;
    private LinkedList internalQueue;
    private transient Channel channel;
    private transient RpcDispatcher disp;
    private transient String groupname;
    private transient Vector notifs;
    private transient Vector members;
    private transient MethodCall add_method;
    private transient MethodCall addAtHead_method;
    private transient MethodCall reset_method;
    private transient MethodCall remove_method;
    private transient MethodCall getFirst_method;
    private transient MethodCall getLast_method;
    static /* synthetic */ Class class$org$javagroups$blocks$DistributedQueue;
    static /* synthetic */ Class class$java$lang$Object;

    protected void init() throws ChannelClosedException, ChannelNotConnectedException {
        this.initMethods();
        this.internalQueue = new LinkedList();
        this.channel.setOpt(4, new Boolean(true));
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
        this.disp.setDeadlockDetection(false);
    }

    public void start(long state_timeout) throws ChannelClosedException, ChannelNotConnectedException {
        logger.debug((Object)("DistributedQueue.initState(" + this.groupname + "): starting state retrieval"));
        boolean rc = this.channel.getState(null, state_timeout);
        if (rc) {
            logger.info((Object)("DistributedQueue.initState(" + this.groupname + "): state was retrieved successfully"));
        } else {
            logger.info((Object)("DistributedQueue.initState(" + this.groupname + "): state could not be retrieved (first member)"));
        }
    }

    public Address getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void addNotifier(Notification n) {
        if (!this.notifs.contains(n)) {
            this.notifs.addElement(n);
        }
    }

    public void stop() {
        if (this.disp != null) {
            this.disp.stop();
            this.disp = null;
        }
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public void add(Object value) {
        try {
            Object retval = null;
            this.add_method.setArg(0, value);
            RspList rsp = this.disp.callRemoteMethods(null, this.add_method, 2, 0L);
            Vector results = rsp.getResults();
            if (results.size() > 0) {
                retval = results.elementAt(0);
                if (logger.isDebugEnabled()) {
                    this.checkResult(rsp, retval);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to add value " + value), (Throwable)e);
        }
    }

    public void addAtHead(Object value) {
        try {
            this.addAtHead_method.setArg(0, value);
            this.disp.callRemoteMethods(null, this.addAtHead_method, 2, 0L);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to addAtHead value " + value), (Throwable)e);
        }
    }

    public Vector getContents() {
        Vector result = new Vector();
        boolean i = false;
        Iterator e = this.internalQueue.iterator();
        while (e.hasNext()) {
            result.add(e.next());
        }
        return result;
    }

    public int size() {
        return this.internalQueue.size();
    }

    public Object peek() {
        Object retval = null;
        try {
            retval = this.internalQueue.getFirst();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return retval;
    }

    public void reset() {
        try {
            this.disp.callRemoteMethods(null, this.reset_method, 2, 0L);
        }
        catch (Exception e) {
            logger.error((Object)("DistributedQueue.reset(" + this.groupname + ')'), (Throwable)e);
        }
    }

    protected void checkResult(RspList rsp, Object retval) {
        logger.debug((Object)("Value updated from " + this.groupname + " :" + retval));
        Vector results = rsp.getResults();
        int i = 0;
        while (i < results.size()) {
            Object data = results.elementAt(i);
            if (!data.equals(retval)) {
                logger.error((Object)("Reference value differs from returned value " + retval + " != " + data));
            }
            ++i;
        }
    }

    public Object remove() {
        RspList rsp;
        Vector results;
        Object retval = null;
        if (this.internalQueue.size() > 0 && (results = (rsp = this.disp.callRemoteMethods(null, this.remove_method, 2, 0L)).getResults()).size() > 0) {
            retval = results.elementAt(0);
            if (logger.isDebugEnabled()) {
                this.checkResult(rsp, retval);
            }
        }
        return retval;
    }

    public Object remove(long timeout) {
        Object retval;
        block9: {
            block8: {
                retval = null;
                if (this.internalQueue.size() <= 0) break block8;
                RspList rsp = this.disp.callRemoteMethods(null, this.remove_method, 2, 0L);
                Vector results = rsp.getResults();
                if (results.size() <= 0) break block9;
                retval = results.elementAt(0);
                if (!logger.isDebugEnabled()) break block9;
                this.checkResult(rsp, retval);
                break block9;
            }
            long t = System.currentTimeMillis();
            if (timeout == 0L) {
                while (retval == null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException rsp) {
                        // empty catch block
                    }
                    RspList rsp = this.disp.callRemoteMethods(null, this.remove_method, 2, 0L);
                    Vector results = rsp.getResults();
                    if (results.size() <= 0) continue;
                    retval = results.elementAt(0);
                    if (!logger.isDebugEnabled()) continue;
                    this.checkResult(rsp, retval);
                }
            } else {
                long interval = timeout / 10L;
                while (System.currentTimeMillis() - t < timeout && retval == null) {
                    try {
                        Thread.sleep(interval);
                    }
                    catch (InterruptedException rsp) {
                        // empty catch block
                    }
                    RspList rsp = this.disp.callRemoteMethods(null, this.remove_method, 2, 0L);
                    Vector results = rsp.getResults();
                    if (results.size() <= 0) continue;
                    retval = results.elementAt(0);
                    if (!logger.isDebugEnabled()) continue;
                    this.checkResult(rsp, retval);
                }
            }
        }
        return retval;
    }

    public String toString() {
        return this.internalQueue.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _add(Object value) {
        DistributedQueue.logger.debug((Object)(this.getLocalAddress() + " _add(" + value + ')'));
        var2_2 = this.mutex;
        synchronized (var2_2) {
            this.internalQueue.add(value);
            this.mutex.notifyAll();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
            i = 0;
            if (true) ** GOTO lbl16
        }
        do {
            ((Notification)this.notifs.elementAt(i)).entryAdd(value);
            ++i;
lbl16:
            // 2 sources

        } while (i < this.notifs.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _addAtHead(Object value) {
        var2_2 = this.mutex;
        synchronized (var2_2) {
            this.internalQueue.addFirst(value);
            this.mutex.notifyAll();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
            i = 0;
            if (true) ** GOTO lbl14
        }
        do {
            ((Notification)this.notifs.elementAt(i)).entryAdd(value);
            ++i;
lbl14:
            // 2 sources

        } while (i < this.notifs.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _reset() {
        Object object = this.mutex;
        synchronized (object) {
            this.internalQueue.clear();
            this.mutex.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object _remove() {
        Object retval = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                retval = this.internalQueue.removeFirst();
                this.mutex.notifyAll();
            }
            logger.debug((Object)("_remove(" + retval + ')'));
            int i = 0;
            while (true) {
                if (i >= this.notifs.size()) {
                    return retval;
                }
                ((Notification)this.notifs.elementAt(i)).entryRemoved(retval);
                ++i;
            }
        }
        catch (NoSuchElementException e) {
            logger.debug((Object)"_remove(): nothing to remove");
        }
        return retval;
    }

    public void receive(Message msg) {
    }

    public byte[] getState() {
        Vector copy = (Vector)this.getContents().clone();
        try {
            return Util.objectToByteBuffer(copy);
        }
        catch (Throwable ex) {
            logger.error((Object)"DistributedQueue.getState(): exception marshalling state.", ex);
            return null;
        }
    }

    public void setState(byte[] new_state) {
        Vector new_copy;
        try {
            new_copy = (Vector)Util.objectFromByteBuffer(new_state);
            if (new_copy == null) {
                return;
            }
        }
        catch (Throwable ex) {
            logger.error((Object)"DistributedQueue.setState(): exception unmarshalling state.", ex);
            return;
        }
        this._reset();
        Iterator e = new_copy.iterator();
        while (e.hasNext()) {
            Object value = e.next();
            this._add(value);
        }
    }

    public void viewAccepted(View new_view) {
        Vector new_mbrs = new_view.getMembers();
        if (new_mbrs != null) {
            this.sendViewChangeNotifications(new_mbrs, this.members);
            this.members.removeAllElements();
            int i = 0;
            while (i < new_mbrs.size()) {
                this.members.addElement(new_mbrs.elementAt(i));
                ++i;
            }
        }
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    void sendViewChangeNotifications(Vector new_mbrs, Vector old_mbrs) {
        Object mbr;
        if (this.notifs.size() == 0 || old_mbrs == null || new_mbrs == null || old_mbrs.size() == 0 || new_mbrs.size() == 0) {
            return;
        }
        Vector joined = new Vector();
        int i = 0;
        while (i < new_mbrs.size()) {
            mbr = new_mbrs.elementAt(i);
            if (!old_mbrs.contains(mbr)) {
                joined.addElement(mbr);
            }
            ++i;
        }
        Vector left = new Vector();
        i = 0;
        while (i < old_mbrs.size()) {
            mbr = old_mbrs.elementAt(i);
            if (!new_mbrs.contains(mbr)) {
                left.addElement(mbr);
            }
            ++i;
        }
        i = 0;
        while (i < this.notifs.size()) {
            Notification n = (Notification)this.notifs.elementAt(i);
            n.viewChange(joined, left);
            ++i;
        }
    }

    void initMethods() {
        try {
            if (this.add_method == null) {
                Class<?> clazz = this.getClass();
                Class[] classArray = new Class[1];
                Class clazz2 = class$java$lang$Object;
                if (clazz2 == null) {
                    clazz2 = class$java$lang$Object = DistributedQueue.class$("[Ljava.lang.Object;", false);
                }
                classArray[0] = clazz2;
                this.add_method = new MethodCall(clazz.getMethod("_add", classArray));
                this.add_method.setNumArgs(1);
            }
            if (this.addAtHead_method == null) {
                Class<?> clazz = this.getClass();
                Class[] classArray = new Class[1];
                Class clazz3 = class$java$lang$Object;
                if (clazz3 == null) {
                    clazz3 = class$java$lang$Object = DistributedQueue.class$("[Ljava.lang.Object;", false);
                }
                classArray[0] = clazz3;
                this.addAtHead_method = new MethodCall(clazz.getMethod("_addAtHead", classArray));
                this.addAtHead_method.setNumArgs(1);
            }
            if (this.reset_method == null) {
                this.reset_method = new MethodCall(this.getClass().getMethod("_reset", new Class[0]));
            }
            if (this.remove_method == null) {
                this.remove_method = new MethodCall(this.getClass().getMethod("_remove", new Class[0]));
            }
        }
        catch (Throwable ex) {
            logger.error((Object)"DistributedQueue.initMethods()", ex);
        }
    }

    public static void main(String[] args) {
        try {
            JChannel c = new JChannel("file:/c:/JavaGroups-2.0/conf/conf/total-token.xml");
            c.setOpt(4, new Boolean(true));
            DistributedQueue ht = new DistributedQueue(c);
            c.connect("demo");
            ht.start(5000L);
            ht.add("name");
            ht.add("Michelle Ban");
            Object old_key = ht.remove();
            System.out.println("old key was " + old_key);
            old_key = ht.remove();
            System.out.println("old value was " + old_key);
            ht.add("name 'Michelle Ban'");
            System.out.println("queue is " + ht);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.mutex = new Object();
        this.disp = null;
        this.groupname = null;
        this.notifs = new Vector();
        this.members = new Vector();
        this.add_method = null;
        this.addAtHead_method = null;
        this.reset_method = null;
        this.remove_method = null;
        this.getFirst_method = null;
        this.getLast_method = null;
    }

    public DistributedQueue(String groupname, ChannelFactory factory, String properties, long state_timeout) {
        this.this();
        this.groupname = groupname;
        try {
            this.initMethods();
            this.internalQueue = new LinkedList();
            this.channel = factory != null ? factory.createChannel(properties) : new JChannel(properties);
            this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
            this.disp.setDeadlockDetection(false);
            this.channel.setOpt(4, new Boolean(true));
            this.channel.connect(groupname);
            this.start(state_timeout);
        }
        catch (Exception e) {
            logger.error((Object)"DistributedQueue.DistributedQueue()", (Throwable)e);
        }
    }

    public DistributedQueue(JChannel channel) throws ChannelNotConnectedException, ChannelClosedException {
        this.this();
        this.groupname = channel.getChannelName();
        this.channel = channel;
        this.init();
    }

    static {
        Class clazz = class$org$javagroups$blocks$DistributedQueue;
        if (clazz == null) {
            clazz = class$org$javagroups$blocks$DistributedQueue = DistributedQueue.class$("[Lorg.javagroups.blocks.DistributedQueue;", false);
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public static interface Notification {
        public void entryAdd(Object var1);

        public void entryRemoved(Object var1);

        public void viewChange(Vector var1, Vector var2);
    }
}

