/**
 * <b>SOFTWARE RIGHTS</b>
 * <p>
 * ANTLR 2.6.0 MageLang Insitute, 1998
 * <p>
 * We reserve no legal rights to the ANTLR--it is fully in the
 * public domain. An individual or company may do whatever
 * they wish with source code distributed with ANTLR or the
 * code generated by ANTLR, including the incorporation of
 * ANTLR, or its output, into commerical software.
 * <p>
 * We encourage users to develop software with ANTLR. However,
 * we do ask that credit is given to us for developing
 * ANTLR. By "credit", we mean that if you use ANTLR or
 * incorporate any source code into one of your programs
 * (commercial product, research project, or otherwise) that
 * you acknowledge this fact somewhere in the documentation,
 * research report, etc... If you like ANTLR and have
 * developed a nice tool with the output, please mention that
 * you developed it using ANTLR. In addition, we ask that the
 * headers remain intact in our source code. As long as these
 * guidelines are kept, we expect to continue enhancing this
 * system and expect to make other tools available as they are
 * completed.
 * <p>
 * The ANTLR gang:
 * @version ANTLR 2.6.0 MageLang Insitute, 1998
 * @author Terence Parr, <a href=http://www.MageLang.com>MageLang Institute</a>
 * @author <br>John Lilley, <a href=http://www.Empathy.com>Empathy Software</a>
 * @author <br><a href="mailto:pete@yamuna.demon.co.uk">Pete Wells</a>
 */

#include "NoViableAltException.hpp"
#include "String.hpp"

ANTLR_BEGIN_NAMESPACE(antlr)

NoViableAltException::NoViableAltException(RefAST t)
: RecognitionException("NoViableAlt")
, token(0)
, node(t)
{
	fileName = "<AST>";
}

NoViableAltException::NoViableAltException(RefToken t,const ANTLR_USE_NAMESPACE(std)string& fileName_)
: RecognitionException("NoViableAlt") // line ")+t.getLine()+" token is "+t.getText())
, token(t)
, node(nullASTptr)
{
	line = t->getLine();
	column = t->getColumn();
	fileName = fileName_;
}

ANTLR_USE_NAMESPACE(std)string NoViableAltException::getErrorMessage() const
{
	return getMessage();
}

ANTLR_USE_NAMESPACE(std)string NoViableAltException::getMessage() const
{
	if (token)
		return ANTLR_USE_NAMESPACE(std)string("unexpected token: ")+token->getText();

	// must a tree parser error if token==null
	if (!node) {
		return "unexpected end of subtree";
	}
	return ANTLR_USE_NAMESPACE(std)string("unexpected AST node: ")+node->toString();
}

ANTLR_USE_NAMESPACE(std)string NoViableAltException::toString() const
{
	if (token)
		return getFileLineString()+getMessage();
	else
		return getMessage();
}

ANTLR_END_NAMESPACE

