###############################################################################
# OpenVAS Vulnerability Test
# $Id: wordpress_37005.nasl 7592 2010-05-07 14:44:11Z chandra $
#
# WordPress 'wp-admin/includes/file.php' Arbitrary File Upload Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100345);
 script_bugtraq_id(37005);
 script_version ("1.0-$Revision: 7592 $");
 script_tag(name:"risk_factor", value:"High");

 script_name("WordPress 'wp-admin/includes/file.php' Arbitrary File Upload Vulnerability");

desc = "Overview:
WordPress is prone to a vulnerability that lets attackers upload
arbitrary files. The issue occurs because the application fails to
adequately sanitize user-supplied input.

An attacker can exploit this vulnerability to upload arbitrary code
and run it in the context of the webserver process. This may
facilitate unauthorized access or privilege escalation; other attacks
are also possible.

Note that this issue only arises in certain Apache configurations that
are using the Add* directives and PHP to facilitate handling of files
with multiple extensions.

WordPress 2.8.5 and prior versions are vulnerable.

Solution:
Updates are available. Please see the references for more information.

References:
http://www.securityfocus.com/bid/37005
http://wordpress.org/
http://www.securityfocus.com/archive/1/507819
http://wordpress.org/development/2009/11/wordpress-2-8-6-security-release/

Risk factor : High";

 script_description(desc);
 script_summary("Determine if WordPress version is < 2.8.6");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("secpod_wordpress_detect_900182.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/WordPress")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less(version: vers, test_version: "2.8.6")) {
      security_hole(port:port);
      exit(0);
  }

}

exit(0);
