# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-787-1 (apache2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64201);
 script_cve_id("CVE-2009-0023", "CVE-2009-1191", "CVE-2009-1195", "CVE-2009-1955", "CVE-2009-1956");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Ubuntu USN-787-1 (apache2)";
 script_name(name);

 desc = "The remote host is missing an update to apache2
announced via advisory USN-787-1.

Details follow:

Matthew Palmer discovered an underflow flaw in apr-util as included in
Apache. An attacker could cause a denial of service via application crash
in Apache using a crafted SVNMasterURI directive, .htaccess file, or when
using mod_apreq2. This issue only affected Ubuntu 6.06 LTS. (CVE-2009-0023)

Sander de Boer discovered that mod_proxy_ajp would reuse connections when
a client closed a connection without sending a request body. A remote
attacker could exploit this to obtain sensitive response data. This issue
only affected Ubuntu 9.04. (CVE-2009-1191)

Jonathan Peatfield discovered that Apache did not process Includes options
correctly. With certain configurations of Options and AllowOverride, a
local attacker could use an .htaccess file to override intended
restrictions and execute arbitrary code via a Server-Side-Include file.
This issue affected Ubuntu 8.04 LTS, 8.10 and 9.04. (CVE-2009-1195)

It was discovered that the XML parser did not properly handle entity
expansion. A remote attacker could cause a denial of service via memory
resource consumption by sending a crafted request to an Apache server
configured to use mod_dav or mod_dav_svn. This issue only affected Ubuntu
6.06 LTS. (CVE-2009-1955)

C. Michael Pilato discovered an off-by-one buffer overflow in apr-util when
formatting certain strings. For big-endian machines (powerpc, hppa and
sparc in Ubuntu), a remote attacker could cause a denial of service or
information disclosure leak. All other architectures for Ubuntu are not
considered to be at risk. This issue only affected Ubuntu 6.06 LTS.
(CVE-2009-1956)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  apache2-common                  2.0.55-4ubuntu2.5
  apache2-mpm-perchild            2.0.55-4ubuntu2.5
  apache2-mpm-prefork             2.0.55-4ubuntu2.5
  apache2-mpm-worker              2.0.55-4ubuntu2.5
  libapr0                         2.0.55-4ubuntu2.5

Ubuntu 8.04 LTS:
  apache2-mpm-event               2.2.8-1ubuntu0.8
  apache2-mpm-perchild            2.2.8-1ubuntu0.8
  apache2-mpm-prefork             2.2.8-1ubuntu0.8
  apache2-mpm-worker              2.2.8-1ubuntu0.8
  apache2.2-common                2.2.8-1ubuntu0.8

Ubuntu 8.10:
  apache2-mpm-event               2.2.9-7ubuntu3.1
  apache2-mpm-prefork             2.2.9-7ubuntu3.1
  apache2-mpm-worker              2.2.9-7ubuntu3.1
  apache2.2-common                2.2.9-7ubuntu3.1

Ubuntu 9.04:
  apache2-mpm-event               2.2.11-2ubuntu2.1
  apache2-mpm-prefork             2.2.11-2ubuntu2.1
  apache2-mpm-worker              2.2.11-2ubuntu2.1
  apache2.2-common                2.2.11-2ubuntu2.1

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-787-1

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-787-1 (apache2)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"apache2-doc", ver:"2.0.55-4ubuntu2.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-common", ver:"2.0.55-4ubuntu2.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-perchild", ver:"2.0.55-4ubuntu2.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.0.55-4ubuntu2.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.0.55-4ubuntu2.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.0.55-4ubuntu2.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.0.55-4ubuntu2.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-utils", ver:"2.0.55-4ubuntu2.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2", ver:"2.0.55-4ubuntu2.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapr0-dev", ver:"2.0.55-4ubuntu2.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapr0", ver:"2.0.55-4ubuntu2.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-doc", ver:"2.2.8-1ubuntu0.8", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-perchild", ver:"2.2.8-1ubuntu0.8", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-src", ver:"2.2.8-1ubuntu0.8", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2", ver:"2.2.8-1ubuntu0.8", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-event", ver:"2.2.8-1ubuntu0.8", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.2.8-1ubuntu0.8", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.2.8-1ubuntu0.8", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.2.8-1ubuntu0.8", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.2.8-1ubuntu0.8", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-utils", ver:"2.2.8-1ubuntu0.8", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2.2-common", ver:"2.2.8-1ubuntu0.8", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-doc", ver:"2.2.9-7ubuntu3.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-src", ver:"2.2.9-7ubuntu3.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2", ver:"2.2.9-7ubuntu3.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-event", ver:"2.2.9-7ubuntu3.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.2.9-7ubuntu3.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.2.9-7ubuntu3.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.2.9-7ubuntu3.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-suexec-custom", ver:"2.2.9-7ubuntu3.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-suexec", ver:"2.2.9-7ubuntu3.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.2.9-7ubuntu3.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-utils", ver:"2.2.9-7ubuntu3.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2.2-common", ver:"2.2.9-7ubuntu3.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-doc", ver:"2.2.11-2ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2", ver:"2.2.11-2ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-src", ver:"2.2.11-2ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-event", ver:"2.2.11-2ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.2.11-2ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.2.11-2ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.2.11-2ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.2.11-2ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-utils", ver:"2.2.11-2ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2.2-common", ver:"2.2.11-2ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-suexec-custom", ver:"2.2.11-2ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-suexec", ver:"2.2.11-2ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
