# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-778-1 (cron)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64142);
 script_cve_id("CVE-2006-2607");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 name = "Ubuntu USN-778-1 (cron)";
 script_name(name);

 desc = "The remote host is missing an update to cron
announced via advisory USN-778-1.

Details follow:

It was discovered that cron did not properly check the return code of
the setgid() and initgroups() system calls. A local attacker could use
this to escalate group privileges. Please note that cron versions 3.0pl1-64
and later were already patched to address the more serious setuid() check
referred to by CVE-2006-2607.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  cron                            3.0pl1-92ubuntu1.1

Ubuntu 8.04 LTS:
  cron                            3.0pl1-100ubuntu2.1

Ubuntu 8.10:
  cron                            3.0pl1-104+ubuntu5.1

Ubuntu 9.04:
  cron                            3.0pl1-105ubuntu1.1

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-778-1

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-778-1 (cron)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cron", ver:"3.0pl1-92ubuntu1.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cron", ver:"3.0pl1-100ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cron", ver:"3.0pl1-104+ubuntu5.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cron", ver:"3.0pl1-105ubuntu1.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
