# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-723-1 (git-core)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64168);
 script_cve_id("CVE-2008-3546", "CVE-2008-5516", "CVE-2008-5517", "CVE-2008-5916", "CVE-2008-3974", "CVE-2009-0318", "CVE-2008-5984", "CVE-2009-0352", "CVE-2009-0353", "CVE-2009-0354", "CVE-2009-0355", "CVE-2009-0356", "CVE-2009-0357", "CVE-2009-0358", "CVE-2009-0316", "CVE-2008-5557", "CVE-2008-5658", "CVE-2008-5624", "CVE-2008-5625", "CVE-2008-5985", "CVE-2009-0544", "CVE-2008-3964", "CVE-2008-5907", "CVE-2009-0040", "CVE-2008-1232", "CVE-2008-1947", "CVE-2008-2370", "CVE-2009-0520", "CVE-2008-4810", "CVE-2008-3663", "CVE-2007-5624", "CVE-2008-1360", "CVE-2007-5803", "CVE-2009-0187", "CVE-2007-3698", "CVE-2007-3922", "CVE-2008-5263", "CVE-2009-0615", "CVE-2009-0616", "CVE-2009-0617", "CVE-2009-0618", "CVE-2009-0620", "CVE-2009-0621", "CVE-2009-0622", "CVE-2009-0623", "CVE-2009-0624", "CVE-2009-0625", "CVE-2009-0490", "CVE-2009-0614", "CVE-2009-0542", "CVE-2009-0543", "CVE-2009-0478");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Ubuntu USN-723-1 (git-core)";
 script_name(name);

 desc = "The remote host is missing an update to git-core
announced via advisory USN-723-1.

Details follow:

It was discovered that Git did not properly handle long file paths. If a user
were tricked into performing commands on a specially crafted Git repository, an
attacker could possibly execute arbitrary code with the privileges of the user
invoking the program. (CVE-2008-3546)

It was discovered that the Git web interface (gitweb) did not correctly handle
shell metacharacters when processing certain commands. A remote attacker could
send specially crafted commands to the Git server and execute arbitrary code
with the privileges of the Git web server. This issue only applied to Ubuntu
7.10 and 8.04 LTS. (CVE-2008-5516, CVE-2008-5517)

It was discovered that the Git web interface (gitweb) did not properly restrict
the diff.external configuration parameter. A local attacker could exploit this
issue and execute arbitrary code with the privileges of the Git web server.
This issue only applied to Ubuntu 8.04 LTS and 8.10. (CVE-2008-5916)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  git-core                        1.1.3-1ubuntu1.1

Ubuntu 7.10:
  git-core                        1:1.5.2.5-2ubuntu0.1
  gitweb                          1:1.5.2.5-2ubuntu0.1

Ubuntu 8.04 LTS:
  git-core                        1:1.5.4.3-1ubuntu2.1
  gitweb                          1:1.5.4.3-1ubuntu2.1

Ubuntu 8.10:
  git-core                        1:1.5.6.3-1.1ubuntu2.1
  gitweb                          1:1.5.6.3-1.1ubuntu2.1

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-723-1

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-723-1 (git-core)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"git-doc", ver:"1.1.3-1ubuntu1.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-email", ver:"1.1.3-1ubuntu1.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gitk", ver:"1.1.3-1ubuntu1.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-arch", ver:"1.1.3-1ubuntu1.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-cvs", ver:"1.1.3-1ubuntu1.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-svn", ver:"1.1.3-1ubuntu1.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-core", ver:"1.1.3-1ubuntu1.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-doc", ver:"1.5.2.5-2ubuntu0.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gitk", ver:"1.5.2.5-2ubuntu0.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-arch", ver:"1.5.2.5-2ubuntu0.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-cvs", ver:"1.5.2.5-2ubuntu0.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-daemon-run", ver:"1.5.2.5-2ubuntu0.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-email", ver:"1.5.2.5-2ubuntu0.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-gui", ver:"1.5.2.5-2ubuntu0.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-p4", ver:"1.5.2.5-2ubuntu0.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-svn", ver:"1.5.2.5-2ubuntu0.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gitweb", ver:"1.5.2.5-2ubuntu0.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-core", ver:"1.5.2.5-2ubuntu0.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-doc", ver:"1.5.4.3-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gitk", ver:"1.5.4.3-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-arch", ver:"1.5.4.3-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-cvs", ver:"1.5.4.3-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-daemon-run", ver:"1.5.4.3-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-email", ver:"1.5.4.3-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-gui", ver:"1.5.4.3-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-svn", ver:"1.5.4.3-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gitweb", ver:"1.5.4.3-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-core", ver:"1.5.4.3-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-doc", ver:"1.5.6.3-1.1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gitk", ver:"1.5.6.3-1.1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-arch", ver:"1.5.6.3-1.1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-cvs", ver:"1.5.6.3-1.1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-daemon-run", ver:"1.5.6.3-1.1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-email", ver:"1.5.6.3-1.1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-gui", ver:"1.5.6.3-1.1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-svn", ver:"1.5.6.3-1.1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gitweb", ver:"1.5.6.3-1.1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-core", ver:"1.5.6.3-1.1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-crypto-dbg", ver:"2.0.1+dfsg1-2.3+lenny0", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-crypto", ver:"2.0.1+dfsg1-2.3+lenny0", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-doc", ver:"1.3.1-17lenny1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd", ver:"1.3.1-17lenny1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-basic", ver:"1.3.1-17lenny1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-mod-ldap", ver:"1.3.1-17lenny1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-mod-mysql", ver:"1.3.1-17lenny1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-mod-pgsql", ver:"1.3.1-17lenny1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid-common", ver:"2.7.STABLE3-1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid", ver:"2.7.STABLE3-1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid-cgi", ver:"2.7.STABLE3-1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
