###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_usebb_bbcode_dos_vuln.nasl 5850 2009-11-24 15:09:31Z nov $
#
# UseBB BBcode Parsing Remote Denial Of Service Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901057);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-4041");
  script_bugtraq_id(37010);
  script_name("UseBB BBcode Parsing Remote Denial Of Service Vulnerability");
  desc = "
  Overview: This host has UseBB installed and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  This issue is caused due to infinite loops while parsing for malformed
  BBcode.

  Impact:
  Successfull exploitation will allow remote attackers to execute arbitrary
  code and cause Denial-of-Service by posting a message containing specially
  crafted BBcode.

  Impact Level: Applicatioin.

  Affected Software/OS:
  UseBB version 1.0.9 and prior on all platforms.

  Fix: Upgrade to UseBB version 1.0.10
  For Updates Refer, http://www.usebb.net/downloads/

  References:
  http://secunia.com/advisories/37328
  http://www.vupen.com/english/advisories/2009/3222
  http://www.usebb.net/community/topic-post9775.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of UseBB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_usebb_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

usebbPort = get_http_port(default:80);
if(!usebbPort){
  exit(0);
}

usebbVer = get_kb_item("www/"+ usebbPort + "/UseBB");
if(!usebbVer){
  exit(0);
}

usebbVer = eregmatch(pattern:"^(.+) under (/.*)$", string:usebbVer);
if(usebbVer[1])
{
  # Check for UseBB version prior to 1.0.10
  if(version_is_less(version:usebbVer[1], test_version:"1.0.10")){
    security_warning(usebbPort);
  }
}
