###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_trendmicro_officescan_dos_vuln.nasl 1993 2009-04-28 20:07:05Z apr $
#
# Trend Micro OfficeScan Client Denial Of Service Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 # GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
##############################################################################

if(description)
{
  script_id(900634);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"2.1");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-1435");
  script_bugtraq_id(34642);
  script_name("Trend Micro OfficeScan Client Denial Of Service Vulnerability");
  desc = "

  Overview:
  This host is installed with Trend Micro OfficeScan Client and is prone to
  Denial of Service Vulnerability.

  Vulnerability Insight:
  This flaw is caused due to an error while scanning directories as it fails to
  handle nested directories with excessively long names.

  Impact:
  Successful exploitation will let the attacker terminate 'NTRtScan.exe' process
  and temporarily disable the real time scanning protection for the system by
  crafting a directory.

  Impact Level: System/Application

  Affected Software/OS:
  Trend Micro OfficeScan 8.0 Service Pack 1

  Fix: Upgrade to Trend Micro OfficeScan 10 or later,
  For updates refer, http://www.trendmicro.com/download/engine.asp

  References:
  http://osvdb.org/53890
  http://secunia.com/advisories/34737
  http://www.vupen.com/english/advisories/2009/1146
  http://www.securityfocus.com/archive/1/archive/1/502847/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 2.1 (AV:L/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 1.9
  Risk factor :Low";

  script_description(desc);
  script_summary("Check for the version of Trend Micro OfficeScan");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");
include("version_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\TrendMicro\NSC\PFW";
if(!registry_key_exists(key:key)){
  exit(0);
}

scanPath = registry_get_sz(key:key, item:"InstallPath");
if(!scanPath){
  exit(0);
}

scanPath += "PccNTMon.exe";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:scanPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:scanPath);

fileVer = GetVer(file:file, share:share);
if(fileVer != NULL)
{
  # OfficeScan 8.0 build 3110 and prior (SP1 Patch 1/8.0.0.3110)
  if(version_is_less_equal(version:fileVer, test_version:"8.0.0.3110")){
    security_warning(0);
  }
}
