###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_mcafee_prdts_sec_bypass_vuln_lin.nasl 2119 2009-05-22 21:07:05Z may $
#
# McAfee Products Security Bypass Vulnerability (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
##############################################################################

if(description)
{
  script_id(900359);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.6");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-1348");
  script_bugtraq_id(34780);
  script_name("McAfee Products Security Bypass Vulnerability (Linux)");
  desc = "

  Overview: This host is installed with McAfee products and are prone to
  Security Bypass vulnerability.

  Vulnerability Insight:
  Error in AV Engine fails to handle specially crafted packets via,
  - an invalid Headflags and Packsize fields in a malformed RAR archive.
  - an invalid Filelength field in a malformed ZIP archive.

  Impact:
  Successful exploitation will let the attackers to bypass the anti-virus
  scanning and distribute files containing malicious code that the antivirus
  application will fail to detect.

  Impact Level: System/Application

  Affected Software/OS:
  McAfee VirusScan Command Line
  McAfee VirusScan Enterprise Linux
  McAfee software that uses DAT files prior to 5600 on Linux

  Fix:
  Updates are available through DAT files 5600 or later
  http://www.mcafee.com/apps/downloads/security_updates/dat.asp

  References:
  http://secunia.com/advisories/34949
  http://blog.zoller.lu/2009/04/case-for-av-bypassesevasions.html
  http://blog.zoller.lu/2009/04/mcafee-multiple-bypassesevasions-ziprar.html
  https://kc.mcafee.com/corporate/index?page=content&id=SB10001&actp=LIST_RECENT

  CVSS Score:
    CVSS Base Score     : 7.6 (AV:N/AC:H/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.0
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Scan Engine DAT file");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

datPath = find_bin(prog_name:"uvscan_secure", sock:sock);
foreach path (datPath)
{
  ver = ssh_cmd(cmd:string(chomp(path)+ " --version"), socket:sock, timeout:60);

  datVer = eregmatch(pattern:"Virus data file v([0-9]{4})",
                     string:strstr(ver, "Virus data file v"));
  if(datVer[1] != NULL)
  {
    if(version_is_less(version:datVer[1], test_version:"5600"))
    {
      security_warning(0);
      ssh_close_connection();
      exit(0);
    }
  }
}
ssh_close_connection();
