###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_apple_safari_js_info_disc_vuln.nasl 877 2009-01-23 12:16:43Z Jan $
#
# Apple Safari JavaScript Engine Cross Domain Information Disclosure Vulnerability
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900075);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"2.1");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2008-5914");
  script_bugtraq_id(33276);
  script_name("Apple Safari JavaScript Engine Cross Domain Information Disclosure Vulnerability");
  desc = "

  Overview: The host is running Apple Safari web browser which is prone
  to information disclosure vulnerability.

  Vulnerability Insight:
  Undefined function in the JavaScript implementation of the browser fails
  to properly enforce the origin policy and leaves temporary footprints.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes in
  the context of the web browser and can spoof sensitive information of the
  remote user through the web browser.

  Impact Level: Application

  Affected Software/OS:
  Apple Safari 3.1.2 and prior on Windows.

  Fix: Upgrade to Apple Safari version 5.0 or later
  For updates refer, http://www.apple.com/support/downloads

  References:
  http://www.trusteer.com/files/In-session-phishing-advisory-2.pdf

  CVSS Score:
    CVSS Base Score     : 2.1 (AV:N/AC:H/Au:SI/C:N/I:P/A:N)
    CVSS Temporal Score : 1.8
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Apple Safari");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_apple_safari_detect_win_900003.nasl");
  script_require_keys("AppleSafari/Version");
  exit(0);
}


include("version_func.inc");

safariVer = get_kb_item("AppleSafari/Version");
if(!safariVer){
  exit(0);
}

if(version_is_less_equal(version:safariVer, test_version:"3.525.21.0")){
  security_warning(0);
}
