##############################################################################
#
#  Apple Safari Detect Script (Windows)
#
#  Date Written: 2008/07/07
#
#  Revision: 1.2 
#
#  Log: Apple Safari version Detection Script.
#  Issue #0010 schandan
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900003);
 script_copyright("Copyright 2008 SecPod");
 script_version("Revision: 1.2 ");
  script_tag(name:"risk_factor", value:"None");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_name("Apple Safari Detect Script (Windows)");
 script_summary("Check for Apple Safari version");
 desc = "
 The script detects the version of Apple Safari on remote host and
 sets KB.
 
 Risk factor : None";
 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl", "smb_registry_access.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
 	exit(0);
 }

 if(!registry_key_exists(key:"SOFTWARE\Apple Computer, Inc.")){
        exit(0);
 }

 name   =  kb_smb_name();
 login  =  kb_smb_login();
 pass   =  kb_smb_password();
 domain =  kb_smb_domain();
 port   =  kb_smb_transport();
 
 soc = open_sock_tcp(port);
 if(!soc){
        exit(0);
 }
 
 r = smb_session_request(soc:soc, remote:name);
 if(!r)
 {
	close(soc);
        exit(0);
 }
 
 prot = smb_neg_prot(soc:soc);
 if(!prot)
 {
	close(soc);
        exit(0);
 }
 
 r = smb_session_setup(soc:soc, login:login, password:pass,
                       domain:domain, prot:prot);
 if(!r)
 {
	close(soc);
        exit(0);
 }
 
 uid = session_extract_uid(reply:r);
 r = smb_tconx(soc:soc, name:name, uid:uid, share:"IPC$");
 tid = tconx_extract_tid(reply:r);
 if(!tid)
 {
	close(soc);
        exit(0);
 }

 r = smbntcreatex(soc:soc, uid:uid, tid:tid, name:"\winreg");
 if(!r)
 {
        close(soc);
        exit(0);
 }

 pipe = smbntcreatex_extract_pipe(reply:r);
 if(!pipe)
 {
 	close(soc);
 	exit(0);
 }

 r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!r)
 {
	close(soc);
	exit(0);
 }

 handle = registry_open_hklm(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!handle)
 {
	close(soc);
	exit(0);
 }

 key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

 key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe,
			  key:key, reply:handle);
 if(key_h)
 {
	entries = registry_enum_key(soc:soc, uid:uid, tid:tid,
				    pipe:pipe, reply:key_h);
	close(soc);
  	foreach entry (entries)
  	{
		safariName = registry_get_sz(item:"DisplayName",
			     		     key:key + entry);
		if("Safari" >< safariName)
		{
			safariVer = registry_get_sz(item:"DisplayVersion",
                                                    key:key + entry);
			if(safariVer){
				set_kb_item(name:"AppleSafari/Version",
                                 	    value:safariVer);
                                security_note(data:"Apple Safari Version " +
                                      safariVer + " was detected on the host");
                	}
			exit(0);
		}
        }
 }
