##############################################################################
#
#  Apple iTunes Version Detection for Windows
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/12
#
#  Revision: 1.1 
#
#  Log: ssharath
#  Issue #0191
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
 script_id(900123);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
  script_tag(name:"risk_factor", value:"None");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_name("Apple iTunes Version Detection for Windows");
 script_summary("Set File Version of Apple iTunes in KB");
 desc = "
 Overview : This script finds the Apple iTunes installed version of windows 
 from the registry and saves the version in KB.
 
 Risk factor : None";

 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");
 include("secpod_smb_func.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
 	exit(0);
 }

 name = kb_smb_name();
 domain = kb_smb_domain();
 login = kb_smb_login();
 pass = kb_smb_password();
 port = kb_smb_transport();
 
 soc = open_sock_tcp(port);
 if(!soc){
        exit(0);
 }
 
 r = smb_session_request(soc:soc, remote:name);
 if(!r){
        close(soc);
        exit(0);
 }
 
 prot = smb_neg_prot(soc:soc);
 if(!prot){
        close(soc);
        exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain,
                           prot:prot);
 if(!r){
        close(soc);
        exit(0);
 }

 uid = session_extract_uid(reply:r);
 r = smb_tconx(soc:soc, name:name, uid:uid, share:"IPC$");
 
 tid = tconx_extract_tid(reply:r);
 if(!tid){
        close(soc);
        exit(0);
 }
 
 r = smbntcreatex(soc:soc, uid:uid, tid:tid, name:"\winreg");
 if(!r){
        close(soc);
        exit(0);
 }
 
 pipe = smbntcreatex_extract_pipe(reply:r);
 if(!pipe){
        close(soc);
        exit(0);
 }

 r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!r){
        close(soc);
        exit(0);
 }

 handle = registry_open_hklm(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!handle){
        close(soc);
        exit(0);
 }

 key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
 key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe, key:key,
                              reply:handle);
 if(!key_h){
        close(soc);
        exit(0);
 }

 entries = registry_enum_key(soc:soc, uid:uid, tid:tid, pipe:pipe, reply:key_h);
 close(soc);

 foreach entry (entries)
 {
        iTunesName = registry_get_sz(key:key + entry, item:"DisplayName");

        if("iTunes" >< iTunesName)
        {
                iTunesVer = registry_get_sz(key:key + entry,
                                                item:"DisplayVersion");
                if(iTunesVer){
                        set_kb_item(name:"iTunes/Win/Ver", value:iTunesVer);
                        security_note(data:"Apple iTunes version " + iTunesVer
                                                + " was detected on the host");
                }
                exit(0);
        }
 }
