###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_apache_mod_proxy_ftp_cmd_inj_vuln.nasl 4624 2009-09-15 16:34:29Z sep $
#
# Apache 'mod_proxy_ftp' Module Command Injection Vulnerability (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900842);
  script_version("$Revision: 1.0$");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-3095");
  script_bugtraq_id(36254);
  script_name("Apache 'mod_proxy_ftp' Module Command Injection Vulnerability (Linux)");
  desc = "
  Overview: The host is running Apache and is prone to Command Injection
  vulnerability.

  Vulnerability Insight:
  The flaw is due to error in the mod_proxy_ftp module which can be exploited
  via vectors related to the embedding of these commands in the Authorization
  HTTP header.

  Impact:
  Successful exploitation could allow remote attackers to bypass intended access
  restrictions in the context of the affected application, and can cause the
  arbitrary command injection.

  Impact Level: Application

  Affected Software/OS:
  Apache HTTP Server on Linux.

  Fix: Upgrade to Apache HTTP Server version 2.2.15 or later
  For updates refer, http://www.apache.org/

  References:
  http://intevydis.com/vd-list.shtml
  http://httpd.apache.org/docs/2.0/mod/mod_proxy_ftp.html

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Apache");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("http_version.nasl", "find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

apachePort = get_http_port(default:80);
if(!apachePort){
  apachePort = 80;
}

if(!get_port_state(apachePort))
{
  exit(0);
}

banner = get_http_banner(port:apachePort);
if(banner =~ "Apache/([0-9.]+) \(Win32\)")
{
  exit(0);
}

apacheVer = eregmatch(pattern:"Server: Apache/([0-9.]+)", string:banner);
if(apacheVer[1] != NULL)
{
  # Grep for Apache version <= 1.3.41 or 2.0 <= 2.0.63 or 2.1 <= 2.2.13
  if(version_is_less_equal(version:apacheVer[1], test_version:"1.3.41") ||
     version_in_range(version:apacheVer[1], test_version:"2.0", test_version2:"2.0.63")||
     version_in_range(version:apacheVer[1], test_version:"2.1", test_version2:"2.2.13")){
     security_hole(apachePort);
  }
}
