###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for python-qt4 MDVA-2010:080 (python-qt4)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830910);
  script_version("$Revision: 7452 $: 1.0");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDVA", value: "2010:080");
  script_name("Mandriva Update for python-qt4 MDVA-2010:080 (python-qt4)");
  desc = "

  Vulnerability Insight:

  python-qt4 packages released for Mandriva 2009.0 as update are
  in a higher version than python-qt4 released in Mandriva 2009
  Spring. This breaks the kde-python part on a 2009.0 to 2009 Spring
  system upgrade. This fixes it by releasing updated python packages
  with a higher release number on Mandriva 2009 Spring.

  Affected Software/OS:
  python-qt4 on Mandriva Linux 2009.1,
  Mandriva Linux 2009.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-02/msg00058.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of python-qt4");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2009.1")
{

  if(isrpmvuln(pkg:"falcon-kde4", rpm:"falcon-kde4~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kimono", rpm:"kimono~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kimono-devel", rpm:"kimono-devel~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtruby4shared2", rpm:"libqtruby4shared2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqyotoshared1", rpm:"libqyotoshared1~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmokeakonadi2", rpm:"libsmokeakonadi2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmokekde2", rpm:"libsmokekde2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmokekhtml2", rpm:"libsmokekhtml2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmokenepomuk2", rpm:"libsmokenepomuk2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmokeplasma2", rpm:"libsmokeplasma2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmokeqsci2", rpm:"libsmokeqsci2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmokeqt2", rpm:"libsmokeqt2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmokeqtscript2", rpm:"libsmokeqtscript2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmokeqttest2", rpm:"libsmokeqttest2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmokeqtuitools2", rpm:"libsmokeqtuitools2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmokeqtwebkit2", rpm:"libsmokeqtwebkit2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmokesolid2", rpm:"libsmokesolid2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmokesoprano2", rpm:"libsmokesoprano2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmoketexteditor2", rpm:"libsmoketexteditor2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-qt4", rpm:"php-qt4~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-kde4", rpm:"python-kde4~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-kde4-doc", rpm:"python-kde4-doc~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-qt4", rpm:"python-qt4~4.5.2~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-qt4-assistant", rpm:"python-qt4-assistant~4.5.2~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-qt4-core", rpm:"python-qt4-core~4.5.2~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-qt4-designer", rpm:"python-qt4-designer~4.5.2~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-qt4-devel", rpm:"python-qt4-devel~4.5.2~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-qt4-gui", rpm:"python-qt4-gui~4.5.2~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-qt4-help", rpm:"python-qt4-help~4.5.2~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-qt4-network", rpm:"python-qt4-network~4.5.2~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-qt4-opengl", rpm:"python-qt4-opengl~4.5.2~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-qt4-script", rpm:"python-qt4-script~4.5.2~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-qt4-scripttools", rpm:"python-qt4-scripttools~4.5.2~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-qt4-sql", rpm:"python-qt4-sql~4.5.2~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-qt4-svg", rpm:"python-qt4-svg~4.5.2~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-qt4-test", rpm:"python-qt4-test~4.5.2~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-qt4-webkit", rpm:"python-qt4-webkit~4.5.2~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-qt4-xml", rpm:"python-qt4-xml~4.5.2~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-qt4-xmlpatterns", rpm:"python-qt4-xmlpatterns~4.5.2~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-sip", rpm:"python-sip~4.8.1~0.2mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qyoto", rpm:"qyoto~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qyoto-devel", rpm:"qyoto-devel~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-kde4", rpm:"ruby-kde4~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-kde4-devel", rpm:"ruby-kde4-devel~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-qt4", rpm:"ruby-qt4~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-qt4-devel", rpm:"ruby-qt4-devel~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"smoke4-devel", rpm:"smoke4-devel~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebindings4", rpm:"kdebindings4~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtruby4shared2", rpm:"lib64qtruby4shared2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qyotoshared1", rpm:"lib64qyotoshared1~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smokeakonadi2", rpm:"lib64smokeakonadi2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smokekde2", rpm:"lib64smokekde2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smokekhtml2", rpm:"lib64smokekhtml2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smokenepomuk2", rpm:"lib64smokenepomuk2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smokeplasma2", rpm:"lib64smokeplasma2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smokeqsci2", rpm:"lib64smokeqsci2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smokeqt2", rpm:"lib64smokeqt2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smokeqtscript2", rpm:"lib64smokeqtscript2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smokeqttest2", rpm:"lib64smokeqttest2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smokeqtuitools2", rpm:"lib64smokeqtuitools2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smokeqtwebkit2", rpm:"lib64smokeqtwebkit2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smokesolid2", rpm:"lib64smokesolid2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smokesoprano2", rpm:"lib64smokesoprano2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smoketexteditor2", rpm:"lib64smoketexteditor2~4.2.4~0.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}