###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for htdig FEDORA-2007-757
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861262);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "FEDORA", value: "2007-757");
  script_cve_id("CVE-2007-6110");
  script_name( "Fedora Update for htdig FEDORA-2007-757");
  desc = "

  Vulnerability Insight:
  The ht://Dig system is a complete world wide web indexing and searching
  system for a small domain or intranet. This system is not meant to replace
  the need for powerful internet-wide search systems like Lycos, Infoseek,
  Webcrawler and AltaVista. Instead it is meant to cover the search needs for
  a single company, campus, or even a particular sub section of a web site. As
  opposed to some WAIS-based or web-server based search engines, ht://Dig can
  span several web servers at a site. The type of these different web servers
  doesn't matter as long as they understand the HTTP 1.0 protocol.
  ht://Dig is also used by KDE to search KDE's HTML documentation.
  
  ht://Dig was developed at San Diego State University as a way to search the
  various web servers on the campus network.


  Affected Software/OS:
  htdig on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-December/msg00116.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of htdig");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"htdig", rpm:"htdig~3.2.0b6~9.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/htdig-web", rpm:"x86_64/htdig-web~3.2.0b6~9.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/htdig-debuginfo", rpm:"x86_64/debug/htdig-debuginfo~3.2.0b6~9.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/htdig", rpm:"x86_64/htdig~3.2.0b6~9.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/htdig-debuginfo", rpm:"i386/debug/htdig-debuginfo~3.2.0b6~9.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/htdig-web", rpm:"i386/htdig-web~3.2.0b6~9.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/htdig", rpm:"i386/htdig~3.2.0b6~9.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}