#
#VID 2bc960c4-e665-11dd-afcd-00e0815b8da8
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 2bc960c4-e665-11dd-afcd-00e0815b8da8
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63237);
 script_cve_id("CVE-2008-5101");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "FreeBSD Ports: optipng";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: optipng

CVE-2008-5101
Buffer overflow in the BMP reader in OptiPNG 0.6 and 0.6.1 allows
user-assisted attackers to execute arbitrary code via a crafted BMP
image, related to an 'array overflow.'

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/32651
http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=505399
http://optipng.sourceforge.net/
http://www.vuxml.org/freebsd/2bc960c4-e665-11dd-afcd-00e0815b8da8.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: optipng";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"optipng");
if(!isnull(bver) && revcomp(a:bver, b:"0.6.2")<0) {
    security_note(0, data:"Package optipng version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
