# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-7961 (blam)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64468);
 script_cve_id("CVE-2009-2463", "CVE-2009-2464", "CVE-2009-2465", "CVE-2009-2462", "CVE-2009-2466", "CVE-2009-2467", "CVE-2009-2469", "CVE-2009-2471", "CVE-2009-2472");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Fedora Core 10 FEDORA-2009-7961 (blam)");

 desc = "The remote host is missing an update to blam
announced via advisory FEDORA-2009-7961.

Update Information:

Update to new upstream Firefox version 3.0.12, fixing multiple security issues
detailed in the upstream advisories:
http://www.mozilla.org/security/known-vulnerabilities/firefox30.html#firefox3.0.12

Update also includes all packages depending on gecko-libs rebuilt against
new version of Firefox / XULRunner.

ChangeLog:

* Tue Jul 21 2009 Jan Horak  - 1.8.5-12
- Rebuild against newer gecko
* Thu Jun 11 2009 Christopher Aillon  - 1.8.5-11
- Rebuild against newer gecko

References:

[ 1 ] Bug #512131 - CVE-2009-2463 Mozilla Base64 decoding crash
https://bugzilla.redhat.com/show_bug.cgi?id=512131
[ 2 ] Bug #512133 - CVE-2009-2464 Mozilla crash with multiple RDFs in XUL tree
https://bugzilla.redhat.com/show_bug.cgi?id=512133
[ 3 ] Bug #512135 - CVE-2009-2465 Mozilla double frame construction crashes
https://bugzilla.redhat.com/show_bug.cgi?id=512135
[ 4 ] Bug #512128 - CVE-2009-2462 Mozilla Browser engine crashes
https://bugzilla.redhat.com/show_bug.cgi?id=512128
[ 5 ] Bug #512136 - CVE-2009-2466 Mozilla JavaScript engine crashes
https://bugzilla.redhat.com/show_bug.cgi?id=512136
[ 6 ] Bug #512137 - CVE-2009-2467 Mozilla remote code execution during Flash player unloading
https://bugzilla.redhat.com/show_bug.cgi?id=512137
[ 7 ] Bug #512142 - CVE-2009-2469 Mozilla remote code execution using watch and __defineSetter__ on SVG element
https://bugzilla.redhat.com/show_bug.cgi?id=512142
[ 8 ] Bug #512146 - CVE-2009-2471 Mozilla setTimeout loses XPCNativeWrappers
https://bugzilla.redhat.com/show_bug.cgi?id=512146
[ 9 ] Bug #512147 - CVE-2009-2472 Mozilla multiple cross origin wrapper bypasses
https://bugzilla.redhat.com/show_bug.cgi?id=512147

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update blam' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-7961

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-7961 (blam)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"blam", rpm:"blam~1.8.5~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"blam-debuginfo", rpm:"blam-debuginfo~1.8.5~12.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
