# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-5572 (eggdrop)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64083);
 script_cve_id("CVE-2007-2807", "CVE-2009-1789");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 10 FEDORA-2009-5572 (eggdrop)";
 script_name(name);

 desc = "The remote host is missing an update to eggdrop
announced via advisory FEDORA-2009-5572.

Update Information:

mod/server.mod/servmsg.c in Eggheads Eggdrop and Windrop 1.6.19 and earlier
allows remote attackers to cause a denial of service (crash) via a crafted
PRIVMSG that causes an empty string to trigger a negative string length copy.
NOTE: this issue exists because of an incorrect fix for CVE-2007-2807. The
current remote denial of service is tracked as CVE-2009-1789.

ChangeLog:

* Tue May 26 2009 Robert Scheck  1.6.19-4
- Added upstream ctcpfix to solve CVE-2009-1789 (#502650)

References:

[ 1 ] Bug #502650 - CVE-2009-1789 eggdrop DoS (crash)
https://bugzilla.redhat.com/show_bug.cgi?id=502650

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update eggdrop' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-5572

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-5572 (eggdrop)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"eggdrop", rpm:"eggdrop~1.6.19~4.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"eggdrop-debuginfo", rpm:"eggdrop-debuginfo~1.6.19~4.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
