# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1866-1 (kdegraphics)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64751);
 script_cve_id("CVE-2009-0945", "CVE-2009-1709");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Debian Security Advisory DSA 1866-1 (kdegraphics)");

 desc = "The remote host is missing an update to kdegraphics
announced via advisory DSA 1866-1.

Two security issues have been discovered in kdegraphics, the graphics
apps from the official KDE release. The Common Vulnerabilities and
Exposures project identifies the following problems:


CVE-2009-0945

It was discovered that the KSVG animation element implementation suffers
from a null pointer dereference flaw, which could lead to the execution
of arbitrary code.

CVE-2009-1709

It was discovered that the KSVG animation element implementation is
prone to a use-after-free flaw, which could lead to the execution of
arbitrary code.


For the stable distribution (lenny), these problems have been fixed in
version 4:3.5.9-3+lenny2.

For the oldstable distribution (etch), these problems have been fixed
in version 4:3.5.5-3etch4.

For the testing distribution (squeeze) and the unstable distribution
(sid), these problems have been fixed in version 4:4.0.


We recommend that you upgrade your kdegraphics packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201866-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1866-1 (kdegraphics)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kdegraphics", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics-doc-html", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics-dev", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kghostview", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kolourpaint", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kooka", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kmrml", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ksvg", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kpovmodeler", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kcoloredit", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kruler", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics-kfile-plugins", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ksnapshot", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kamera", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkscan1", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kfaxview", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kview", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdvi", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics-dbg", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kgamma", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kpdf", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kfax", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkscan-dev", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kviewshell", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kuickshow", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kiconedit", ver:"3.5.5-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics-doc-html", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kcoloredit", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics-dev", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kfax", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kooka", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ksnapshot", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics-kfile-plugins", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kviewshell", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kghostview", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kfaxview", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kview", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkscan1", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kmrml", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kolourpaint", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkscan-dev", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kpdf", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kamera", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdvi", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kruler", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics-dbg", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kgamma", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ksvg", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kuickshow", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kpovmodeler", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kiconedit", ver:"3.5.9-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
