# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1754-1 (roundup)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63796);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1754-1 (roundup)";
 script_name(name);

 desc = "The remote host is missing an update to roundup
announced via advisory DSA 1754-1.

It was discovered that roundup, an issue tracker with a command-line,
web and email interface, allows users to edit resources in
unauthorized ways, including granting themselves admin rights.

This update introduces stricter access checks, actually enforcing the
configured permissions and roles.  This means that the configuration
may need updating.  In addition, user registration via the web
interface has been disabled; use the program roundup-admin from the
command line instead.

For the old stable distribution (etch), this problem has been fixed in
version 1.2.1-10+etch1.

For the stable distribution (lenny), this problem has been fixed in
version 1.4.4-4+lenny1.

We recommend that you upgrade your roundup package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201754-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1754-1 (roundup)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"roundup", ver:"1.2.1-10+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"roundup", ver:"1.4.4-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
