# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1719-1 (gnutls13)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63392);
 script_cve_id("CVE-2008-4989");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1719-1 (gnutls13)";
 script_name(name);

 desc = "The remote host is missing an update to gnutls13
announced via advisory DSA 1719-1.

Martin von Gagern discovered that GNUTLS, an implementation of the
TLS/SSL protocol, handles verification of X.509 certificate chains
incorrectly if a self-signed certificate is configured as a trusted
certificate.  This could cause clients to accept forged server
certificates as genuine.  (CVE-2008-4989)

In addition, this update tightens the checks for X.509v1 certificates
which causes GNUTLS to reject certain certificate chains it accepted
before.  (In certificate chain processing, GNUTLS does not recognize
X.509v1 certificates as valid unless explicitly requested by the
application.)

For the stable distribution (etch), this problem has been fixed in
version 1.4.4-3+etch3.

For the unstable distribution (sid), this problem has been fixed in
version 2.4.2-3 of the gnutls26 package.

We recommend that you upgrade your gnutls13 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201719-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1719-1 (gnutls13)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gnutls-doc", ver:"1.4.4-3+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnutls13", ver:"1.4.4-3+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnutls13-dbg", ver:"1.4.4-3+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnutls-dev", ver:"1.4.4-3+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnutls-bin", ver:"1.4.4-3+etch3", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
