# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1629-2 (postfix)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61435);
 script_cve_id("CVE-2008-2936");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.2");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1629-2 (postfix)";
 script_name(name);

 desc = "The remote host is missing an update to postfix
announced via advisory DSA 1629-2.

Due to a version numbering problem, the Postfix update for DSA 1629 was
not installable on the i386 (Intel ia32) architecture. This update
increases the version number to make it installable on i386 aswell.
For reference the original advisory text is below.

Sebastian Krahmer discovered that Postfix, a mail transfer agent,
incorrectly checks the ownership of a mailbox. In some configurations,
this allows for appending data to arbitrary files as root.

Note that only specific configurations are vulnerable; the default
Debian installation is not affected. Only a configuration meeting
the following requirements is vulnerable:
* The mail delivery style is mailbox, with the Postfix built-in
local(8) or virtual(8) delivery agents.
* The mail spool directory (/var/spool/mail) is user-writeable.
* The user can create hardlinks pointing to root-owned symlinks
located in other directories.

For a detailed treating of the issue, please refer to the upstream
author's announcement:
http://article.gmane.org/gmane.mail.postfix.announce/110

For the stable distribution (etch), this problem has been fixed in
version 2.3.8-2+etch1.

For the testing distribution (lenny), this problem has been fixed in
version 2.5.2-2lenny1.

For the unstable distribution (sid), this problem has been fixed
in version 2.5.4-1.

We recommend that you upgrade your postfix package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201629-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1629-2 (postfix)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"postfix-doc", ver:"2.3.8-2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postfix-dev", ver:"2.3.8-2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postfix-pcre", ver:"2.3.8-2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postfix-mysql", ver:"2.3.8-2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postfix-cdb", ver:"2.3.8-2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postfix", ver:"2.3.8-2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postfix-ldap", ver:"2.3.8-2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postfix-pgsql", ver:"2.3.8-2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
